/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.pro;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import symantec.itools.db.net.BinaryInputStream;
import symantec.itools.db.net.BinaryOutputStream;
import symantec.itools.db.net.NetRecord;
import symantec.itools.db.pro.DataAccess;
import symantec.itools.db.pro.RecordSet;
import symantec.itools.db.pro.RelationView;
import symantec.itools.db.pro.RelationViewMetaData;

public class Record
implements DataAccess {
    private NetRecord _rec;
    private RelationView _rv;
    private RecordSet _block;
    private Hashtable _colNames;
    private InputStream _stream;
    public static final int DEFAULTSCALE = 0;
    public static final int SETBLANKTODEFAULT = 0;
    public static final int SETBLANKTONULL = 1;
    public static final int SETBLANKTOEMPTY = 2;
    public static final byte RECSTATE_EXISTING = 100;
    public static final byte RECSTATE_MODIFIED = 101;
    public static final byte RECSTATE_NEW = 102;
    public static final byte RECSTATE_DELETED = 103;
    public static final byte RECSTATE_DB_DELETED = 104;
    public static final byte RECSTATE_INVALID = 105;
    public static final byte RECSTATE_NEW_MODIFIED = 106;

    Record(NetRecord netRecord, Hashtable hashtable, RelationView relationView, RecordSet recordSet) {
        this._rv = relationView;
        this._rec = netRecord;
        this._colNames = hashtable;
        this._block = recordSet;
        this._stream = null;
    }

    int getColIndex(String string) throws SQLException {
        if (string != null) {
            Integer n = (Integer)this._colNames.get(string);
            if (n != null) {
                return n;
            }
            throw new SQLException("Column not found.");
        }
        throw new SQLException("Invalid parameter: null colName");
    }

    void setColNames(Hashtable hashtable) {
        this._colNames = hashtable;
    }

    void undo() throws SQLException {
        byte by = this.getState();
        if (by == 104 || by == 102 || by == 105) {
            return;
        }
        this.closeStream();
        this._block.undoRecord(this._rec);
        if (by != this._rec.getState()) {
            this._rv.notifyRowChange();
        }
    }

    void delete() throws SQLException {
        byte by = this.getState();
        if (by == 103 || by == 104 || by == 105) {
            return;
        }
        if (by == 102 || by == 106) {
            throw new SQLException("Unable able to delete new record");
        }
        this.closeStream();
        this._block.deleteRecord(this._rec);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
        this._rv.resetDetailRelViews(false);
    }

    public void closeStream() {
        if (this._stream != null) {
            try {
                this._stream.close();
            }
            catch (Exception exception) {}
            this._stream = null;
        }
        this._rec.closeStream();
    }

    BinaryInputStream getRemoteInputStream(int n) throws SQLException {
        this.closeStream();
        if (this._rec.getState() == 105) {
            throw new SQLException("Record is invalid.");
        }
        return this._block.getRemoteInputStream(this._rec.getRecordNum(), n);
    }

    BinaryOutputStream getRemoteOutputStream(int n) throws SQLException {
        this.closeStream();
        if (this._rec.getState() == 103) {
            throw new SQLException("Record has been marked for deletion.");
        }
        if (this._rec.getState() == 104) {
            throw new SQLException("Record has been deleted.");
        }
        if (this._rec.getState() == 105) {
            throw new SQLException("Record is invalid.");
        }
        this._rec.setNotNull(n);
        return this._block.getRemoteOutputStream(this._rec.getRecordNum(), n);
    }

    boolean storesData(int n) throws SQLException {
        return this._rec.storesData(n);
    }

    void setState(byte by) {
        this._rec.setState(by);
    }

    void setRecModified() {
        if (this._rec.getState() == 102) {
            this._rec.setState((byte)106);
            return;
        }
        if (this._rec.getState() == 100) {
            this._rec.setState((byte)101);
        }
    }

    public RelationView getRelationView() {
        return this._rv;
    }

    public byte getState() {
        return this._rec.getState();
    }

    public String getStateString() {
        switch (this._rec.getState()) {
            case 100: {
                return new String("Existing");
            }
            case 101: {
                return new String("Modified");
            }
            case 102: {
                return new String("New");
            }
            case 103: {
                return new String("Marked for Deletion");
            }
            case 104: {
                return new String("Deleted");
            }
            case 106: {
                return new String("New Modified");
            }
        }
        return new String("Invalid");
    }

    public boolean isWritable() throws SQLException {
        return this._rec.getState() != 103 && this._rec.getState() != 104 && this._rec.getState() != 105;
    }

    public boolean isReadable() throws SQLException {
        return this._rec.getState() != 105;
    }

    public RelationViewMetaData getMetaData() throws SQLException {
        return this._rv.getMetaData();
    }

    public boolean isNull(int n) throws SQLException {
        this.closeStream();
        return this._rec.isNull(n);
    }

    public String getString(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getString(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        return binaryInputStream.getString();
    }

    public boolean getBoolean(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getBoolean(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        return binaryInputStream.getBool();
    }

    public byte getByte(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getByte(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        return binaryInputStream.getByte();
    }

    public short getShort(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getShort(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        return binaryInputStream.getShort();
    }

    public int getInt(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getInt(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        return binaryInputStream.getInt();
    }

    public long getLong(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getLong(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        return binaryInputStream.getLong();
    }

    public float getFloat(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getFloat(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        return binaryInputStream.getFloat();
    }

    public double getDouble(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getDouble(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        return binaryInputStream.getDouble();
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getBigDecimal(n, n2);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        BigDecimal bigDecimal = new BigDecimal(binaryInputStream.getString());
        return bigDecimal.setScale(n2);
    }

    public byte[] getBytes(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getBytes(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        return binaryInputStream.getBytes();
    }

    public Date getDate(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getDate(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        String string = binaryInputStream.getString();
        return Date.valueOf(string);
    }

    public Time getTime(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getTime(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        String string = binaryInputStream.getString();
        return Time.valueOf(string);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getTimestamp(n);
        }
        BinaryInputStream binaryInputStream = this.getRemoteInputStream(n);
        String string = binaryInputStream.getString();
        return Timestamp.valueOf(string);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getAsciiStream(n);
        }
        return this.getRemoteInputStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getUnicodeStream(n);
        }
        return this.getRemoteInputStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.closeStream();
        if (this.storesData(n)) {
            return this._rec.getBinaryStream(n);
        }
        return this.getRemoteInputStream(n);
    }

    public String getStringValue(int n, int n2) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n3 = relationViewMetaData.getColumnType(n);
        return this.getStringValue(n, n3, n2, false);
    }

    public String getStringValue(int n, int n2, boolean bl) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n3 = relationViewMetaData.getColumnType(n);
        return this.getStringValue(n, n3, n2, bl);
    }

    public String getStringValue(int n) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n2 = relationViewMetaData.getColumnType(n);
        return this.getStringValue(n, n2, 0, false);
    }

    public String getStringValue(int n, boolean bl) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n2 = relationViewMetaData.getColumnType(n);
        return this.getStringValue(n, n2, 0, bl);
    }

    public String getStringValue(int n, String string, int n2) throws SQLException, IOException {
        int n3 = RelationView.sqlTypeConvert(string);
        return this.getStringValue(n, n3, n2, false);
    }

    public String getStringValue(int n, String string, int n2, boolean bl) throws SQLException, IOException {
        int n3 = RelationView.sqlTypeConvert(string);
        return this.getStringValue(n, n3, n2, bl);
    }

    public String getStringValue(int n, int n2, int n3) throws SQLException, IOException {
        return this.getStringValue(n, n2, n3, false);
    }

    public String getStringValue(int n, int n2, int n3, boolean bl) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n4 = n3;
        if (n3 == 0) {
            n3 = relationViewMetaData.getScale(n);
            n4 = relationViewMetaData.getColumnDisplaySize(n);
        }
        String string = "";
        if (!this.isNull(n)) {
            switch (n2) {
                case -7: {
                    string = String.valueOf(this.getBoolean(n));
                    break;
                }
                case -6: {
                    string = String.valueOf(this.getShort(n));
                    break;
                }
                case 5: {
                    string = String.valueOf(this.getShort(n));
                    break;
                }
                case 4: {
                    string = String.valueOf(this.getInt(n));
                    break;
                }
                case -5: {
                    string = String.valueOf(this.getLong(n));
                    break;
                }
                case 6: {
                    string = this.getString(n);
                    break;
                }
                case 7: {
                    string = this.getString(n);
                    break;
                }
                case 8: {
                    string = this.getString(n);
                    break;
                }
                case 2: {
                    BigDecimal bigDecimal = this.getBigDecimal(n, n3);
                    if (bigDecimal == null) break;
                    string = String.valueOf(bigDecimal);
                    break;
                }
                case 3: {
                    BigDecimal bigDecimal = this.getBigDecimal(n, n3);
                    if (bigDecimal == null) break;
                    string = String.valueOf(bigDecimal);
                    break;
                }
                case 1: {
                    string = this.getString(n);
                    break;
                }
                case 12: {
                    string = this.getString(n);
                    break;
                }
                case -1: {
                    string = this.getString(n);
                    break;
                }
                case 91: {
                    Date date = this.getDate(n);
                    if (date == null) break;
                    string = date.toString();
                    break;
                }
                case 92: {
                    Time time = this.getTime(n);
                    if (time == null) break;
                    string = time.toString();
                    break;
                }
                case 93: {
                    Timestamp timestamp = this.getTimestamp(n);
                    if (timestamp == null) break;
                    string = timestamp.toString();
                    break;
                }
                case -2: {
                    if (bl) {
                        byte[] byArray = new byte[n4];
                        byArray = this.getBytes(n);
                        string = RelationView.binaryArraytoString(byArray);
                        break;
                    }
                    string = "<Binary Data>";
                    break;
                }
                case -3: {
                    if (bl) {
                        byte[] byArray = new byte[n4];
                        byArray = this.getBytes(n);
                        string = RelationView.binaryArraytoString(byArray);
                        break;
                    }
                    string = "<Binary Data>";
                    break;
                }
                case -4: {
                    if (bl) {
                        InputStream inputStream = this.getBinaryStream(n);
                        string = RelationView.binaryStreamtoString(inputStream, 0);
                        break;
                    }
                    string = "<Binary Data>";
                    break;
                }
                case 1111: {
                    if (bl) {
                        InputStream inputStream = this.getUnicodeStream(n);
                        string = RelationView.binaryStreamtoString(inputStream, 0);
                        break;
                    }
                    string = "<Other Data Type>";
                    break;
                }
                case 0: {
                    string = "";
                    break;
                }
                default: {
                    string = this.getString(n);
                }
            }
        }
        return string;
    }

    public boolean isNull(String string) throws SQLException {
        return this.isNull(this.getColIndex(string));
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.getColIndex(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.getColIndex(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.getColIndex(string));
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.getColIndex(string));
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.getColIndex(string));
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.getColIndex(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.getColIndex(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.getColIndex(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.getColIndex(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.getColIndex(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.getColIndex(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.getColIndex(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.getColIndex(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.getColIndex(string));
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.getColIndex(string));
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.getColIndex(string));
    }

    public String getStringValue(String string, int n) throws SQLException, IOException {
        return this.getStringValue(this.getColIndex(string), n);
    }

    public String getStringValue(String string, int n, boolean bl) throws SQLException, IOException {
        return this.getStringValue(this.getColIndex(string), n, bl);
    }

    public String getStringValue(String string) throws SQLException, IOException {
        return this.getStringValue(this.getColIndex(string));
    }

    public String getStringValue(String string, boolean bl) throws SQLException, IOException {
        return this.getStringValue(string, bl);
    }

    public String getStringValue(String string, String string2, int n) throws SQLException, IOException {
        return this.getStringValue(this.getColIndex(string), string2, n);
    }

    public String getStringValue(String string, String string2, int n, boolean bl) throws SQLException, IOException {
        return this.getStringValue(this.getColIndex(string), string2, n, bl);
    }

    public String getStringValue(String string, int n, int n2) throws SQLException, IOException {
        return this.getStringValue(this.getColIndex(string), n, n2);
    }

    public String getStringValue(String string, int n, int n2, boolean bl) throws SQLException, IOException {
        return this.getStringValue(this.getColIndex(string), n, n2, bl);
    }

    public void setNull(int n, int n2) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setNull(n, n2);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setNull();
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setBoolean(n, bl);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setBoolean(bl);
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setByte(int n, byte by) throws SQLException {
        this.closeStream();
        byte by2 = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setByte(n, by);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setByte(by);
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by2 != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setShort(int n, short s) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setShort(n, s);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setShort(s);
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setInt(int n, int n2) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setInt(n, n2);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setInt(n2);
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setLong(int n, long l) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setLong(n, l);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setLong(l);
            this.setRecModified();
        }
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
        this._rv.notifyDataChange(n, this);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setFloat(n, f);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setFloat(f);
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setDouble(int n, double d) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setDouble(n, d);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setDouble(d);
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setBigDecimal(n, bigDecimal);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setString(bigDecimal.toString());
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setString(int n, String string) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setString(n, string);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setString(string);
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setBytes(n, byArray);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setBytes(byArray);
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setDate(int n, Date date) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setDate(n, date);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setString(date.toString());
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setTime(int n, Time time) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setTime(n, time);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setString(time.toString());
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setTimestamp(n, timestamp);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.setString(timestamp.toString());
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setAsciiStream(n, inputStream, n2);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.sendData(inputStream, n2);
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setUnicodeStream(n, inputStream, n2);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.sendData(inputStream, n2);
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.closeStream();
        byte by = this._rec.getState();
        if (this.storesData(n)) {
            this._rec.setBinaryStream(n, inputStream, n2);
            this._block.notifyRecChanged(this._rec);
        } else {
            BinaryOutputStream binaryOutputStream = this.getRemoteOutputStream(n);
            binaryOutputStream.sendData(inputStream, n2);
            this.setRecModified();
        }
        this._rv.notifyDataChange(n, this);
        if (by != this._rec.getState()) {
            this._rv.notifyRowStateChange();
        }
    }

    public void setValueFromString(int n, String string, int n2, int n3) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n4 = relationViewMetaData.getColumnType(n);
        this.setValueFromString(n, string, n4, n2, n3);
    }

    public void setValueFromString(int n, String string) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n2 = relationViewMetaData.getColumnType(n);
        this.setValueFromString(n, string, n2, 0, 0);
    }

    public void setValueFromString(int n, String string, int n2) throws SQLException, IOException {
        RelationViewMetaData relationViewMetaData = this._rv.getMetaData();
        int n3 = relationViewMetaData.getColumnType(n);
        this.setValueFromString(n, string, n3, 0, n2);
    }

    public void setValueFromString(int n, String string, String string2, int n2) throws SQLException, IOException {
        int n3 = RelationView.sqlTypeConvert(string2);
        this.setValueFromString(n, string, n3, n2, 0);
    }

    public void setValueFromString(int n, String string, String string2, int n2, int n3) throws SQLException, IOException {
        int n4 = RelationView.sqlTypeConvert(string2);
        this.setValueFromString(n, string, n4, n2, n3);
    }

    public void setValueFromString(int n, String string, int n2, int n3, int n4) throws SQLException, IOException {
        if ((string == null || string.compareTo("") == 0) && (string = RelationView.processEmptyStringData(string, this._rv, n, n2, n4)) == null) {
            this.setNull(n, n2);
            return;
        }
        switch (n2) {
            case -7: {
                boolean bl = new Boolean(string);
                this.setBoolean(n, bl);
                return;
            }
            case -6: {
                short s = (short)Integer.valueOf(string).intValue();
                this.setShort(n, s);
                return;
            }
            case 5: {
                short s = (short)Integer.valueOf(string).intValue();
                this.setShort(n, s);
                return;
            }
            case 4: {
                int n5 = Integer.valueOf(string);
                this.setInt(n, n5);
                return;
            }
            case -5: {
                long l = Long.valueOf(string);
                this.setFloat(n, (float)l);
                return;
            }
            case 6: {
                this.setString(n, string);
                return;
            }
            case 7: {
                this.setString(n, string);
                return;
            }
            case 8: {
                this.setString(n, string);
                return;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = new BigDecimal(string);
                if (n3 != 0) {
                    bigDecimal.setScale(n3);
                }
                this.setBigDecimal(n, bigDecimal);
                return;
            }
            case 1: {
                this.setString(n, string);
                return;
            }
            case 12: {
                this.setString(n, string);
                return;
            }
            case -1: {
                StringBufferInputStream stringBufferInputStream;
                int n6 = string.length();
                StringBufferInputStream stringBufferInputStream2 = stringBufferInputStream = new StringBufferInputStream(string);
                this.setAsciiStream(n, (InputStream)stringBufferInputStream2, n6);
                return;
            }
            case 91: {
                Date date = null;
                date = Date.valueOf(string);
                this.setDate(n, date);
                return;
            }
            case 92: {
                Time time = null;
                time = Time.valueOf(string);
                this.setTime(n, time);
                return;
            }
            case 93: {
                Timestamp timestamp = null;
                timestamp = Timestamp.valueOf(string);
                this.setTimestamp(n, timestamp);
                return;
            }
            case -2: {
                byte[] byArray = new byte[string.length()];
                string.getBytes(0, string.length(), byArray, 0);
                this.setBytes(n, byArray);
                return;
            }
            case -3: {
                byte[] byArray = new byte[string.length()];
                string.getBytes(0, string.length(), byArray, 0);
                this.setBytes(n, byArray);
                return;
            }
            case -4: {
                StringBufferInputStream stringBufferInputStream;
                int n7 = string.length();
                StringBufferInputStream stringBufferInputStream3 = stringBufferInputStream = new StringBufferInputStream(string);
                this.setBinaryStream(n, (InputStream)stringBufferInputStream3, n7);
                return;
            }
            case 1111: {
                StringBufferInputStream stringBufferInputStream;
                int n8 = string.length();
                StringBufferInputStream stringBufferInputStream4 = stringBufferInputStream = new StringBufferInputStream(string);
                this.setBinaryStream(n, (InputStream)stringBufferInputStream4, n8);
                return;
            }
            case 0: {
                this.setNull(n, n2);
                return;
            }
        }
        this.setString(n, string);
    }

    public void setNull(String string, int n) throws SQLException {
        this.setNull(this.getColIndex(string), n);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.getColIndex(string), bl);
    }

    public void setByte(String string, byte by) throws SQLException {
        this.setByte(this.getColIndex(string), by);
    }

    public void setShort(String string, short s) throws SQLException {
        this.setShort(this.getColIndex(string), s);
    }

    public void setInt(String string, int n) throws SQLException {
        this.setInt(this.getColIndex(string), n);
    }

    public void setLong(String string, long l) throws SQLException {
        this.setLong(this.getColIndex(string), l);
    }

    public void setFloat(String string, float f) throws SQLException {
        this.setFloat(this.getColIndex(string), f);
    }

    public void setDouble(String string, double d) throws SQLException {
        this.setDouble(this.getColIndex(string), d);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.getColIndex(string), bigDecimal);
    }

    public void setString(String string, String string2) throws SQLException {
        this.setString(this.getColIndex(string), string2);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.getColIndex(string), byArray);
    }

    public void setDate(String string, Date date) throws SQLException {
        this.setDate(this.getColIndex(string), date);
    }

    public void setTime(String string, Time time) throws SQLException {
        this.setTime(this.getColIndex(string), time);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.getColIndex(string), timestamp);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.getColIndex(string), inputStream, n);
    }

    public void setUnicodeStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setUnicodeStream(this.getColIndex(string), inputStream, n);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.getColIndex(string), inputStream, n);
    }

    public void setValueFromString(String string, String string2, int n, int n2) throws SQLException, IOException {
        this.setValueFromString(this.getColIndex(string), string2, n, n2);
    }

    public void setValueFromString(String string, String string2) throws SQLException, IOException {
        this.setValueFromString(this.getColIndex(string), string2);
    }

    public void setValueFromString(String string, String string2, int n) throws SQLException, IOException {
        this.setValueFromString(this.getColIndex(string), string2, n);
    }

    public void setValueFromString(String string, String string2, String string3, int n) throws SQLException, IOException {
        this.setValueFromString(this.getColIndex(string), string2, string3, n);
    }

    public void setValueFromString(String string, String string2, String string3, int n, int n2) throws SQLException, IOException {
        this.setValueFromString(this.getColIndex(string), string2, string3, n, n2);
    }

    public void setValueFromString(String string, String string2, int n, int n2, int n3) throws SQLException, IOException {
        this.setValueFromString(this.getColIndex(string), string2, n, n2, n3);
    }
}

