/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.pro;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import symantec.itools.db.net.BinaryInputStream;
import symantec.itools.db.net.BinaryOutputStream;
import symantec.itools.db.net.NetRecord;
import symantec.itools.db.pro.RecordTree;
import symantec.itools.db.pro.RelViewPos;

class RecordSet {
    private RelViewPos _relPos;
    private Hashtable _recTrees;
    private boolean _allDataRead;

    RecordSet(RelViewPos relViewPos) {
        this._relPos = relViewPos;
        this._recTrees = new Hashtable();
        this._allDataRead = false;
    }

    synchronized void freeRecordTrees() {
        Enumeration enumeration = this._recTrees.elements();
        while (enumeration.hasMoreElements()) {
            RecordTree recordTree = (RecordTree)enumeration.nextElement();
            if (recordTree == null) continue;
            recordTree.freeRecordBlocks();
        }
        this._recTrees.clear();
        this._relPos = null;
        this._allDataRead = false;
    }

    RecordTree getRecordTree(RelViewPos relViewPos) throws SQLException {
        return this.getRecordTree(relViewPos.getRecNum());
    }

    NetRecord getRecord(int n) throws SQLException {
        RecordTree recordTree = this.getRecordTree(n);
        return recordTree.getRecord();
    }

    synchronized void notifyRecChanged(NetRecord netRecord) throws SQLException {
        if (this._relPos != null) {
            this._relPos.notifyServerOfDataChange(netRecord);
        }
    }

    synchronized void deleteRecord(NetRecord netRecord) throws SQLException {
        if (this._relPos != null) {
            this._relPos.deleteServerRecord(netRecord, netRecord.getRecordNum());
        }
    }

    boolean isRecordTreeStored(int n) {
        return this._recTrees.containsKey(new Integer(n));
    }

    void storeRecordTree(RecordTree recordTree) {
        NetRecord netRecord = recordTree.getRecord();
        if (!this.isRecordTreeStored(netRecord.getRecordNum())) {
            this._recTrees.put(new Integer(netRecord.getRecordNum()), recordTree);
        }
    }

    synchronized NetRecord getNewRecord() throws SQLException {
        if (this._relPos != null) {
            NetRecord netRecord = this._relPos.getNewServerRecord();
            RecordTree recordTree = new RecordTree(netRecord);
            this.storeRecordTree(recordTree);
            return netRecord;
        }
        return new NetRecord();
    }

    synchronized void undoRecord(NetRecord netRecord) throws SQLException {
        if (this._relPos != null) {
            this._relPos.undoServerRecord(netRecord, netRecord.getRecordNum());
        }
    }

    synchronized BinaryInputStream getRemoteInputStream(int n, int n2) throws SQLException {
        if (this._relPos != null) {
            return this._relPos.getRemoteInputStream(n, n2);
        }
        throw new SQLException("Invalid Record block.");
    }

    BinaryOutputStream getRemoteOutputStream(int n, int n2) throws SQLException {
        if (this._relPos != null) {
            return this._relPos.getRemoteOutputStream(n, n2);
        }
        throw new SQLException("Invalid Record block.");
    }

    private synchronized RecordTree getRecordTree(int n) throws SQLException {
        NetRecord netRecord = null;
        RecordTree recordTree = null;
        if (this._relPos == null) {
            return new RecordTree();
        }
        if (n == 0) {
            return new RecordTree();
        }
        if (this.isRecordTreeStored(n)) {
            return (RecordTree)this._recTrees.get(new Integer(n));
        }
        if (this._allDataRead) {
            return new RecordTree();
        }
        int n2 = this._relPos.getRowsToRequest();
        int n3 = n - this._recTrees.size() > n2 ? n - this._recTrees.size() : n2;
        Vector vector = this._relPos.fetchRecords(this._recTrees.size() + 1, n3);
        int n4 = 0;
        while (n4 < vector.size()) {
            netRecord = (NetRecord)vector.elementAt(n4);
            recordTree = new RecordTree(netRecord);
            this.storeRecordTree(recordTree);
            if (netRecord.getState() == 105) {
                this._allDataRead = true;
            }
            ++n4;
        }
        if (this.isRecordTreeStored(n)) {
            return (RecordTree)this._recTrees.get(new Integer(n));
        }
        return new RecordTree();
    }
}

