/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.pro;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import symantec.itools.db.net.Entity;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NetRecord;
import symantec.itools.db.net.NetString;
import symantec.itools.db.net.RemoteObject;
import symantec.itools.db.net.SQLConnectionException;
import symantec.itools.db.net.TextParam;
import symantec.itools.db.pro.AutoDetail;
import symantec.itools.db.pro.Cardinality;
import symantec.itools.db.pro.ConnectionInfo;
import symantec.itools.db.pro.DataAccess;
import symantec.itools.db.pro.InitialRecordPosition;
import symantec.itools.db.pro.ListBinder;
import symantec.itools.db.pro.ListLink;
import symantec.itools.db.pro.MultiView;
import symantec.itools.db.pro.OptimisticConcurrency;
import symantec.itools.db.pro.ProjBinder;
import symantec.itools.db.pro.ProjLink;
import symantec.itools.db.pro.Record;
import symantec.itools.db.pro.RecordLink;
import symantec.itools.db.pro.RecordSet;
import symantec.itools.db.pro.RecordSetLink;
import symantec.itools.db.pro.RelViewInfo;
import symantec.itools.db.pro.RelViewPos;
import symantec.itools.db.pro.RelationViewMetaData;
import symantec.itools.db.pro.Request;
import symantec.itools.db.pro.Session;

public class RelationView
implements DataAccess {
    private RemoteObject _messgr;
    private Session _session;
    private MultiView _mv;
    private RelationView _parRV;
    private RelationViewMetaData _metadata;
    private int _proxyID;
    private RecordSet _block;
    private Record _rec;
    private Hashtable _colNames;
    private int _curRecNum;
    private int _numRowsToRequest;
    private Vector _binds;
    private Vector _recordBinds;
    private Vector _recordSetBinds;
    private Vector _detailRVs;
    private byte _rvID;
    private String _name;
    private ConnectionInfo _conn;
    private boolean _notifyEnabled = true;
    private boolean _enableDetailSQL = true;
    private String _recPos = Request.REC_POS_NOPOS;
    private String _cardinality = AutoDetail.ONE_TO_MANY;
    private String _optConc = Request.UNIQUE_MODIFIED;
    private String _sql;
    private Vector _joinCols = new Vector();
    private final int METHOD_getPreparedRelView = 1;
    private final int METHOD_setName = 3;
    private final int METHOD_filter = 4;
    private final int METHOD_clearFilter = 5;
    private final int METHOD_getListProxy = 6;
    public static final int DEFAULTSCALE = 0;
    public static final int SETBLANKTODEFAULT = 0;
    public static final int SETBLANKTONULL = 1;
    public static final int SETBLANKTOEMPTY = 2;

    public RelationView(Request request) throws SQLException {
        this(request.getSession(), request.getConnectionInfo(), request.getSQL(), request);
    }

    public RelationView(AutoDetail autoDetail) throws SQLException {
        Vector vector = autoDetail.getExecuteRequestResults();
        RelationView relationView = autoDetail.getRelationView();
        MultiView multiView = relationView.getMultiView();
        this.init(relationView.getSession(), multiView, relationView, vector, multiView.getNextLevelID(), autoDetail.getConnectionInfo());
    }

    RelationView(Session session, ConnectionInfo connectionInfo, String string, Properties properties) throws SQLException {
        Hashtable hashtable = RelationView.convertViewProps(properties);
        MultiView multiView = session.createMultiView(connectionInfo, string, hashtable);
        Properties properties2 = multiView.getRootRVCtorProperties();
        Vector vector = (Vector)((Hashtable)properties2).get("ctorParams");
        byte by = multiView.getNextLevelID();
        this.init(session, multiView, null, vector, by, connectionInfo);
    }

    RelationView(MultiView multiView, byte by, ConnectionInfo connectionInfo) throws SQLException {
        Properties properties = multiView.getRootRVCtorProperties();
        Session session = (Session)((Hashtable)properties).get("session");
        Vector vector = (Vector)((Hashtable)properties).get("ctorParams");
        this.init(session, multiView, null, vector, by, connectionInfo);
    }

    void goToInitialRecPos() throws SQLException {
        if (this._recPos.equals(Request.REC_POS_FIRST)) {
            this.first();
            return;
        }
        if (this._recPos.equals(Request.REC_POS_NEW)) {
            this.getNewRecord();
            return;
        }
        this._block = null;
        this._curRecNum = 0;
        this._rec = new Record(new NetRecord(), this._colNames, this, null);
        this.notifyRowChange();
        this.resetDetailRelViews(false);
    }

    static Hashtable convertViewProps(Properties properties) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("user", properties.getProperty("user", ""));
        hashtable.put("password", properties.getProperty("password", ""));
        String string = properties.getProperty("optConc", Request.UNIQUE_MODIFIED);
        hashtable.put("optConc", Integer.valueOf(string));
        string = properties.getProperty("recPosition", Request.REC_POS_NOPOS);
        hashtable.put("recPosition", new String(string));
        string = properties.getProperty("maxRecords", "200");
        hashtable.put("maxRecords", Integer.valueOf(string));
        string = properties.getProperty("readOnly", "true");
        hashtable.put("readOnly", Boolean.valueOf(string));
        string = properties.getProperty("sharable", "true");
        hashtable.put("sharable", Boolean.valueOf(string));
        return hashtable;
    }

    RelationView(Session session, MultiView multiView, RelationView relationView, Vector vector, byte by, ConnectionInfo connectionInfo) throws SQLException {
        this.init(session, multiView, relationView, vector, by, connectionInfo);
    }

    void init(Session session, MultiView multiView, RelationView relationView, Vector vector, byte by, ConnectionInfo connectionInfo) throws SQLException {
        int n;
        this._parRV = relationView;
        this._rvID = by;
        this._curRecNum = 0;
        this._conn = connectionInfo;
        this._block = null;
        this._rec = null;
        this._mv = multiView;
        this._session = session;
        this._detailRVs = new Vector();
        NetData netData = (NetData)vector.elementAt(0);
        try {
            n = netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
        this._proxyID = n;
        this._messgr = new RemoteObject("CSCLRelView", n, session.getClientSession());
        if (this._session.isDesignTime()) {
            this._messgr.disable();
        }
        NetString netString = (NetString)vector.elementAt(1);
        this._name = netString.getString();
        Entity entity = (Entity)vector.elementAt(2);
        this._metadata = new RelationViewMetaData(this, entity);
        Vector vector2 = this._metadata.getColumnList();
        this.initHashTableAndBinds(vector2);
        int n2 = this._metadata.getColumnCount();
        if (n2 > 0) {
            int n3 = 0;
            int n4 = 1;
            while (n4 <= n2) {
                n3 += this._metadata.getColumnDisplaySize(n4) + 20;
                ++n4;
            }
            this._numRowsToRequest = 4096 / n3;
        }
        if (this._numRowsToRequest == 0) {
            this._numRowsToRequest = 1;
        }
        this._rec = new Record(new NetRecord(), this._colNames, this, null);
        this._recPos = (String)vector.elementAt(3);
        Integer n5 = (Integer)vector.elementAt(4);
        this._optConc = n5.toString();
        n5 = (Integer)vector.elementAt(5);
        this._cardinality = n5.toString();
        this._sql = (String)vector.elementAt(6);
        this._joinCols = (Vector)vector.elementAt(7);
        if (this._parRV != null) {
            this._parRV.addDetailRelView(this);
        } else {
            this._mv.setRootRelView(this);
        }
        this.goToInitialRecPos();
    }

    private void initHashTableAndBinds(Vector vector) {
        this._colNames = new Hashtable();
        this._binds = new Vector();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            Integer n2 = new Integer(n + 1);
            this._colNames.put(string, n2);
            this._colNames.put(n2.toString(), n2);
            this._binds.addElement(new ProjBinder(n + 1, this, this._notifyEnabled));
            ++n;
        }
        this._recordBinds = new Vector();
        this._recordSetBinds = new Vector();
    }

    private void closeStream() {
        if (this._rec != null) {
            this._rec.closeStream();
        }
    }

    int getColIndex(String string) throws SQLException {
        Integer n = (Integer)this._colNames.get(string);
        if (n != null) {
            return n;
        }
        throw new SQLException("Column not found.");
    }

    private boolean isRecValid(Record record) {
        return record != null && record.getState() != 105;
    }

    private boolean isRecValid(NetRecord netRecord) {
        return netRecord != null && netRecord.getState() != 105;
    }

    private ProjBinder getBind(int n) {
        if (this._session.isDesignTime()) {
            return new ProjBinder(0, this, false);
        }
        return (ProjBinder)this._binds.elementAt(n - 1);
    }

    private RecordLink getRecordBind(int n) {
        return (RecordLink)this._recordBinds.elementAt(n);
    }

    private RecordSetLink getRecordSetBind(int n) {
        return (RecordSetLink)this._recordSetBinds.elementAt(n);
    }

    void addDetailRelView(RelationView relationView) {
        this._detailRVs.addElement(relationView);
    }

    void notifyDataChange(int n, Record record) {
        if (this._session.isDesignTime()) {
            return;
        }
        if (record == this._rec) {
            ProjBinder projBinder = this.getBind(n);
            projBinder.notifyDataChange();
        }
    }

    void notifyRowStateChange() throws SQLException {
        if (this._session.isDesignTime()) {
            return;
        }
        if (this._notifyEnabled) {
            int n = 0;
            while (n < this._recordBinds.size()) {
                ((RecordLink)this._recordBinds.elementAt(n)).notifyRecordChange(this._rec);
                ++n;
            }
        }
    }

    void notifyRowChange() throws SQLException {
        int n;
        if (this._session.isDesignTime()) {
            return;
        }
        if (this._notifyEnabled) {
            n = 0;
            while (n < this._recordBinds.size()) {
                ((RecordLink)this._recordBinds.elementAt(n)).notifyRecordChange(this._rec);
                ++n;
            }
        }
        n = 1;
        while (n <= this._binds.size()) {
            this.getBind(n).notifyDataChange();
            ++n;
        }
    }

    void notifyRecordSetChange() throws SQLException {
        if (this._session.isDesignTime()) {
            return;
        }
        if (this._notifyEnabled) {
            int n = 0;
            while (n < this._recordSetBinds.size()) {
                ((RecordSetLink)this._recordSetBinds.elementAt(n)).notifyRecordSetChange(this);
                ++n;
            }
        }
    }

    boolean notifySetData() throws SQLException {
        if (this._session.isDesignTime()) {
            return true;
        }
        Record record = this._rec;
        if (record != null && (record.getState() != 105 || false)) {
            int n = 1;
            while (n <= this._binds.size()) {
                ProjBinder projBinder = this.getBind(n);
                if (!projBinder.notifySetData()) {
                    return false;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this._detailRVs.size()) {
                RelationView relationView = (RelationView)this._detailRVs.elementAt(n2);
                if (!relationView.notifySetData()) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    RecordSet getRecordSet() throws SQLException {
        if (this._block != null) {
            return this._block;
        }
        RelViewPos relViewPos = new RelViewPos(this.getMultiView());
        relViewPos.addParentInfo(new RelViewInfo(this._rvID, 0, this._proxyID, this._numRowsToRequest));
        if (this._parRV != null) {
            return this._parRV.getChildRecordSet(relViewPos);
        }
        return this.getMultiView().getRecordSet(relViewPos);
    }

    RecordSet getChildRecordSet(RelViewPos relViewPos) throws SQLException {
        if (this.getCurrentRecordState() == 103 || this.getCurrentRecordState() == 104 || !this._enableDetailSQL || this._curRecNum == 0) {
            return null;
        }
        relViewPos.addParentInfo(new RelViewInfo(this._rvID, this._curRecNum, this._proxyID, this._numRowsToRequest));
        if (this._parRV != null) {
            return this._parRV.getChildRecordSet(relViewPos);
        }
        return this.getMultiView().getRecordSet(relViewPos);
    }

    void rewindDetailRelViews() throws SQLException {
        int n = 0;
        while (n < this._detailRVs.size()) {
            RelationView relationView = (RelationView)this._detailRVs.elementAt(n);
            relationView.rewind();
            ++n;
        }
    }

    void resetDetailRelViews(boolean bl) throws SQLException {
        int n = 0;
        while (n < this._detailRVs.size()) {
            RelationView relationView = (RelationView)this._detailRVs.elementAt(n);
            relationView.resetRecordSet(bl);
            ++n;
        }
    }

    void resetRecordSet(boolean bl) throws SQLException {
        if (this._rec != null) {
            this._rec.closeStream();
        }
        this._block = null;
        this._curRecNum = 0;
        this._rec = new Record(new NetRecord(), this._colNames, this, null);
        if (bl) {
            this.resetDetailRelViews(bl);
            this._messgr.disable();
        } else {
            this.goToInitialRecPos();
        }
        this.notifyRecordSetChange();
    }

    boolean bindsExist() {
        int n = 1;
        while (n <= this._binds.size()) {
            if (this.getBind(n).bindsExist()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void enableDetailSQL(boolean bl) throws SQLException {
        if (this._enableDetailSQL == bl) {
            return;
        }
        this._enableDetailSQL = bl;
        this.resetDetailRelViews(false);
    }

    public void enableBindingNotify(boolean bl, boolean bl2) throws SQLException {
        this._notifyEnabled = bl;
        int n = 1;
        while (n <= this._binds.size()) {
            this.getBind(n).enable(bl);
            ++n;
        }
        if (bl2) {
            int n2 = 0;
            while (n2 < this._detailRVs.size()) {
                RelationView relationView = (RelationView)this._detailRVs.elementAt(n2);
                relationView.enableBindingNotify(bl, bl2);
                ++n2;
            }
        }
    }

    public void enableBindingNotify(boolean bl) throws SQLException {
        this.enableBindingNotify(bl, true);
    }

    public boolean isBindingNotifyEnabled() throws SQLException {
        return this._notifyEnabled;
    }

    public void bindCurrentRecord(RecordLink recordLink) throws SQLException {
        recordLink.init();
        if (this._session.isDesignTime()) {
            return;
        }
        if (this._notifyEnabled) {
            recordLink.notifyRecordChange(this._rec);
        }
        this._recordBinds.addElement(recordLink);
    }

    public void bindRecordSet(RecordSetLink recordSetLink) throws SQLException {
        recordSetLink.init();
        if (this._session.isDesignTime()) {
            return;
        }
        if (this._notifyEnabled) {
            recordSetLink.notifyRecordSetChange(this);
        }
        this._recordSetBinds.addElement(recordSetLink);
    }

    public ListBinder bindList(ConnectionInfo connectionInfo, String string, ListLink listLink, Vector vector) throws SQLException {
        if (this._session.isDesignTime()) {
            return new ListBinder(this, 0, vector, listLink, this._session, connectionInfo);
        }
        int n = 0;
        while (true) {
            String string2 = connectionInfo.getUser();
            String string3 = connectionInfo.getPassword();
            String string4 = connectionInfo.getDBString();
            Vector<TextParam> vector2 = new Vector<TextParam>();
            vector2.addElement(new TextParam(0, string4));
            vector2.addElement(new TextParam(0, string2));
            vector2.addElement(new TextParam(0, string3));
            vector2.addElement(new TextParam(0, string));
            try {
                Vector vector3 = this._messgr.invokeMethod(6, vector2);
                NetData netData = (NetData)vector3.elementAt(0);
                return new ListBinder(this, netData.getInt(), vector, listLink, this._session, connectionInfo);
            }
            catch (EOFException eOFException) {
                throw new SQLException(eOFException.getMessage());
            }
            catch (SQLConnectionException sQLConnectionException) {
                if (this._session.logonFailed(connectionInfo, ++n)) continue;
                throw sQLConnectionException;
            }
            break;
        }
    }

    public ListBinder bindList(ConnectionInfo connectionInfo, String string, ListLink listLink, int[] nArray) throws SQLException {
        Vector<Integer> vector = new Vector<Integer>();
        int n = 0;
        while (n < nArray.length) {
            vector.addElement(new Integer(nArray[n]));
            ++n;
        }
        return this.bindList(connectionInfo, string, listLink, vector);
    }

    public ProjBinder bindProj(int n, ProjLink projLink) throws SQLException {
        ProjBinder projBinder = this.getBind(n);
        projBinder.addLink(projLink);
        projLink.init(projBinder);
        if (this.getCurrentRecordState() != 105) {
            this.notifyDataChange(n, this._rec);
        } else {
            this.goTo(1);
        }
        return projBinder;
    }

    public void closeMultiView() throws SQLException {
        this._mv.close();
    }

    public void deleteRecord() throws SQLException {
        this._rec.delete();
    }

    public boolean doesProjExist(String string) throws SQLException {
        return this._colNames.containsKey(string);
    }

    public int findProjByName(String string) throws SQLException {
        return this.getColIndex(string);
    }

    public boolean first() throws SQLException {
        return this.goTo(1);
    }

    public int getCurrentRecordNumber() {
        return this._curRecNum;
    }

    public String getCurrentRecordNumberString() {
        return String.valueOf(this._curRecNum);
    }

    public byte getCurrentRecordState() {
        if (this._rec == null) {
            return 105;
        }
        return this._rec.getState();
    }

    public boolean isCurrentRecordWritable() throws SQLException {
        return this._rec.isWritable();
    }

    public boolean isCurrentRecordReadable() throws SQLException {
        return this._rec.isReadable();
    }

    public RelationViewMetaData getMetaData() throws SQLException {
        return this._metadata;
    }

    public MultiView getMultiView() throws SQLException {
        return this._mv;
    }

    public Session getSession() {
        return this._session;
    }

    public ConnectionInfo getConnectionInfo() {
        return this._conn;
    }

    public String getName() throws SQLException {
        return this._name;
    }

    public String getInitialRecordPosition() {
        return InitialRecordPosition.getStringValue(Integer.valueOf(this._recPos));
    }

    public String getOptimisticConcurrency() {
        return OptimisticConcurrency.getStringValue(Integer.valueOf(this._optConc));
    }

    public String getCardinality() {
        return Cardinality.getStringValue(Integer.valueOf(this._cardinality));
    }

    public String getSelectClause() {
        return this._sql;
    }

    public String[] getJoinColumns() {
        String[] stringArray = new String[this._joinCols.size()];
        int n = 0;
        while (n < this._joinCols.size()) {
            stringArray[n] = (String)this._joinCols.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public boolean getNewRecord() throws SQLException {
        boolean bl;
        RecordSet recordSet;
        if (!this.notifySetData()) {
            return false;
        }
        if (this._rec != null) {
            this._rec.closeStream();
        }
        if ((recordSet = this.getRecordSet()) == null) {
            this._curRecNum = 0;
            this._rec = new Record(new NetRecord(), this._colNames, this, null);
            this.notifyRowChange();
            this.resetDetailRelViews(false);
            return false;
        }
        NetRecord netRecord = recordSet.getNewRecord();
        boolean bl2 = bl = netRecord != null && netRecord.getState() != 105;
        if (bl) {
            this._curRecNum = netRecord.getRecordNum();
            this._rec = new Record(netRecord, this._colNames, this, recordSet);
            this.notifyRowChange();
            this.resetDetailRelViews(false);
        }
        return bl;
    }

    public Record getRecord() throws SQLException {
        return this._rec;
    }

    public void rewind() throws SQLException {
        if (!this.notifySetData()) {
            return;
        }
        if (this._rec != null) {
            this._rec.closeStream();
        }
        this._block = null;
        this._curRecNum = 0;
        this._rec = new Record(new NetRecord(), this._colNames, this, null);
        this.notifyRowChange();
        this.rewindDetailRelViews();
    }

    public boolean goTo(int n) throws SQLException {
        boolean bl;
        RecordSet recordSet;
        if (!this.notifySetData()) {
            return false;
        }
        if (this._rec != null) {
            this._rec.closeStream();
        }
        if ((recordSet = this.getRecordSet()) == null) {
            this._curRecNum = 0;
            this._rec = new Record(new NetRecord(), this._colNames, this, null);
            this.notifyRowChange();
            this.resetDetailRelViews(false);
            return false;
        }
        NetRecord netRecord = recordSet.getRecord(n);
        boolean bl2 = bl = netRecord != null && netRecord.getState() != 105;
        if (bl) {
            this._curRecNum = n;
            this._rec = new Record(netRecord, this._colNames, this, recordSet);
            this.notifyRowChange();
            this.resetDetailRelViews(false);
        }
        if (!bl && this._curRecNum == 0) {
            this.notifyRowChange();
            this.resetDetailRelViews(false);
        }
        return bl;
    }

    public boolean goTo(String string) throws SQLException {
        Integer n = Integer.valueOf(string);
        return this.goTo(n);
    }

    public boolean next() throws SQLException {
        return this.goTo(this._curRecNum + 1);
    }

    public AutoDetail getAutoDetail(ConnectionInfo connectionInfo, String string, Properties properties, Properties properties2) throws SQLException {
        AutoDetail autoDetail = new AutoDetail(this, connectionInfo);
        autoDetail.setSQL(string);
        autoDetail.setRequestProperties(properties);
        autoDetail.setDetailProperties(properties2);
        return autoDetail;
    }

    int getAutoDetailMessgrID(ConnectionInfo connectionInfo, String string, Properties properties, Properties properties2) throws SQLException {
        int n;
        if (this._session.isDesignTime()) {
            return 0;
        }
        Vector vector = this._messgr.invokeMethod(1, "RelView");
        NetData netData = (NetData)vector.elementAt(0);
        try {
            n = netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
        return n;
    }

    public AutoDetail getAutoDetail() throws SQLException {
        return this.getAutoDetail("");
    }

    int getAutoDetailMessgrID() throws SQLException {
        return this.getAutoDetailMessgrID("");
    }

    public AutoDetail getAutoDetail(String string) throws SQLException {
        return this.getAutoDetail(this._conn, string, new Properties(), new Properties());
    }

    int getAutoDetailMessgrID(String string) throws SQLException {
        return this.getAutoDetailMessgrID(this._conn, string, new Properties(), new Properties());
    }

    public boolean prev() throws SQLException {
        if (this._curRecNum == 0) {
            return false;
        }
        return this.goTo(this._curRecNum - 1);
    }

    public void saveMultiView() throws SQLException {
        this._mv.save();
    }

    public void restartMultiView() throws SQLException {
        this._mv.restart();
    }

    public void restartMultiView(String string) throws SQLException {
        this._mv.restart(string);
    }

    public void setName(String string) throws SQLException {
        if (!this._session.isDesignTime()) {
            this._messgr.invokeMethod(3, string);
        }
        this._name = string;
    }

    public void unBindObj(Object object) throws SQLException {
        int n = 1;
        while (n <= this._binds.size()) {
            this.getBind(n).removeLink(object);
            ++n;
        }
    }

    public void unBindProj(int n) throws SQLException {
        this.getBind(n).removeAllLinks();
    }

    public void undoRecord() throws SQLException {
        this._rec.undo();
        this.notifyRowChange();
    }

    public boolean isNull(int n) throws SQLException {
        return this._rec.isNull(n);
    }

    public String getString(int n) throws SQLException {
        return this._rec.getString(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this._rec.getBoolean(n);
    }

    public byte getByte(int n) throws SQLException {
        return this._rec.getByte(n);
    }

    public short getShort(int n) throws SQLException {
        return this._rec.getShort(n);
    }

    public int getInt(int n) throws SQLException {
        return this._rec.getInt(n);
    }

    public long getLong(int n) throws SQLException {
        return this._rec.getLong(n);
    }

    public float getFloat(int n) throws SQLException {
        return this._rec.getFloat(n);
    }

    public double getDouble(int n) throws SQLException {
        return this._rec.getDouble(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this._rec.getBigDecimal(n, n2);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this._rec.getBytes(n);
    }

    public Date getDate(int n) throws SQLException {
        return this._rec.getDate(n);
    }

    public Time getTime(int n) throws SQLException {
        return this._rec.getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this._rec.getTimestamp(n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this._rec.getAsciiStream(n);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        return this._rec.getUnicodeStream(n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this._rec.getBinaryStream(n);
    }

    public String getStringValue(int n, int n2) throws SQLException, IOException {
        return this._rec.getStringValue(n, n2);
    }

    public String getStringValue(int n, int n2, boolean bl) throws SQLException, IOException {
        return this._rec.getStringValue(n, n2);
    }

    public String getStringValue(int n) throws SQLException, IOException {
        return this._rec.getStringValue(n);
    }

    public String getStringValue(int n, boolean bl) throws SQLException, IOException {
        return this._rec.getStringValue(n, bl);
    }

    public String getStringValue(int n, String string, int n2) throws SQLException, IOException {
        return this._rec.getStringValue(n, string, n2);
    }

    public String getStringValue(int n, String string, int n2, boolean bl) throws SQLException, IOException {
        return this._rec.getStringValue(n, string, n2, bl);
    }

    public String getStringValue(int n, int n2, int n3) throws SQLException, IOException {
        return this._rec.getStringValue(n, n2, n3);
    }

    public String getStringValue(int n, int n2, int n3, boolean bl) throws SQLException, IOException {
        return this._rec.getStringValue(n, n2, n3, bl);
    }

    public boolean isNull(String string) throws SQLException {
        return this._rec.isNull(string);
    }

    public String getString(String string) throws SQLException {
        return this._rec.getString(string);
    }

    public boolean getBoolean(String string) throws SQLException {
        return this._rec.getBoolean(string);
    }

    public byte getByte(String string) throws SQLException {
        return this._rec.getByte(string);
    }

    public short getShort(String string) throws SQLException {
        return this._rec.getShort(string);
    }

    public int getInt(String string) throws SQLException {
        return this._rec.getInt(string);
    }

    public long getLong(String string) throws SQLException {
        return this._rec.getLong(string);
    }

    public float getFloat(String string) throws SQLException {
        return this._rec.getFloat(string);
    }

    public double getDouble(String string) throws SQLException {
        return this._rec.getDouble(string);
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this._rec.getBigDecimal(string, n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this._rec.getBytes(string);
    }

    public Date getDate(String string) throws SQLException {
        return this._rec.getDate(string);
    }

    public Time getTime(String string) throws SQLException {
        return this._rec.getTime(string);
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this._rec.getTimestamp(string);
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this._rec.getAsciiStream(string);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this._rec.getUnicodeStream(string);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this._rec.getBinaryStream(string);
    }

    public String getStringValue(String string, int n) throws SQLException, IOException {
        return this._rec.getStringValue(string, n);
    }

    public String getStringValue(String string, int n, boolean bl) throws SQLException, IOException {
        return this._rec.getStringValue(string, n, bl);
    }

    public String getStringValue(String string) throws SQLException, IOException {
        return this._rec.getStringValue(string);
    }

    public String getStringValue(String string, boolean bl) throws SQLException, IOException {
        return this._rec.getStringValue(string, bl);
    }

    public String getStringValue(String string, String string2, int n) throws SQLException, IOException {
        return this._rec.getStringValue(string, string2, n);
    }

    public String getStringValue(String string, String string2, int n, boolean bl) throws SQLException, IOException {
        return this._rec.getStringValue(string, string2, n, bl);
    }

    public String getStringValue(String string, int n, int n2) throws SQLException, IOException {
        return this._rec.getStringValue(string, n, n2);
    }

    public String getStringValue(String string, int n, int n2, boolean bl) throws SQLException, IOException {
        return this._rec.getStringValue(string, n, n2, bl);
    }

    public void setNull(int n, int n2) throws SQLException {
        this._rec.setNull(n, n2);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this._rec.setBoolean(n, bl);
    }

    public void setByte(int n, byte by) throws SQLException {
        this._rec.setByte(n, by);
    }

    public void setShort(int n, short s) throws SQLException {
        this._rec.setShort(n, s);
    }

    public void setInt(int n, int n2) throws SQLException {
        this._rec.setInt(n, n2);
    }

    public void setLong(int n, long l) throws SQLException {
        this._rec.setLong(n, l);
    }

    public void setFloat(int n, float f) throws SQLException {
        this._rec.setFloat(n, f);
    }

    public void setDouble(int n, double d) throws SQLException {
        this._rec.setDouble(n, d);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this._rec.setBigDecimal(n, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        this._rec.setString(n, string);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this._rec.setBytes(n, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        this._rec.setDate(n, date);
    }

    public void setTime(int n, Time time) throws SQLException {
        this._rec.setTime(n, time);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this._rec.setTimestamp(n, timestamp);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this._rec.setAsciiStream(n, inputStream, n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this._rec.setUnicodeStream(n, inputStream, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this._rec.setBinaryStream(n, inputStream, n2);
    }

    public void setValueFromString(int n, String string, int n2, int n3) throws SQLException, IOException {
        this._rec.setValueFromString(n, string, n2, n3);
    }

    public void setValueFromString(int n, String string) throws SQLException, IOException {
        this._rec.setValueFromString(n, string);
    }

    public void setValueFromString(int n, String string, int n2) throws SQLException, IOException {
        this._rec.setValueFromString(n, string, n2);
    }

    public void setValueFromString(int n, String string, String string2, int n2) throws SQLException, IOException {
        this._rec.setValueFromString(n, string, string2, n2);
    }

    public void setValueFromString(int n, String string, String string2, int n2, int n3) throws SQLException, IOException {
        this._rec.setValueFromString(n, string, string2, n2, n3);
    }

    public void setValueFromString(int n, String string, int n2, int n3, int n4) throws SQLException, IOException {
        this._rec.setValueFromString(n, string, n2, n3, n4);
    }

    public void setNull(String string, int n) throws SQLException {
        this._rec.setNull(string, n);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this._rec.setBoolean(string, bl);
    }

    public void setByte(String string, byte by) throws SQLException {
        this._rec.setByte(string, by);
    }

    public void setShort(String string, short s) throws SQLException {
        this._rec.setShort(string, s);
    }

    public void setInt(String string, int n) throws SQLException {
        this._rec.setInt(string, n);
    }

    public void setLong(String string, long l) throws SQLException {
        this._rec.setLong(string, l);
    }

    public void setFloat(String string, float f) throws SQLException {
        this._rec.setFloat(string, f);
    }

    public void setDouble(String string, double d) throws SQLException {
        this._rec.setDouble(string, d);
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this._rec.setBigDecimal(string, bigDecimal);
    }

    public void setString(String string, String string2) throws SQLException {
        this._rec.setString(string, string2);
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this._rec.setBytes(string, byArray);
    }

    public void setDate(String string, Date date) throws SQLException {
        this._rec.setDate(string, date);
    }

    public void setTime(String string, Time time) throws SQLException {
        this._rec.setTime(string, time);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this._rec.setTimestamp(string, timestamp);
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this._rec.setAsciiStream(string, inputStream, n);
    }

    public void setUnicodeStream(String string, InputStream inputStream, int n) throws SQLException {
        this._rec.setUnicodeStream(string, inputStream, n);
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this._rec.setBinaryStream(string, inputStream, n);
    }

    public void setValueFromString(String string, String string2, int n, int n2) throws SQLException, IOException {
        this._rec.setValueFromString(string, string2, n, n2);
    }

    public void setValueFromString(String string, String string2) throws SQLException, IOException {
        this._rec.setValueFromString(string, string2);
    }

    public void setValueFromString(String string, String string2, int n) throws SQLException, IOException {
        this._rec.setValueFromString(string, string2, n);
    }

    public void setValueFromString(String string, String string2, String string3, int n) throws SQLException, IOException {
        this._rec.setValueFromString(string, string2, string3, n);
    }

    public void setValueFromString(String string, String string2, String string3, int n, int n2) throws SQLException, IOException {
        this._rec.setValueFromString(string, string2, string3, n, n2);
    }

    public void setValueFromString(String string, String string2, int n, int n2, int n3) throws SQLException, IOException {
        this._rec.setValueFromString(string, string2, n, n2, n3);
    }

    public static String asciiStreamtoString(InputStream inputStream) throws IOException {
        int n;
        String string = new String();
        String string2 = new String();
        byte[] byArray = new byte[4000];
        int n2 = 0;
        while ((n = inputStream.read()) != -1) {
            byArray[n2++] = (byte)n;
            if (n2 < 4000) continue;
            string2 = new String(byArray, 0, 0, 4000);
            string = String.valueOf(string) + string2;
            n2 = 0;
        }
        if (n2 > 0) {
            string2 = new String(byArray, 0, 0, n2);
            string = String.valueOf(string) + string2;
        }
        return string;
    }

    public static String binaryArraytoString(byte[] byArray) throws IOException {
        String string = "";
        int n = Math.min(byArray.length, 255);
        int n2 = 0;
        while (n2 < n) {
            string = byArray[n2] == 0 ? String.valueOf(string) + "/0" : String.valueOf(string) + byArray[n2];
            ++n2;
        }
        return string;
    }

    public static String binaryStreamtoString(InputStream inputStream, int n) throws IOException {
        String string = "";
        if (n == 0) {
            int n2;
            while ((n2 = inputStream.read()) != -1) {
                string = String.valueOf(string) + "/" + n2;
            }
        } else {
            int n3;
            int n4 = n;
            while ((n3 = inputStream.read()) != -1 && n4-- > 0) {
                string = String.valueOf(string) + "/" + n3;
            }
        }
        return string;
    }

    public static int sqlTypeConvert(String string) {
        if (string.equals("Char")) {
            return 1;
        }
        if (string.equals("VarChar")) {
            return 12;
        }
        if (string.equals("LongVarChar")) {
            return -1;
        }
        if (string.equals("Bit")) {
            return -7;
        }
        if (string.equals("TinyInt")) {
            return -6;
        }
        if (string.equals("SmallInt")) {
            return 5;
        }
        if (string.equals("Integer")) {
            return 4;
        }
        if (string.equals("BigInt")) {
            return -5;
        }
        if (string.equals("Float")) {
            return 6;
        }
        if (string.equals("Real")) {
            return 7;
        }
        if (string.equals("Double")) {
            return 8;
        }
        if (string.equals("Numeric")) {
            return 2;
        }
        if (string.equals("Decimal")) {
            return 3;
        }
        if (string.equals("Date")) {
            return 91;
        }
        if (string.equals("Time")) {
            return 92;
        }
        if (string.equals("Timestamp")) {
            return 93;
        }
        if (string.equals("Binary")) {
            return -2;
        }
        if (string.equals("VarBinary")) {
            return -3;
        }
        if (string.equals("LongVarBinary")) {
            return -4;
        }
        if (string.equals("Other")) {
            return 1111;
        }
        if (string.equals("Null")) {
            return 0;
        }
        return 1111;
    }

    public static String sqlTypeConvert(int n) {
        if (n == 1) {
            return "Char";
        }
        if (n == 12) {
            return "VarChar";
        }
        if (n == -1) {
            return "LongVarChar";
        }
        if (n == -7) {
            return "Bit";
        }
        if (n == -6) {
            return "TinyInt";
        }
        if (n == 5) {
            return "SmallInt";
        }
        if (n == 4) {
            return "Integer";
        }
        if (n == -5) {
            return "BigInt";
        }
        if (n == 6) {
            return "Float";
        }
        if (n == 7) {
            return "Real";
        }
        if (n == 8) {
            return "Double";
        }
        if (n == 2) {
            return "Numeric";
        }
        if (n == 3) {
            return "Decimal";
        }
        if (n == 91) {
            return "Date";
        }
        if (n == 92) {
            return "Time";
        }
        if (n == 93) {
            return "Timestamp";
        }
        if (n == -2) {
            return "Binary";
        }
        if (n == -3) {
            return "VarBinary";
        }
        if (n == -4) {
            return "LongVarBinary";
        }
        if (n == 1111) {
            return "Other";
        }
        if (n == 0) {
            return "Null";
        }
        return "Other";
    }

    public static String processEmptyStringData(String string, RelationView relationView, int n, int n2, int n3) throws SQLException {
        if (n3 == 0) {
            string = !(relationView.isNull(n) || n2 != 1 && n2 != 12 && n2 != -1) ? "" : null;
        } else if (n3 == 1 || n2 == -2 || n2 == -3 || n2 == -4 || n2 == 1111) {
            string = null;
        } else if (n3 == 2) {
            switch (n2) {
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "0";
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    string = "";
                    break;
                }
                case 91: {
                    string = "1970-01-01";
                    break;
                }
                case 92: {
                    string = "12:00:00";
                    break;
                }
                case 93: {
                    string = "1970-01-01 12:00:00.0";
                }
            }
        }
        return string;
    }

    public RelationView getParentRelationView() {
        return this._parRV;
    }
}

