/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.pro;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import symantec.itools.db.pro.ConnectionInfo;
import symantec.itools.db.pro.RelationView;
import symantec.itools.db.pro.Session;

public class Request
extends Properties {
    public static final String UNIQUE = new String("0");
    public static final String UNIQUE_MODIFIED = new String("1");
    public static final String ALL = new String("2");
    public static final String REC_POS_FIRST = new String("1");
    public static final String REC_POS_NEW = new String("2");
    public static final String REC_POS_NOPOS = new String("3");
    private ConnectionInfo _conn;
    private String _sql;
    protected Session _sess;

    public Request(Session session, ConnectionInfo connectionInfo) {
        this._sess = session;
        this._conn = connectionInfo;
    }

    public void setRequestProperties(Properties properties) {
        this.transferProperties(properties);
    }

    public Properties getRequestProperties() {
        return this;
    }

    public void setSQL(String string) {
        this._sql = string;
    }

    public String getSQL() {
        return this._sql;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this._conn = connectionInfo;
    }

    public ConnectionInfo getConnectionInfo() {
        return this._conn;
    }

    public RelationView executeRequest() throws SQLException {
        return this._sess.createView(this._conn, this._sql, this);
    }

    protected int getOptConc() {
        String string = this.getProperty("optConc", UNIQUE_MODIFIED);
        Integer n = Integer.valueOf(string);
        return n;
    }

    protected String getInitialRecordPos() {
        return this.getProperty("recPosition", REC_POS_NOPOS);
    }

    private void transferProperties(Properties properties) {
        ((Hashtable)this).put("optConc", properties.getProperty("optConc", UNIQUE_MODIFIED));
        ((Hashtable)this).put("recPosition", properties.getProperty("recPosition", REC_POS_NOPOS));
    }

    public void setOptimisticConcurrency(String string) {
        if (string.equals("All")) {
            ((Hashtable)this).put("optConc", ALL);
            return;
        }
        if (string.equals("Unique")) {
            ((Hashtable)this).put("optConc", UNIQUE);
            return;
        }
        ((Hashtable)this).put("optConc", UNIQUE_MODIFIED);
    }

    public void setInitialRecordPosition(String string) {
        if (string.equals("First")) {
            ((Hashtable)this).put("recPosition", REC_POS_FIRST);
            return;
        }
        if (string.equals("New")) {
            ((Hashtable)this).put("recPosition", REC_POS_NEW);
            return;
        }
        ((Hashtable)this).put("recPosition", REC_POS_NOPOS);
    }

    Session getSession() {
        return this._sess;
    }
}

