/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.pro;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.Entity;
import symantec.itools.db.net.Field;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NetString;
import symantec.itools.db.net.Param;
import symantec.itools.db.net.RemoteObject;
import symantec.itools.db.net.SQLConnectionException;
import symantec.itools.db.net.TextParam;
import symantec.itools.db.pro.AutoDetail;
import symantec.itools.db.pro.ConnectionInfo;
import symantec.itools.db.pro.Logon;
import symantec.itools.db.pro.MultiView;
import symantec.itools.db.pro.RelationView;
import symantec.itools.db.pro.Request;
import symantec.itools.db.pro.SessionMetaData;

public class Session {
    protected boolean _isClosed;
    protected ClientSession _session;
    protected RemoteObject _messgr;
    protected Vector _metadataObjs = new Vector();
    protected Vector _multiViews = new Vector();
    protected Logon _logonObj;
    protected ConnectionInfo _defaultConn;
    protected String _serverURL;
    protected boolean _designtime = false;
    protected String _name = "";
    protected final int METHOD_close = 0;
    protected final int METHOD_getMetaData = 1;
    protected final int METHOD_createView = 2;
    protected final int METHOD_inquireDSN = 3;

    public Session() {
    }

    public Session(String string) throws SQLException {
        this._designtime = true;
        this.init(string);
    }

    public Session(String string, boolean bl) throws SQLException {
        this._designtime = bl;
        this.init(string);
    }

    private void init(String string) throws SQLException {
        this._serverURL = string;
        this._isClosed = false;
        this._defaultConn = new ConnectionInfo("");
        if (!this.isDesignTime()) {
            this.connect(string);
            Vector vector = new Vector();
            int n = this._messgr.invokeConstructor(1, vector);
            this._messgr.setObject("CSCLClientSession", n);
        }
    }

    boolean isDesignTime() {
        return this._designtime;
    }

    public String getServerURL() throws SQLException {
        return this._serverURL;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setLogonObject(Logon logon) throws SQLException {
        this._logonObj = logon;
    }

    public void setDefaultConnection(ConnectionInfo connectionInfo) throws SQLException {
        this._defaultConn = connectionInfo;
    }

    Vector getDesignTimeMVResults(Hashtable hashtable) {
        Vector vector = this.getDesignTimeRVResults(hashtable);
        vector.insertElementAt(new NetData(0), 0);
        return vector;
    }

    Vector getDesignTimeRVResults(Hashtable hashtable) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(new NetData(0));
        vector.addElement(new NetString("relview"));
        vector.addElement(new Entity());
        vector.addElement((String)hashtable.get("recPosition"));
        vector.addElement((Integer)hashtable.get("optConc"));
        vector.addElement((Integer)hashtable.get("cardinality"));
        vector.addElement((String)hashtable.get("sql"));
        vector.addElement((Vector)hashtable.get("joincols"));
        return vector;
    }

    public RelationView createView(ConnectionInfo connectionInfo, String string, Properties properties) throws SQLException {
        Hashtable hashtable = RelationView.convertViewProps(properties);
        MultiView multiView = this.createMultiView(connectionInfo, string, hashtable);
        this.addMultiView(multiView);
        RelationView relationView = new RelationView(multiView, 0, connectionInfo);
        return relationView;
    }

    MultiView createMultiView(ConnectionInfo connectionInfo, String string, Hashtable hashtable) throws SQLException {
        if (connectionInfo == null) {
            throw new SQLException("ConnectionInfo object is null");
        }
        Integer n = (Integer)hashtable.get("optConc");
        Integer n2 = (Integer)hashtable.get("maxRecords");
        Boolean bl = (Boolean)hashtable.get("readOnly");
        Boolean bl2 = (Boolean)hashtable.get("sharable");
        String string2 = new String("RelView");
        String string3 = (String)hashtable.get("recPosition");
        if (this.isDesignTime()) {
            hashtable.put("cardinality", Integer.valueOf(AutoDetail.ONE_TO_MANY));
            hashtable.put("sql", string);
            hashtable.put("joincols", new Vector());
            Vector vector = this.getDesignTimeMVResults(hashtable);
            return new MultiView(this, vector, connectionInfo);
        }
        int n3 = 0;
        while (true) {
            String string4 = connectionInfo.getUser();
            String string5 = connectionInfo.getPassword();
            String string6 = connectionInfo.getDBString();
            Vector<Field> vector = new Vector<Field>();
            vector.addElement(new TextParam(0, string6));
            vector.addElement(new TextParam(0, string2));
            vector.addElement(new TextParam(0, string));
            vector.addElement(new Param(0, n));
            vector.addElement(new Param(0, n2));
            vector.addElement(new Param(0, bl));
            vector.addElement(new Param(0, bl2));
            vector.addElement(new TextParam(0, string4));
            vector.addElement(new TextParam(0, string5));
            vector.addElement(new Param(0, connectionInfo.getAutoDisconnect()));
            try {
                Vector vector2 = this._messgr.invokeMethod(2, vector);
                vector2.addElement(string3);
                vector2.addElement(n);
                vector2.addElement(Integer.valueOf(AutoDetail.ONE_TO_MANY));
                vector2.addElement(string);
                vector2.addElement(new Vector());
                MultiView multiView = new MultiView(this, vector2, connectionInfo);
                return multiView;
            }
            catch (SQLConnectionException sQLConnectionException) {
                if (this.logonFailed(connectionInfo, ++n3)) continue;
                throw sQLConnectionException;
            }
            break;
        }
    }

    public RelationView createView(ConnectionInfo connectionInfo, String string, Vector vector, Properties properties) throws SQLException {
        String string2 = new String("select ");
        if (vector == null) {
            string2 = String.valueOf(string2) + "* ";
        } else if (vector.size() == 0) {
            string2 = String.valueOf(string2) + "* ";
        } else {
            String string3 = (String)vector.elementAt(0);
            string2 = String.valueOf(string2) + string3;
            int n = 1;
            while (n < vector.size()) {
                string3 = (String)vector.elementAt(n);
                string2 = String.valueOf(string2) + ", " + string3;
                ++n;
            }
        }
        string2 = String.valueOf(string2) + " from " + string;
        return this.createView(connectionInfo, string2, properties);
    }

    public RelationView createView(ConnectionInfo connectionInfo, String string) throws SQLException {
        return this.createView(connectionInfo, string, new Properties());
    }

    public RelationView createView(ConnectionInfo connectionInfo, String string, Vector vector) throws SQLException {
        return this.createView(connectionInfo, string, vector, new Properties());
    }

    public RelationView createView(String string) throws SQLException {
        return this.createView(this._defaultConn, string);
    }

    public RelationView createView(String string, Vector vector) throws SQLException {
        return this.createView(this._defaultConn, string, vector);
    }

    public Request getRequest() throws SQLException {
        return this.getRequest("");
    }

    public Request getRequest(String string) throws SQLException {
        Request request = new Request(this, this._defaultConn);
        request.setSQL(string);
        return request;
    }

    public SessionMetaData getMetaData(ConnectionInfo connectionInfo) throws SQLException {
        if (this.isDesignTime()) {
            throw new SQLException("DatabaseMetaData is not available during DesignTime");
        }
        int n = 0;
        while (true) {
            String string = connectionInfo.getUser();
            String string2 = connectionInfo.getPassword();
            String string3 = connectionInfo.getDBString();
            Vector<TextParam> vector = new Vector<TextParam>();
            vector.addElement(new TextParam(0, string3));
            vector.addElement(new TextParam(0, string));
            vector.addElement(new TextParam(0, string2));
            try {
                Vector vector2 = this._messgr.invokeMethod(1, vector);
                SessionMetaData sessionMetaData = new SessionMetaData(this, vector2, connectionInfo);
                this._metadataObjs.addElement(sessionMetaData);
                return sessionMetaData;
            }
            catch (SQLConnectionException sQLConnectionException) {
                if (this.logonFailed(connectionInfo, ++n)) continue;
                throw sQLConnectionException;
            }
            break;
        }
    }

    public RelationView inquireDSN() throws SQLException {
        Object object;
        Vector vector;
        if (!this.isDesignTime()) {
            vector = this._messgr.invokeMethod(3);
            vector.addElement(Request.REC_POS_NOPOS);
            vector.addElement(Integer.valueOf(Request.UNIQUE_MODIFIED));
            vector.addElement(Integer.valueOf(AutoDetail.ONE_TO_MANY));
            vector.addElement("");
            vector.addElement(new Vector());
        } else {
            object = RelationView.convertViewProps(new Properties());
            ((Hashtable)object).put("cardinality", Integer.valueOf(AutoDetail.ONE_TO_MANY));
            ((Hashtable)object).put("sql", "");
            ((Hashtable)object).put("joincols", new Vector());
            vector = this.getDesignTimeMVResults((Hashtable)object);
        }
        object = new MultiView(this, vector, new ConnectionInfo(""));
        this.addMultiView((MultiView)object);
        return ((MultiView)object).getRootRelView();
    }

    public void close() throws SQLException {
        if (!this._isClosed) {
            int n = 0;
            while (n < this._multiViews.size()) {
                MultiView multiView = (MultiView)this._multiViews.elementAt(n);
                try {
                    multiView.close();
                }
                catch (SQLException sQLException) {}
                ++n;
            }
            this._multiViews.removeAllElements();
            this._metadataObjs.removeAllElements();
            if (!this.isDesignTime()) {
                this._messgr.invokeMethod(0);
                this._session.close();
            }
            this._session = null;
            this._messgr = null;
            this._isClosed = true;
        }
    }

    protected StringTokenizer parseURL(String string) throws SQLException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string2 = stringTokenizer.nextToken(":");
            if (!string2.equals("dbaw")) {
                throw new SQLException("Unrecognized protocol.");
            }
            String string3 = stringTokenizer.nextToken("");
            return new StringTokenizer(string3);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("Invalid URL syntax.");
        }
    }

    protected Properties parseSubname(StringTokenizer stringTokenizer) throws SQLException {
        try {
            Properties properties = new Properties();
            String string = stringTokenizer.nextToken(":/");
            String string2 = stringTokenizer.nextToken(":/");
            ((Hashtable)properties).put("host", string);
            ((Hashtable)properties).put("port", string2);
            return properties;
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new SQLException("Invalid subname syntax.");
        }
    }

    protected void connect(String string) throws SQLException {
        this._session = null;
        this._messgr = null;
        this._isClosed = true;
        this._metadataObjs = new Vector();
        this._multiViews = new Vector();
        try {
            StringTokenizer stringTokenizer = this.parseURL(string);
            Properties properties = this.parseSubname(stringTokenizer);
            String string2 = properties.getProperty("host", "");
            int n = Integer.parseInt(properties.getProperty("port", "0"));
            this._session = new ClientSession(string2, n, "", true);
            this._messgr = new RemoteObject("CSCLClientSession", 0, this._session);
            if (this.isDesignTime()) {
                this._messgr.disable();
            }
            this._isClosed = false;
            return;
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    boolean logonFailed(ConnectionInfo connectionInfo, int n) {
        if (this._logonObj == null) {
            return false;
        }
        return this._logonObj.logonFailed(connectionInfo, n);
    }

    ClientSession getClientSession() {
        return this._session;
    }

    void addMultiView(MultiView multiView) {
        this._multiViews.addElement(multiView);
    }
}

