/*
 * Decompiled with CFR 0.152.
 */
import com.symantec.itools.javax.swing.borders.TitledBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class FileEditor
extends JFrame {
    public static PrintUtil pu = new PrintUtil(null);
    public static ThermoUtil2 tUtil2 = new ThermoUtil2();
    boolean frameSizeAdjusted = false;
    FileDialog openFileDialog = new FileDialog(this);
    FileDialog saveFileDialog = new FileDialog(this);
    JScrollPane JScrollPanefv = new JScrollPane();
    JTextArea JTextArea_fv = new JTextArea();
    TitledBorder titledBorder_fv = new TitledBorder();
    JButton JButton_close = new JButton();
    JButton JButton_print = new JButton();

    public FileEditor() {
        this.setTitle("FileEditor");
        this.getContentPane().setLayout(null);
        ((Component)this).setSize(827, 639);
        this.setVisible(false);
        this.openFileDialog.setMode(0);
        this.saveFileDialog.setMode(0);
        this.JScrollPanefv.setHorizontalScrollBarPolicy(32);
        this.JScrollPanefv.setVerticalScrollBarPolicy(22);
        this.JScrollPanefv.setOpaque(true);
        this.getContentPane().add(this.JScrollPanefv);
        this.JScrollPanefv.setBounds(18, 38, 758, 469);
        this.JTextArea_fv.setFont(new Font("MonoSpaced", 0, 12));
        this.JTextArea_fv.setCaretColor(Color.magenta);
        this.JTextArea_fv.setBorder(this.titledBorder_fv);
        this.JScrollPanefv.getViewport().add(this.JTextArea_fv);
        this.JTextArea_fv.setBounds(0, 0, 738, 449);
        this.titledBorder_fv.setTitle("File Viewer");
        this.JButton_close.setText("Close");
        this.JButton_close.setActionCommand("Cancel");
        this.getContentPane().add(this.JButton_close);
        this.JButton_close.setBounds(396, 529, 132, 36);
        this.JButton_print.setText("Print");
        this.JButton_print.setActionCommand("Print");
        this.getContentPane().add(this.JButton_print);
        this.JButton_print.setBounds(187, 529, 132, 36);
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        SymAction symAction = new SymAction();
        this.JButton_close.addActionListener(symAction);
        this.JButton_print.addActionListener(symAction);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            ((Component)this).setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void setFile(String string) {
        if (string == null) {
            return;
        }
        string = this.openFV(string);
        this.pack();
        ((Component)this).setSize(820, 600);
        this.setTitle("FileEditor:" + string);
        this.setVisible(true);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        ((Component)this).setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    void FileEditor_windowClosing(WindowEvent windowEvent) {
        this.FileEditor_windowClosing_Interaction1(windowEvent);
    }

    void FileEditor_windowClosing_Interaction1(WindowEvent windowEvent) {
        try {
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flashScreen();
    }

    public void flashScreen() {
        this.repaint();
    }

    public boolean copyExample(String string) {
        Object object;
        Object object2;
        Vector<String> vector = new Vector<String>();
        char c = System.getProperty("file.separator").charAt(0);
        String[] stringArray = null;
        int n = 0;
        Vector vector2 = new Vector();
        String string2 = null;
        File file = new File(string);
        String string3 = file.getName();
        boolean bl = file.canRead();
        boolean bl2 = file.isFile();
        string2 = file.getPath();
        String string4 = string3.toLowerCase();
        if (!string4.endsWith(".inp")) {
            return false;
        }
        try {
            FileReader fileReader = new FileReader(string);
            object2 = new BufferedReader(fileReader);
            object = null;
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                ++n;
                vector.addElement((String)object);
            }
            ((BufferedReader)object2).close();
        }
        catch (Throwable throwable) {
            return false;
        }
        stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = vector.elementAt(n2).toString();
            ++n2;
        }
        object2 = file.getName();
        object = new File((String)object2);
        if (((File)object).exists()) {
            // empty if block
        }
        if (object2 == null) {
            // empty if block
        }
        try {
            FileWriter fileWriter = new FileWriter((String)object2);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            int n3 = 0;
            while (n3 < n) {
                bufferedWriter.write(stringArray[n3]);
                bufferedWriter.newLine();
                ++n3;
            }
            bufferedWriter.close();
        }
        catch (Throwable throwable) {
            System.err.println("\n\t ERROR: copyExample()--FileWriter(" + (String)object2 + " ); Throwable e2=" + throwable);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean copyFile(String string, String string2) {
        Object object;
        Object object2;
        Vector<String> vector = new Vector<String>();
        char c = System.getProperty("file.separator").charAt(0);
        String[] stringArray = null;
        int n = 0;
        Vector vector2 = new Vector();
        String string3 = null;
        File file = new File(string);
        String string4 = file.getName();
        boolean bl = file.canRead();
        boolean bl2 = file.isFile();
        string3 = file.getPath();
        try {
            FileReader fileReader = new FileReader(string);
            object2 = new BufferedReader(fileReader);
            object = null;
            while (true) {
                if ((object = ((BufferedReader)object2).readLine()) == null) {
                    ((BufferedReader)object2).close();
                    break;
                }
                ++n;
                vector.addElement((String)object);
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = vector.elementAt(n2).toString();
            ++n2;
        }
        try {
            object2 = new File(string2);
            if (((File)object2).exists()) {
                // empty if block
            }
            if (string2 != null) {
                // empty if block
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object2 = new FileWriter(string2);
            object = new BufferedWriter((Writer)object2);
            int n3 = 0;
            while (true) {
                if (n3 >= n) {
                    ((BufferedWriter)object).close();
                    return true;
                }
                ((Writer)object).write(stringArray[n3]);
                ((BufferedWriter)object).newLine();
                ++n3;
            }
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public boolean chkValidLib(String string) {
        String string2 = string.toLowerCase();
        if (!string2.equals("thermo.lib")) {
            File file = new File(string2);
            if (file.exists()) {
                return file.length() > 0L;
            }
        } else if (!string2.equals("trans.lib")) {
            File file = new File(string2);
            if (file.exists()) {
                return file.length() > 0L;
            }
        } else {
            return false;
        }
        return false;
    }

    public boolean isValidFV(String string) {
        boolean bl = false;
        if (string == null) {
            JOptionPane.showMessageDialog(null, " INPUT File is NOT specified ! \n Please select a File from File Menu.", "Error Message", 0);
            return bl;
        }
        String string2 = string.toLowerCase();
        File file = new File(string);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, " File: " + string + " does NOT exist at the current Directory ! ", "Error Message", 0);
            bl = false;
            return bl;
        }
        if (!(string2.endsWith(".lib") || string2.endsWith(".inp") || string2.endsWith(".out") || string2.endsWith(".plt"))) {
            JOptionPane.showMessageDialog(null, " Invalid File: " + string + " does NOT end with .lib, .inp, .out, .plt! ", "Error Message", 0);
            return bl;
        }
        int n = (int)file.length();
        if (n == 0) {
            JOptionPane.showMessageDialog(null, " File: " + string + " has length zero! ", "Error Message", 0);
            return bl;
        }
        if (!file.canRead()) {
            JOptionPane.showMessageDialog(null, " File: " + string + " does NOT readable! ", "Error Message", 0);
            return bl;
        }
        bl = true;
        return bl;
    }

    public void viewFV(JTextArea jTextArea) {
        String string = jTextArea.getText();
        if (string == null) {
            return;
        }
        this.pack();
        ((Component)this).setSize(820, 600);
        this.setTitle("Current File:  " + CEAgui.curFile);
        this.setVisible(true);
    }

    String openFV(String string) {
        return this.openFV(string, this.JTextArea_fv);
    }

    String openFV(String string, JTextArea jTextArea) {
        char c = System.getProperty("file.separator").charAt(0);
        String string2 = System.getProperty("user.dir") + c;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = new String();
        boolean bl = false;
        boolean bl2 = false;
        try {
            int n;
            this.openFileDialog = new FileDialog((Frame)this, "Open File", 0);
            if (string == null) {
                this.openFileDialog.setFile("*.inp");
                ((Component)this.openFileDialog).setVisible(true);
                string = this.openFileDialog.getFile();
                string3 = this.openFileDialog.getDirectory();
                string4 = this.openFileDialog.getName();
                if (string.equals("thermo.inp")) {
                    System.out.println("\t FileEditor_openFV() -- file: " + string);
                    JOptionPane.showMessageDialog(null, " " + string + " is a thermodynamic data file for individual species. Please open a different file!   ", "Warning Message", 1);
                    return null;
                }
                if (string.equals("trans.inp")) {
                    System.out.println("\t FileEditor_openFV() -- file: " + string);
                    JOptionPane.showMessageDialog(null, " " + string + " is a thermal transport properties file. Please open a different file!   ", "Warning Message", 1);
                    return null;
                }
                if (!string2.equals(string3)) {
                    string5 = string3 + string;
                    bl = this.copyExample(string5);
                    if (!bl) {
                        return null;
                    }
                    JOptionPane.showMessageDialog(null, " The file= " + string5 + " is copied to current directory:\n   " + string2, "Warning Message", 1);
                }
                if ((n = string.indexOf(".inp")) == -1) {
                    return null;
                }
                string6 = string.substring(0, n) + ".BAK";
                bl2 = ThermoUtil2.syntaxCheck(string);
                if (!bl2) {
                    return null;
                }
            }
            if (!this.isValidFV(string)) {
                return null;
            }
            n = this.ReadFV(string, jTextArea);
            if (n == 0) {
                string = null;
            }
            return string;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, " Open File: " + string + " NOT Found in the current directory ! ", "Error Message", 0);
            return string;
        }
    }

    boolean ReadFV(String string, JTextArea jTextArea) {
        int n = 0;
        this.setCursor(Cursor.getPredefinedCursor(3));
        File file = new File(string);
        try {
            FileReader fileReader = new FileReader(file);
            n = (int)file.length();
            char[] cArray = new char[n];
            fileReader.read(cArray, 0, n);
            jTextArea.setText(new String(cArray));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, " Can not OPEN A File:" + string + " !", "Error Message", 0);
            return false;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    public String[] parseEndLineKWString() {
        Object object;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = ProcessData.KWSize;
        int n3 = 0;
        while (n3 < n2) {
            String string = ProcessData.getKWString(n3);
            if (string == null) {
                if (n3 == 0 || n3 == 1) {
                    JOptionPane.showMessageDialog(null, " Missing MANDATORY dataset:  " + ProcessData.kwDesc[n3] + ". Please enter the data.", "Warning Message", 1);
                    CEAgui.cea.JTabbedPane1.setSelectedIndex(n3);
                    return null;
                }
            } else {
                object = new StringTokenizer(string, "\n\t");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object).nextToken();
                    if (string2 == null) continue;
                    vector.addElement(string2);
                    ++n;
                }
            }
            ++n3;
        }
        int n4 = vector.size();
        object = ThermoUtil2.convVectorString(vector);
        int n5 = ((String[])object).length;
        return object;
    }

    public boolean WriteFile(String string) {
        String[] stringArray;
        if (string == null) {
            return false;
        }
        File file = new File(string);
        if (file.exists()) {
            // empty if block
        }
        if ((stringArray = this.parseEndLineKWString()) == null) {
            return false;
        }
        int n = stringArray.length;
        try {
            FileWriter fileWriter = new FileWriter(string);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2];
                if (string2 == null) {
                    if (n2 == 0 || n2 == 1) {
                        return false;
                    }
                } else {
                    bufferedWriter.write(string2);
                    bufferedWriter.newLine();
                }
                ++n2;
            }
            bufferedWriter.close();
            CEAgui.isNewItemSelected = false;
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public static boolean UpdateTAFromKW(JTextArea jTextArea) {
        String string = CEAgui.curFile;
        jTextArea.setText("");
        int n = 0;
        String string2 = "";
        boolean bl = false;
        int n2 = 0;
        while (n2 < ProcessData.KWSize) {
            string2 = ProcessData.kwString[n2];
            bl = ProcessData.isKWSelected[n2];
            if (ProcessData.kwString[n2] != null) {
                n += string2.length();
                jTextArea.append(string2.trim() + "\n");
            } else if (n2 == 6 && n != 0) {
                ProcessData.setKWString("end", "\n end");
                ProcessData.isKWSelected[n2] = true;
            }
            ++n2;
        }
        return n != 0;
    }

    void JButtonExit_actionPerformed(ActionEvent actionEvent) {
        this.JButton_close_actionPerformed_Interaction1(actionEvent);
    }

    void JButton_close_actionPerformed_Interaction1(ActionEvent actionEvent) {
        try {
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flashScreen();
    }

    void JButtonPrint_actionPerformed(ActionEvent actionEvent) {
        this.JButton_print_actionPerformed_Interaction1(actionEvent);
    }

    void JButton_print_actionPerformed_Interaction1(ActionEvent actionEvent) {
        try {
            this.JButton_print.requestFocus();
            String string = this.JTextArea_fv.getText();
            if (string != null) {
                PrintUtil.printComponent(this.JTextArea_fv);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.flashScreen();
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == FileEditor.this.JButton_close) {
                FileEditor.this.JButtonExit_actionPerformed(actionEvent);
            } else if (object == FileEditor.this.JButton_print) {
                FileEditor.this.JButtonPrint_actionPerformed(actionEvent);
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == FileEditor.this) {
                FileEditor.this.FileEditor_windowClosing(windowEvent);
            }
        }
    }
}

