/*
 * Decompiled with CFR 0.152.
 */
import com.symantec.itools.util.StringTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class ThermoUtil2 {
    public static String keyReact = "";
    public static String[] b1Data = ThermoData.getB1String();
    public static String[] b2Data = ThermoData.getB2String();
    public static String[] b3Data = ThermoData.getB3String();
    public static Vector B1Vector = new Vector();
    public static Vector B2Vector = new Vector();
    public static Vector B3Vector = new Vector();
    static String[] ptData = ThermoData.getPTable();
    int b1sz = b1Data.length;
    int b2sz = b2Data.length;
    int b3sz = b3Data.length;
    int ptsz = ptData.length;

    public static String[] convVectorString(Vector vector) {
        int n = vector.size();
        if (n < 0) {
            System.out.println(" convVectorString(v)--ERROR: NULL Vector");
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = vector.elementAt(n2).toString();
            ++n2;
        }
        return stringArray;
    }

    public Vector convStringVector(String[] stringArray) {
        int n = stringArray.length;
        Vector<String> vector = new Vector<String>(n);
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            vector.addElement(string);
            ++n2;
        }
        return vector;
    }

    public Vector getB1Vector() {
        Vector vector = this.convStringVector(b1Data);
        return vector;
    }

    public Vector getB2Vector() {
        Vector vector = this.convStringVector(b1Data);
        return vector;
    }

    public Vector getB3Vector() {
        Vector vector = this.convStringVector(b3Data);
        return vector;
    }

    public boolean isValidSpecie(String string) {
        boolean bl = false;
        string = "" + string + "";
        B1Vector = this.getB1Vector();
        B2Vector = this.getB2Vector();
        B3Vector = this.getB3Vector();
        if (B1Vector.contains(string)) {
            bl = true;
        } else if (B2Vector.contains(string)) {
            bl = true;
        } else if (B3Vector.contains(string)) {
            bl = true;
        }
        return bl;
    }

    boolean WriteVector(String string, Vector vector) {
        boolean bl = false;
        int n = vector.size();
        if (n == 0) {
            return false;
        }
        String[] stringArray = ThermoUtil2.convVectorString(vector);
        int n2 = stringArray.length;
        File file = new File(string);
        try {
            FileWriter fileWriter = new FileWriter(file);
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                int n4 = string2.length();
                if (string2 == null) {
                    // empty if block
                }
                fileWriter.write(string2, 0, string2.length());
                ++n3;
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            System.out.println("IOException_SAVE: " + string + exception);
            JOptionPane.showMessageDialog(null, " FileWriter(): IO Exception for saving data to A File:" + string + " !", "Error Message", 0);
            return false;
        }
        return true;
    }

    boolean WriteAtoms(String string, String string2) {
        boolean bl = false;
        if (string2.length() == 0) {
            return false;
        }
        File file = new File(string);
        try {
            FileWriter fileWriter = new FileWriter(file);
            String string3 = " ENDR\n";
            String string4 = "   \n";
            String string5 = this.parseAtoms(string2);
            if (string5 == null) {
                return false;
            }
            fileWriter.write(string3, 0, string3.length());
            int n = string5.length();
            fileWriter.write(string5, 0, n);
            fileWriter.write(string4, 0, string4.length());
            fileWriter.write(string4, 0, string4.length());
            fileWriter.write(string4, 0, string4.length());
            fileWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, " IOException for SAVE A File:" + string + " !", "Error Message", 0);
            return false;
        }
        return true;
    }

    boolean WriteList(String string, JTextField jTextField) {
        boolean bl = false;
        File file = new File(string);
        try {
            FileWriter fileWriter = new FileWriter(file);
            String string2 = jTextField.getText().trim();
            String string3 = this.parseAtoms(string2);
            if (string3 == null) {
                return false;
            }
            int n = string3.length();
            fileWriter.write(string3, 0, n);
            fileWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "IOException for SAVE A File:" + string + " !", "Error Message", 0);
            return false;
        }
        return true;
    }

    public static Vector ReadList(String string) {
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        if (file.exists()) {
            try {
                String string2;
                FileInputStream fileInputStream = new FileInputStream(string);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
                while ((string2 = bufferedReader.readLine()) != null) {
                    vector.addElement(string2);
                    if (string != "input.txt") continue;
                    System.out.println("\n\t ReadList(" + string + ")-str=[" + string2 + "]");
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                System.err.println(exception);
                vector = null;
            }
        } else {
            vector = null;
        }
        return vector;
    }

    public static boolean isConfigFileOK() {
        String[] stringArray = new String[]{"FCEA2", "b1b2b3", "syntax", "thermo.lib", "trans.lib", "CEAgui.jar"};
        boolean[] blArray = new boolean[]{false, false, false, false, false, false};
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.arch");
        String string3 = System.getProperty("os.version");
        System.out.println("@@@osname=" + string + " osarch=" + string2 + " osversion=" + string3);
        String string4 = ".exe";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            string6 = stringArray[n2];
            string7 = string6.endsWith(".lib") || string6.endsWith(".jar") ? string6 : (string.startsWith("windows") ? string6 + string4 : string6);
            File file = new File(string7);
            if (!file.exists()) {
                stringArray[n2] = string7;
                blArray[n2] = false;
            } else {
                stringArray[n2] = string7;
                blArray[n2] = true;
            }
            ++n2;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (!blArray[n4]) {
                string5 = string5 + stringArray[n4] + " , ";
                ++n3;
                System.out.println("\n\t ERROR: Missing CEAgui Configuration Files:" + string5 + "  cmdList[" + n4 + "] = " + stringArray[n4]);
            }
            ++n4;
        }
        int n5 = n3;
        System.out.println("@@@ Total missing Configration files = " + n5);
        if (n5 > 0) {
            JOptionPane.showMessageDialog(null, "Total " + n5 + " Configuration files: " + string5 + " NOT FOUND ! Please verify. ", "Error Message", 0);
            return false;
        }
        return true;
    }

    public static boolean isValidSyntaxCmd(String string) {
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = System.getProperty("os.arch");
        String string4 = System.getProperty("os.version");
        String string5 = ".exe";
        if (string == null) {
            string = "syntax";
        }
        String string6 = "";
        string6 = string2.startsWith("windows") ? string + string5 : string;
        File file = new File(string6);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, " The Fortran Executable File: " + string6 + " does NOT exist ! ", "Error Message", 0);
            return false;
        }
        string5 = null;
        return true;
    }

    public static boolean syntaxCheck(String string) {
        boolean bl;
        Object object;
        FileEditor fileEditor = new FileEditor();
        int n = string.indexOf(".inp");
        if (n == -1) {
            return false;
        }
        String string2 = string.substring(0, n);
        String string3 = "GUIfile.txt";
        String string4 = "GUIfile2.txt";
        try {
            object = "syntax";
            if (!ThermoUtil2.isValidSyntaxCmd((String)object)) {
                return false;
            }
            bl = fileEditor.copyFile(string, string3);
            Process process = Runtime.getRuntime().exec((String)object);
            InputStream inputStream = process.getErrorStream();
            InputStream inputStream2 = process.getInputStream();
            int n2 = -1;
            try {
                n2 = process.waitFor();
                if (n2 != 0) {
                    InputStream inputStream3 = process.getErrorStream();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream3);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String string5 = bufferedReader.readLine();
                    if (string5 != null) {
                        JOptionPane.showMessageDialog(null, " ERROR: waitValue=" + n2 + "\n File " + (String)object + " not found! Runtime.getRuntime().exec() not complete due to the missing thermo.lib or trans.lib or BAD data!", "Error Message", 0);
                        return false;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            if (process.exitValue() != 0) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        object = new File(string4);
        bl = ((File)object).canRead();
        boolean bl2 = ((File)object).isFile();
        if (!bl2) {
            return false;
        }
        if (!bl) {
            return false;
        }
        boolean bl3 = fileEditor.copyFile(string4, string);
        return bl3;
    }

    public static boolean isValidB1b2b3Cmd(String string) {
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = System.getProperty("os.arch");
        String string4 = System.getProperty("os.version");
        String string5 = ".exe";
        if (string == null) {
            string = "b1b2b3";
        }
        String string6 = "";
        string6 = string2.startsWith("windows") ? string + string5 : string;
        File file = new File(string6);
        if (!file.exists()) {
            JOptionPane.showMessageDialog(null, " The Fortran Executable File: " + string6 + " does NOT exist ! ", "Error Message", 0);
            return false;
        }
        string5 = null;
        return true;
    }

    public static Vector runB1b2b3(String string, String string2, String string3, String string4) {
        boolean bl;
        FileEditor fileEditor = new FileEditor();
        boolean bl2 = fileEditor.chkValidLib("thermo.lib");
        if (!bl2) {
            JOptionPane.showMessageDialog(null, " ERROR: thermo.lib is not found!", "Error Message", 0);
            System.exit(1);
        }
        if (!(bl = fileEditor.chkValidLib("trans.lib"))) {
            JOptionPane.showMessageDialog(null, " ERROR: trans.lib is not found!", "Error Message", 0);
            System.exit(1);
        }
        try {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            Vector<Vector> vector4 = new Vector<Vector>();
            String string5 = "b1b2b3";
            if (!ThermoUtil2.isValidB1b2b3Cmd(string5)) {
                return null;
            }
            String string6 = string.toLowerCase();
            Process process = Runtime.getRuntime().exec(string5);
            InputStream inputStream = process.getErrorStream();
            InputStream inputStream2 = process.getInputStream();
            int n = -1;
            try {
                n = process.waitFor();
                if (n != 0) {
                    InputStream inputStream3 = process.getErrorStream();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream3);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String string7 = bufferedReader.readLine();
                    if (string7 != null) {
                        JOptionPane.showMessageDialog(null, " ERROR: waitValue=" + n + "\n File not found!  Runtime.getRuntime().exec(" + string5 + ") not complete due to the missing thermo.lib or trans.lib or BAD data!", "Error Message", 0);
                        return null;
                    }
                    InputStream inputStream4 = process.getInputStream();
                    InputStreamReader inputStreamReader2 = new InputStreamReader(inputStream4);
                    BufferedReader bufferedReader2 = new BufferedReader(inputStreamReader2);
                    String string8 = bufferedReader2.readLine();
                    if (string8 != null) {
                        JOptionPane.showMessageDialog(null, " ERROR: readIn = " + string8 + "\n Runtime.getRuntime().exec(" + string5 + ") not complete due to the missing thermo.lib or trans.lib or BAD data!", "Error Message", 0);
                        return null;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
            if (process.exitValue() != 0) {
                return null;
            }
            vector = ThermoUtil2.ReadList(string2);
            vector4.add(vector);
            vector2 = ThermoUtil2.ReadList(string3);
            vector4.add(vector2);
            vector3 = ThermoUtil2.ReadList(string4);
            vector4.add(vector3);
            return vector4;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return null;
        }
    }

    public String parseAtoms(String string) {
        String string2 = " ";
        String string3 = "";
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().toUpperCase();
            int n2 = string4.length();
            if (n2 <= 3) {
                if (n2 == 1) {
                    string3 = string3 + string4 + "  ";
                } else if (n2 == 2) {
                    string3 = string3 + string4 + " ";
                } else if (n2 == 3 || string4.equals("AIR")) {
                    string3 = string3 + "Air ";
                }
            }
            ++n;
        }
        string3 = n == 0 ? null : " " + string3 + "\n";
        return string3;
    }

    public String[] matchedNameFromList(String string, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = stringArray.length;
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2].indexOf(string) != -1) {
                    vector.addElement(stringArray[n2]);
                }
                ++n2;
            }
            int n3 = vector.size();
            if (n3 > 0) {
                String[] stringArray2 = ThermoUtil2.convVectorString(vector);
                this.displayList(stringArray2);
                return stringArray2;
            }
            return null;
        }
        return null;
    }

    public int parseLine(String string, Vector vector) {
        String string2 = " ";
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            vector.addElement(string3);
            ++n;
        }
        vector.setSize(n);
        int n2 = vector.size();
        return n2;
    }

    public String[] matchedNameInArr(String string, String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = stringArray.length;
        if (n > 0) {
            int n2;
            int n3 = 0;
            while (n3 < n) {
                n2 = stringArray[n3].indexOf(string);
                if (n2 != -1) {
                    vector.addElement(stringArray[n3]);
                }
                ++n3;
            }
            n2 = vector.size();
            if (n2 > 0) {
                String[] stringArray2 = ThermoUtil2.convVectorString(vector);
                return stringArray2;
            }
            return null;
        }
        return null;
    }

    public boolean isAtomMatched(String string, String string2) {
        boolean bl = false;
        if (string2.indexOf(string) != -1) {
            bl = true;
        }
        return bl;
    }

    public boolean isAtomValidSpecies(String string, String[] stringArray) {
        boolean bl = false;
        Vector vector = new Vector();
        vector = this.convStringVector(stringArray);
        if (vector.contains(string)) {
            bl = true;
        }
        return bl;
    }

    public int idxAtomContainedSpecies(String string, String[] stringArray) {
        int n = -1;
        Vector vector = new Vector();
        vector = this.convStringVector(stringArray);
        if (vector.contains(string)) {
            n = vector.indexOf(string);
        }
        return n;
    }

    public int idxAtomMatch(String string, String string2) {
        int n = string2.indexOf(string);
        return n;
    }

    public int[] matchedAtomsFlag(String[] stringArray, String[] stringArray2) {
        int n = stringArray2.length;
        int n2 = stringArray.length;
        if (n < 0 || n2 < 0) {
            return null;
        }
        int[] nArray = new int[n];
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = -1;
            ++n3;
        }
        Vector vector = this.convStringVector(ptData);
        this.displayVector(vector);
        int[] nArray2 = new int[n2];
        int n4 = 0;
        while (n4 < n2) {
            nArray2[n4] = -1;
            ++n4;
        }
        int n5 = 0;
        while (n5 < n2) {
            int n6;
            nArray2[n5] = this.idxValidAtomPT(stringArray[n5], vector);
            if (nArray2[n5] == -1) {
                n6 = this.idxAtomContainedSpecies(stringArray[n5], stringArray2);
                if (n6 != -1) {
                    nArray[n6] = 99;
                }
            } else {
                n6 = 0;
                while (n6 < n) {
                    int n7 = this.idxAtomMatch(stringArray[n5], stringArray2[n6]);
                    if (nArray[n6] == -1 && n7 != -1) {
                        nArray[n6] = n7;
                    }
                    if (n7 != -1) {
                        // empty if block
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        return nArray;
    }

    public int idxValidAtomPT(String string, Vector vector) {
        int n = vector.size();
        int n2 = -1;
        if (n > 0 && vector.contains(string)) {
            n2 = vector.indexOf(string);
        }
        return n2;
    }

    public boolean isValidAtomPT(String string, Vector vector) {
        return this.idxValidAtomPT(string, vector) != -1;
    }

    public String[] convModelArr(JList jList) {
        ListModel listModel = jList.getModel();
        int n = listModel.getSize();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = listModel.getElementAt(n2).toString();
            ++n2;
        }
        return stringArray;
    }

    public Vector convModelVector(JList jList) {
        ListModel listModel = jList.getModel();
        int n = listModel.getSize();
        Vector<String> vector = new Vector<String>(n);
        int n2 = 0;
        while (n2 < n) {
            String string = listModel.getElementAt(n2).toString();
            vector.addElement(string);
            ++n2;
        }
        return vector;
    }

    public void displayVector(Vector vector) {
        int n = vector.size();
        String[] stringArray = new String[n];
        String string = "\n";
        int n2 = 0;
        while (n2 < n) {
            String string2 = vector.elementAt(n2).toString();
            if (string2.trim() != null) {
                string = string + " " + string2.trim();
            }
            ++n2;
        }
    }

    public void displayList(String[] stringArray) {
        int n = stringArray.length;
        String string = "";
        if (n < 0) {
            System.exit(1);
        }
        int n2 = 0;
        while (n2 < n) {
            string = string + " " + stringArray[n2];
            ++n2;
        }
    }
}

