/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.awt;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import symantec.itools.beans.PropertyChangeSupport;
import symantec.itools.beans.VetoableChangeSupport;
import symantec.itools.util.GeneralUtils;

public class ImagePanel
extends Panel {
    public static final int IMAGE_TILED = 0;
    public static final int IMAGE_CENTERED = 1;
    public static final int IMAGE_SCALED_TO_FIT = 2;
    public static final int IMAGE_NORMAL = 3;
    protected int imageStyle = 0;
    private transient Image image = null;
    private URL imageURL = null;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ImagePanel() {
        super.setLayout(null);
    }

    public void paint(Graphics graphics) {
        block10: {
            Dimension dimension;
            block9: {
                dimension = this.size();
                if (this.image == null) break block9;
                int n = this.image.getWidth(this);
                int n2 = this.image.getHeight(this);
                switch (this.imageStyle) {
                    default: {
                        int n3 = dimension.width / n;
                        if (dimension.width % n != 0) {
                            ++n3;
                        }
                        int n4 = dimension.height / n2;
                        if (dimension.height % n2 != 0) {
                            ++n4;
                        }
                        int n5 = 0;
                        int n6 = 0;
                        while (n6 < n4) {
                            int n7 = 0;
                            int n8 = 0;
                            while (n8 < n3) {
                                graphics.drawImage(this.image, n7, n5, n, n2, this);
                                n7 += n;
                                ++n8;
                            }
                            n5 += n2;
                            ++n6;
                        }
                        break block10;
                    }
                    case 1: {
                        graphics.drawImage(this.image, (dimension.width - n) / 2, (dimension.height - n2) / 2, n, n2, this);
                        break;
                    }
                    case 2: {
                        graphics.drawImage(this.image, 0, 0, dimension.width, dimension.height, this);
                        break;
                    }
                    case 3: {
                        graphics.drawImage(this.image, 0, 0, this);
                        break;
                    }
                }
                break block10;
            }
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        }
        super.paint(graphics);
    }

    public void setImageURL(URL uRL) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.imageURL, uRL)) {
            this.vetos.fireVetoableChange("imageURL", this.imageURL, uRL);
            this.imageURL = uRL;
            if (this.imageURL != null) {
                if (this.image != null) {
                    this.image.flush();
                    this.image = null;
                }
                this.image = this.getToolkit().getImage(this.imageURL);
                if (this.image != null) {
                    MediaTracker mediaTracker = new MediaTracker(this);
                    try {
                        mediaTracker.addImage(this.image, 0);
                        mediaTracker.waitForAll();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
            this.changes.firePropertyChange("imageURL", this.imageURL, uRL);
            this.repaint();
        }
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public void setStyle(int n) throws PropertyVetoException {
        if (n != this.imageStyle) {
            Integer n2 = new Integer(this.imageStyle);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("style", n2, n3);
            this.imageStyle = n;
            this.changes.firePropertyChange("style", n2, n3);
            this.repaint();
        }
    }

    public int getStyle() {
        return this.imageStyle;
    }

    public Image getImage() {
        return this.image;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.imageURL != null) {
            this.image = this.getToolkit().getImage(this.imageURL);
            if (this.image != null) {
                MediaTracker mediaTracker = new MediaTracker(this);
                try {
                    mediaTracker.addImage(this.image, 0);
                    mediaTracker.waitForAll();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }
}

