/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.awt;

import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import symantec.itools.db.awt.ProjectionBean;
import symantec.itools.db.awt.ProjectionBeanHelper;
import symantec.itools.db.awt.StreamImageSource;
import symantec.itools.db.beans.binding.Name;
import symantec.itools.db.pro.RelationView;

public class ImageViewer
extends Canvas
implements ProjectionBean {
    Object m_Value;
    boolean m_IsAdded = false;
    Image m_Image;
    int m_ImageType = 1;
    byte[] m_Data;
    ByteArrayInputStream m_InputStream;
    ByteArrayOutputStream m_OutputStream;
    private boolean m_displayWhileLoading = false;
    private boolean m_IsLoaded = false;
    private ProjectionBeanHelper m_Helper;
    private final String INVALID_IMAGE_DATA = "There is not a valid image data";

    public ImageViewer() {
        this.setIsAdded(false);
        this.m_Helper = new ProjectionBeanHelper(this);
    }

    public ImageViewer(URL uRL) {
        this();
        ImageViewer.setBaseUrl(uRL);
    }

    public static void setBaseUrl(URL uRL) {
        StreamImageSource.setBaseUrl(uRL);
    }

    public void addNotify() {
        super.addNotify();
        Container container = null;
        Applet applet = null;
        container = this.getParent();
        while (container != null && container.getParent() != null) {
            if (container instanceof Applet) break;
            container = container.getParent();
        }
        if (container instanceof Applet) {
            applet = (Applet)container;
            StreamImageSource.setBaseUrl(applet.getCodeBase());
        }
        this.setIsAdded(true);
        if (this.m_Value != null) {
            this.setData(this.m_Value);
        }
    }

    protected Image getImage() {
        return this.m_Image;
    }

    protected void setImage(Image image) {
        this.m_Image = image;
    }

    public int getImageType() {
        return this.m_ImageType;
    }

    public void setImageType(int n) {
        this.m_ImageType = n;
    }

    protected void setImageType(byte[] byArray) {
        byte[] byArray2 = new byte[3];
        System.arraycopy(byArray, 0, byArray2, 0, 3);
        String string = new String(byArray2, 0);
        int n = 1;
        if (string.equals("GIF")) {
            n = 0;
        }
        this.setImageType(n);
    }

    public boolean isLoaded() {
        return this.m_IsLoaded;
    }

    protected void setIsLoaded(boolean bl) {
        this.m_IsLoaded = bl;
    }

    public ByteArrayInputStream fetchImage(String string) throws MalformedURLException {
        URL uRL = new URL(string);
        return this.fetchImage(uRL);
    }

    public ByteArrayInputStream fetchHTTP(URL uRL) throws MalformedURLException {
        try {
            InputStream inputStream = uRL.openStream();
            this.buildImage(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new MalformedURLException(exception.getMessage());
        }
        this.enable(false);
        this.m_Helper.notifyInputChanged(this.m_Data);
        this.enable(true);
        return this.getInputStream();
    }

    public ByteArrayInputStream fetchImage(URL uRL) throws MalformedURLException {
        uRL.toExternalForm();
        return this.fetchHTTP(uRL);
    }

    public void setDisplayOption(boolean bl) {
        if (bl) {
            this.m_displayWhileLoading = true;
            return;
        }
        this.m_displayWhileLoading = false;
    }

    protected ByteArrayInputStream getInputStream() {
        return this.m_InputStream;
    }

    protected void setInputStream(ByteArrayInputStream byteArrayInputStream) {
        this.m_InputStream = byteArrayInputStream;
    }

    protected ByteArrayOutputStream getOutputStream() {
        return this.m_OutputStream;
    }

    protected ByteArrayOutputStream convertInputStreamToOutputStream(InputStream inputStream) throws MalformedURLException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n;
            while ((n = bufferedInputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
        }
        catch (Exception exception) {
            throw new MalformedURLException(exception.getMessage());
        }
        return byteArrayOutputStream;
    }

    public void clearImage() {
        this.setIsLoaded(false);
        this.setImage(null);
        this.repaint();
        this.m_Helper.notifyInputChanged(this.m_Data);
    }

    private void buildImage(InputStream inputStream) throws MalformedURLException {
        this.setIsLoaded(false);
        this.setImage(null);
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream;
                byte[] byArray;
                if (inputStream != null && (byArray = (byteArrayOutputStream = this.convertInputStreamToOutputStream(inputStream)).toByteArray()).length > 0) {
                    this.m_OutputStream = byteArrayOutputStream;
                    this.m_Data = byArray;
                    this.setInputStream(new ByteArrayInputStream(this.m_Data));
                    this.setImageType(this.m_Data);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.m_Data);
                    Toolkit toolkit = this.getToolkit();
                    new StreamImageSource(byteArrayInputStream, this.getImageType());
                    this.setImage(toolkit.createImage(byArray));
                    if (!this.m_displayWhileLoading) {
                        this.loadImage(this.getImage());
                    }
                    this.setIsLoaded(true);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new MalformedURLException(exception.getMessage());
            }
            Object var3_7 = null;
            this.repaint();
            return;
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.repaint();
            throw throwable;
        }
    }

    private void loadImage(Image image) {
        if (image != null) {
            try {
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(image, 0);
                mediaTracker.waitForID(0);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public void paint(Graphics graphics) {
        try {
            if (this.getImage() != null) {
                graphics.drawImage(this.getImage(), 0, 0, this);
                return;
            }
            graphics.clearRect(0, 0, this.size().width, this.size().height);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void setBinding(RelationView relationView, String string) {
        this.m_Helper.setBinding(relationView, string);
    }

    public String getProjection() {
        return this.m_Helper.getProjection();
    }

    public void setProjection(String string) {
        this.m_Helper.setProjection(string);
    }

    public RelationView getRelationView() {
        return this.m_Helper.getRelationView();
    }

    public void setRelationView(RelationView relationView) {
        this.m_Helper.setRelationView(relationView);
    }

    public void setTreatBlankAs(String string) {
        this.m_Helper.setTreatBlankAsString(string);
    }

    public boolean getDynamicUpdate() {
        return this.m_Helper.getDynamicUpdate();
    }

    public void setDynamicUpdate(boolean bl) {
        this.m_Helper.setDynamicUpdate(bl);
    }

    public void setReadOnly(boolean bl) {
    }

    public Object getData() {
        return this.m_OutputStream;
    }

    public void setData(Object object) {
        if (!this.isAdded()) {
            this.m_Value = object;
            return;
        }
        if (this.isEnabled()) {
            InputStream inputStream = null;
            if (object != null && object instanceof InputStream) {
                inputStream = (InputStream)object;
            }
            try {
                this.buildImage(inputStream);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }

    public boolean isTextBased() {
        return false;
    }

    public int getScale() {
        return 0;
    }

    public void registerListeners() {
    }

    public void setDataBinding(String string) {
        this.m_Helper.setDataBinding(new Name(string));
    }

    public String getDataBinding() {
        return this.m_Helper.getDataBinding().getFullName();
    }

    private synchronized boolean isAdded() {
        return this.m_IsAdded;
    }

    private synchronized void setIsAdded(boolean bl) {
        this.m_IsAdded = bl;
    }
}

