/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.binding;

import java.awt.Dimension;
import java.util.Vector;
import symantec.itools.db.beans.binding.DataItemAddition;
import symantec.itools.db.beans.binding.databus.DataItem;
import symantec.itools.db.beans.binding.databus.DataItemChangedEvent;
import symantec.itools.db.beans.binding.databus.DataItemChangedListener;
import symantec.itools.db.beans.binding.databus.ImmediateAccess;
import symantec.itools.db.beans.binding.databus.InvalidType;
import symantec.itools.db.beans.binding.databus.MutableImmediateAccess;
import symantec.itools.db.beans.util.LocalizedValueGenerator;

public class DataInput
implements DataItem,
MutableImmediateAccess,
DataItemAddition {
    private String Name;
    private Object Value;
    private Dimension Size;
    private Vector DIChangedListeners = new Vector();
    private int StatusFlag;

    public DataInput() {
    }

    public DataInput(String string, Dimension dimension) {
        this.setName(string);
    }

    public void setName(String string) {
        this.Name = string;
    }

    public String getName() {
        return this.Name;
    }

    public void setValue(ImmediateAccess immediateAccess) {
        Object object = immediateAccess.getValueAsObject();
        if (this.Value != null && object != null) {
            Object object2 = LocalizedValueGenerator.formatValue(object, true);
            Object object3 = LocalizedValueGenerator.formatValue(this.Value, true);
            if (!object.equals(this.Value) && !object2.toString().equals(object3.toString())) {
                this.Value = object;
                this.setStatusFlag(1);
                this.notifyDataChanged();
                return;
            }
        } else {
            if (object == null && this.Value != null && !this.Value.equals("")) {
                this.Value = object;
                this.setStatusFlag(1);
                this.notifyDataChanged();
                return;
            }
            if (object != null && !object.equals(this.Value)) {
                this.Value = object;
                this.setStatusFlag(1);
                this.notifyDataChanged();
            }
        }
    }

    public synchronized void addDataItemChangedListener(DataItemChangedListener dataItemChangedListener) {
        this.DIChangedListeners.addElement(dataItemChangedListener);
    }

    public synchronized void removeDataItemChangedListener(DataItemChangedListener dataItemChangedListener) {
        this.DIChangedListeners.removeElement(dataItemChangedListener);
    }

    public void notifyDataChanged() {
        try {
            Vector vector;
            DataItemChangedEvent dataItemChangedEvent = new DataItemChangedEvent(1, this);
            DataInput dataInput = this;
            synchronized (dataInput) {
                vector = (Vector)this.DIChangedListeners.clone();
            }
            int n = 0;
            while (n < vector.size()) {
                ((DataItemChangedListener)vector.elementAt(n)).notifyDataItemChanged(dataItemChangedEvent);
                ++n;
            }
            return;
        }
        catch (InvalidType invalidType) {
            System.out.println("invalidtype");
            return;
        }
    }

    public String getValueAsString() {
        return this.Value.toString();
    }

    public Object getValueAsObject() {
        if (this.Value == null) {
            return null;
        }
        return this.Value;
    }

    public String getPresentationString() {
        return "String";
    }

    public void setStatusFlag(int n) {
        this.StatusFlag = n;
    }

    public int getStatusFlag() {
        return this.StatusFlag;
    }

    public void cleanUp() {
        this.setStatusFlag(0);
    }
}

