/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.binding;

import java.awt.Dimension;
import java.beans.Beans;
import java.beans.PropertyVetoException;
import java.util.Vector;
import symantec.itools.db.beans.binding.BasicDataSource;
import symantec.itools.db.beans.binding.DataItemAddition;
import symantec.itools.db.beans.binding.Mediator;
import symantec.itools.db.beans.binding.MutableCollectionItem;
import symantec.itools.db.beans.binding.Name;
import symantec.itools.db.beans.binding.TriggerUIEvent;
import symantec.itools.db.beans.binding.TriggerUIListener;
import symantec.itools.db.beans.binding.databus.DataBus;
import symantec.itools.db.beans.binding.databus.DataBusEvent;
import symantec.itools.db.beans.binding.databus.DataItem;
import symantec.itools.db.beans.binding.databus.DataItemChangedEvent;
import symantec.itools.db.beans.binding.databus.InvalidType;

public class MediatorDS
extends Mediator
implements TriggerUIListener {
    protected Name dataBinding;
    private Vector DataInputVector = new Vector();
    private Vector DataInputCols = new Vector();
    protected BasicDataSource output;
    protected String[] setMethods = new String[]{"setValueTrust(Value,Row,Col)"};
    protected String[] getMethods = new String[]{"getValue(Row,Col)"};
    protected boolean notifyOnDS = true;
    int currentRow;
    int eventType;

    public MediatorDS() {
        this.DataInputVector = new Vector();
        this.DataInputCols = new Vector();
        this.notifyOnDS = true;
    }

    public MediatorDS(Object object, String string) {
        super(object, string);
    }

    public void setDataBus(DataBus dataBus) throws PropertyVetoException {
        this.DBus = dataBus;
        this.DBus.addDataBusEventListener(this);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        this.output = (BasicDataSource)object;
        try {
            this.Component.InputClass = Class.forName("java.lang.Object");
        }
        catch (Exception exception) {}
        super.setEmptyMeansNull(false);
        ((BasicDataSource)object).addTriggerUIListener(this);
    }

    public void handleDataBusEvent(DataBusEvent dataBusEvent) {
    }

    public void commit() {
        if (this.hasFoundSetMethod && this.hasFoundGetMethod) {
            this.notifyEnabled(false);
            int n = this.output.getCurrentRowNumber();
            int n2 = 0;
            while (n2 < this.DataInputVector.size()) {
                DataItem dataItem = (DataItem)this.DataInputVector.elementAt(n2);
                this.commit(dataItem, n, (int[])this.DataInputCols.elementAt(n2));
                ++n2;
            }
            int n3 = 0;
            while (n3 < this.DataInputVector.size()) {
                ((DataItemAddition)this.DataInputVector.elementAt(n3)).cleanUp();
                ++n3;
            }
            this.currentRow = n;
            this.notifyEnabled(true);
        }
    }

    public void commit(DataItem dataItem, int n, int[] nArray) {
        String string = this.getDataItemName(dataItem);
        if (Name.getNumberOfRows(string) != -1) {
            this.Component.setOutputSize(this.getCollectionSize(dataItem));
            this.createDataItemFromArray(dataItem, (Object[][])this.Component.getPrintOut(nArray));
            return;
        }
        if (this.eventType != 1 && this.output.getTotalNumberOfRows() != 0) {
            this.Component.setOutputSize(new Dimension(this.getCollectionSize((DataItem)dataItem).width, this.output.getTotalNumberOfRows()));
            this.createDataItemFromArray(dataItem, (Object[][])this.Component.getPrintOut(nArray, n));
        }
    }

    public void notifyDataItemChanged(DataItemChangedEvent dataItemChangedEvent) {
        if (dataItemChangedEvent.getChangeType() == 1 && (this.notifyOnDS || Mediator.notifyOnStatic)) {
            this.update((DataItem)dataItemChangedEvent.getSource());
        }
        dataItemChangedEvent.getChangeType();
        if (dataItemChangedEvent.getChangeType() == 0) {
            boolean bl = this.notifyOnDS || Mediator.notifyOnStatic;
        }
    }

    protected void update(DataItem dataItem) {
        if (this.hasFoundSetMethod && this.hasFoundGetMethod) {
            String string = this.getDataItemName(dataItem);
            this.offset = Name.getNumberOfRows(string) == -1 ? this.output.getCurrentRowNumber() : 0;
            this.setOutputSize(this.getCollectionSize(dataItem));
            int[] nArray = this.dataBinding.getColumnsFromName(string);
            this.currentCursorNumber = 0;
            this.update(dataItem, nArray, 0, 0);
            ((DataItemAddition)((Object)dataItem)).cleanUp();
            return;
        }
    }

    public void requestDataItem(DataBusEvent dataBusEvent) {
        String string = dataBusEvent.getDataItemName();
        if (dataBusEvent.getEventType() == 2 && this.dataBinding.isMyField(string)) {
            Object object;
            int n = Name.getNumberOfRows(string);
            int[] nArray = this.dataBinding.getColumnsFromName(string);
            int n2 = 0;
            while (n2 < this.DataInputVector.size()) {
                String string2 = this.getDataItemName((DataItem)this.DataInputVector.elementAt(n2));
                object = this.dataBinding.getColumnsFromName(string2);
                if (((Object)object).length == nArray.length && n == Name.getNumberOfRows(string2)) {
                    boolean bl = true;
                    int n3 = 0;
                    while (n3 < ((Object)object).length) {
                        if (object[n3] != nArray[n3]) {
                            bl = false;
                            break;
                        }
                        ++n3;
                    }
                    if (bl) {
                        dataBusEvent.setDataItem((DataItem)this.DataInputVector.elementAt(n2));
                    }
                }
                ++n2;
            }
            boolean bl = false;
            if (n == -1) {
                n = ((BasicDataSource)this.Component.getOutput()).getTotalNumberOfRows();
                if (n == 0) {
                    n = 1;
                }
                bl = true;
            }
            object = new Dimension(Name.getNumberOfCols(string), n);
            if (dataBusEvent.getDataItem() == null) {
                this.notifyEnabled(false);
                if (Name.getFieldName(string).equals("All")) {
                    String string3 = ",RowNumber,RowState,NumberOfRows,CurrentDataSource";
                    String string4 = this.dataBinding.getFullName();
                    String string5 = !bl ? String.valueOf(string4.substring(0, string4.lastIndexOf(string3))) + string4.substring(string4.lastIndexOf(37), string4.length()) : String.valueOf(string4.substring(0, string4.lastIndexOf(string3))) + "%" + -1;
                    string = string5;
                }
                this.Component.setOutputSize((Dimension)object);
                int[] nArray2 = this.dataBinding.getColumnsFromName(Name.getFieldName(string));
                DataItem dataItem = !bl ? this.createDataItemFromArray(null, (Object[][])this.Component.getPrintOut(nArray2)) : this.createDataItemFromArray(new MutableCollectionItem(), (Object[][])this.Component.getPrintOut(nArray2, ((BasicDataSource)this.Component.getOutput()).getCurrentRowNumber()));
                this.setDataItemName(dataItem, string);
                dataItem.addDataItemChangedListener(this);
                this.DataInputVector.addElement(dataItem);
                this.DataInputCols.addElement(this.dataBinding.getColumnsFromName(string));
                dataBusEvent.setDataItem(dataItem);
                ((DataItemAddition)((Object)dataItem)).cleanUp();
                this.notifyEnabled(true);
            }
        }
    }

    public void setDataBinding(String string) {
        if (this.Component != null) {
            this.dataBinding = new Name(string);
            if (this.DBus == null) {
                DataBus.joinDataBus(this);
            }
            try {
                int n = 0;
                while (n < this.DataInputVector.size()) {
                    this.DBus.announceDataItem(new DataBusEvent(1, this.getDataItemName((DataItem)this.DataInputVector.elementAt(n)), this));
                    ((DataItem)this.DataInputVector.elementAt(n)).removeDataItemChangedListener(this);
                    ++n;
                }
                this.DataInputVector.removeAllElements();
                this.DataInputCols.removeAllElements();
                this.DBus.announceDataItem(new DataBusEvent(0, this.dataBinding.getFullName(), this));
                this.commit();
                return;
            }
            catch (InvalidType invalidType) {
                return;
            }
        }
    }

    public String getDataBinding() {
        if (this.dataBinding == null) {
            return "";
        }
        return this.dataBinding.getFullName();
    }

    protected void notifyEnabled(boolean bl) {
        this.notifyOnDS = bl;
    }

    public void commitUI(TriggerUIEvent triggerUIEvent) {
        if (triggerUIEvent.m_Type == 7) {
            Mediator.notifyOnStatic = true;
            Mediator.notifySizeOnStatic = true;
            this.commit();
            Mediator.notifyOnStatic = false;
            return;
        }
        if (triggerUIEvent.m_Type == 2) {
            this.eventType = 1;
            this.commit();
            this.eventType = 0;
            return;
        }
        this.commit();
    }

    protected void findDI() {
        if (Beans.isDesignTime()) {
            return;
        }
        this.killActualInput();
        DataItem dataItem = this.DBus.findDataItem(this.dataBinding.getFullName(), this);
        if (dataItem != null && dataItem instanceof DataItem) {
            this.Input = dataItem;
            this.Input.addDataItemChangedListener(this);
        }
    }

    protected String getDataItemName(DataItem dataItem) {
        if (dataItem instanceof DataItemAddition) {
            return ((DataItemAddition)((Object)dataItem)).getName();
        }
        return null;
    }

    protected void setDataItemName(DataItem dataItem, String string) {
        if (dataItem instanceof DataItemAddition) {
            ((DataItemAddition)((Object)dataItem)).setName(string);
        }
    }

    public void killAll() {
        try {
            this.DBus.announceDataItem(new DataBusEvent(1, this.dataBinding.getTableName(), this));
        }
        catch (Exception exception) {
            System.out.println("could'nt do kill all");
        }
        this.DataInputVector.removeAllElements();
        this.suicide();
    }

    public void killAll(String string) {
        try {
            if (this.DBus == null) {
                DataBus.joinDataBus(this);
            }
            this.DBus.announceDataItem(new DataBusEvent(1, string, this));
            int n = 0;
            while (n < this.DataInputVector.size()) {
                this.DBus.announceDataItem(new DataBusEvent(1, this.getDataItemName((DataItem)this.DataInputVector.elementAt(n)), this));
                ((DataItem)this.DataInputVector.elementAt(n)).removeDataItemChangedListener(this);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.println("Could not do kill all");
        }
        this.DataInputVector.removeAllElements();
        this.suicide();
    }
}

