/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.binding;

import java.applet.Applet;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import symantec.itools.db.beans.binding.ApplicationTask;
import symantec.itools.db.beans.binding.BasicDataSource;
import symantec.itools.db.beans.binding.BindingResourceLoader;
import symantec.itools.db.beans.binding.ChainTasks;
import symantec.itools.db.beans.binding.Connection;
import symantec.itools.db.beans.binding.Cursor;
import symantec.itools.db.beans.binding.ExceptionEvent;
import symantec.itools.db.beans.binding.ExceptionEventListener;
import symantec.itools.db.beans.binding.ExpandableSet;
import symantec.itools.db.beans.binding.IllegalRelationshipException;
import symantec.itools.db.beans.binding.MediatorDS;
import symantec.itools.db.beans.binding.Name;
import symantec.itools.db.beans.binding.ParentInvalidRecordException;
import symantec.itools.db.beans.binding.PersistentObject;
import symantec.itools.db.beans.binding.PersistentObjectMemberModel;
import symantec.itools.db.beans.binding.PersistentObjectModel;
import symantec.itools.db.beans.binding.PositionOutOfRangeException;
import symantec.itools.db.beans.binding.QuerySynchronizer;
import symantec.itools.db.beans.binding.RelationshipPendingException;
import symantec.itools.db.beans.binding.SaveTransactionChanges;
import symantec.itools.db.beans.binding.Synchronizable;
import symantec.itools.db.beans.binding.SynchronizerLink;
import symantec.itools.db.beans.binding.TriggerUIEvent;
import symantec.itools.db.beans.binding.TriggerUIListener;
import symantec.itools.db.beans.binding.event.ColumnDataEvent;
import symantec.itools.db.beans.binding.event.ColumnDataEventListener;
import symantec.itools.db.beans.binding.event.RecordNavigateEvent;
import symantec.itools.db.beans.binding.event.RecordNavigateEventListener;
import symantec.itools.db.beans.binding.event.RecordSaveEvent;
import symantec.itools.db.beans.binding.event.RecordSaveEventExceptionListener;
import symantec.itools.db.beans.binding.event.RecordSaveEventListener;
import symantec.itools.db.beans.binding.event.RecordSaveException;
import symantec.itools.db.beans.binding.taskbus.TaskBus;
import symantec.itools.db.beans.binding.taskbus.TaskBusEvent;
import symantec.itools.db.beans.binding.taskbus.TaskBusEventListener;
import symantec.itools.db.beans.binding.taskbus.TaskBusMember;
import symantec.itools.db.beans.jdbc.RecordDefinition;
import symantec.itools.db.beans.jdbc.SQLRecordDefinition;
import symantec.itools.db.beans.qbe.QBExlator;
import symantec.itools.db.beans.util.LocalizedValueGenerator;

public class QueryNavigator
implements Synchronizable,
ExpandableSet,
BasicDataSource,
ExceptionEventListener,
PropertyChangeListener,
RecordSaveEventExceptionListener {
    private static BindingResourceLoader resourceLoader = BindingResourceLoader.getInstance();
    private static ResourceBundle MyResource = resourceLoader.getBundle();
    public static String markedAsNewString = MyResource.getString("QueryNavigator_MarkAsNew");
    public static String markedAsDeletedString = MyResource.getString("QueryNavigator_MarkAsDeleted");
    public static String markedAsModifiedString = MyResource.getString("QueryNavigator_MarkAsModified");
    public static String markedAsExistingString = MyResource.getString("QueryNavigator_MarkAsExisting");
    public static String markedAsQBEString = MyResource.getString("QueryNavigator_MarkAsQBE");
    public static String LAST_ROW;
    public static String OVERRIDE_MESSAGE;
    private static String WARNING_MESSAGE_ALIAS_NAME;
    private static String WARNING_MESSAGE_MASTER_ALIAS_NAME;
    protected Cursor m_QBECursor;
    protected Cursor m_CurrentCursor;
    private Cursor m_VariableCursor;
    private Cursor m_NavigationCursor;
    protected QBExlator m_Xlator = new QBExlator();
    protected Vector m_ObjectVector;
    protected Vector m_UpdatedRecordsVector = new Vector();
    protected Vector m_DeletedRecordsVector = new Vector();
    protected Enumeration m_ObjectEnumeration;
    protected String m_POClassName = "";
    protected String fullname = "";
    private String m_AliasName;
    protected Class m_POFactory;
    private Vector listenersExceptions = new Vector();
    private Vector listenersRecordNavigate = new Vector();
    private Vector listenersColumnData = new Vector();
    private Vector listenersRecordSave = new Vector();
    private Vector listenersRecordSaveException = new Vector();
    private String m_DirtySaveMessage;
    private String m_SaveChangesWindowClass = "symantec.itools.db.beans.binding.SaveChangesWindow";
    public static final int BASE_FOR_ROW_NUMBER = 1;
    public static final int QBE_ROW_NUMBER = -1;
    public static final int SLEEP_TIME = 1000;
    public final boolean CHECK_QBE_VALUES = false;
    public static final String RowNumber = "RowNumber";
    public static final String RowState = "RowState";
    public static final String NumberOfRows = "NumberOfRows";
    public static final String CurrentDataSource = "CurrentDataSource";
    public static final String QBE_STRING = "QBE.";
    private static final String SAVE_DEFAULT_AWT_WINDOW = "symantec.itools.db.beans.binding.SaveChangesWindow";
    private static final String SAVE_DEFAULT_JFC_WINDOW = "symantec.itools.db.beans.binding.JSaveChangesWindow";
    private static final String SAVE_DEFAULT_JFC11_WINDOW = "symantec.itools.db.beans.javax.swing.JSaveChangesWindow";
    public static final String PROP_EXECUTE = "execute";
    public static final String[] SpecialFeatures;
    public static final String ROWNUMBER_SPECIALFEATURE = "RowNumber";
    public static final String ROWSTATE_SPECIALFEATURE = "RowState";
    public static final String NUMOFROWS_SPECIALFEATURE = "NumberOfRows";
    public static final String[] AVAILABLE_SPECIAL_FEATURES;
    public final int numberOfSpecialFeatures = SpecialFeatures.length;
    private boolean autoStart = false;
    protected boolean m_Live = false;
    private MediatorDS mediatords;
    private Vector triggerListeners = new Vector();
    protected boolean newSet = false;
    private boolean isStarted = false;
    private String name;
    private String m_MasterAliasName;
    private SynchronizerLink m_SynchronizerLink;
    private static Hashtable m_AliasesName;
    private boolean dataChanged = false;
    protected TaskAction taskAction;
    protected Applet applet;
    protected int dbEngineType = 0;
    int rowsSaved;
    private PropertyChangeSupport closes = new PropertyChangeSupport(this);
    private static boolean showSaveWindow;

    static {
        OVERRIDE_MESSAGE = MyResource.getString("QueryNavigator_WarnOverride");
        WARNING_MESSAGE_ALIAS_NAME = MyResource.getString("QueryNavigator_WarnAlias");
        WARNING_MESSAGE_MASTER_ALIAS_NAME = MyResource.getString("QueryNavigator_WarnMaster");
        LAST_ROW = MyResource.getString("QueryNavigator_GotoLast");
        SpecialFeatures = new String[]{"RowNumber", "RowState", "NumberOfRows", CurrentDataSource};
        AVAILABLE_SPECIAL_FEATURES = new String[]{"RowNumber", "RowState", "NumberOfRows"};
        m_AliasesName = new Hashtable();
        showSaveWindow = true;
    }

    public QueryNavigator() {
        if (Beans.isDesignTime()) {
            return;
        }
        this.m_QBECursor = new Cursor("QBE", this);
        this.m_VariableCursor = new Cursor("variable", this);
        this.m_CurrentCursor = this.m_NavigationCursor = new Cursor("navigation", this);
        this.mediatords = new MediatorDS();
        this.mediatords.setOutput(this);
        String[] stringArray = new String[]{"getValue(Row,Col)"};
        String[] stringArray2 = new String[]{"setValue(Value,Row,Col)"};
        this.mediatords.setSetMethods(stringArray2);
        this.mediatords.setGetMethods(stringArray);
        this.addExceptionEventListener(this);
        this.addRecordSaveEventExceptionListener(this);
        this.taskAction = new TaskAction();
    }

    public void setApplet(Applet applet) {
        this.applet = applet;
    }

    public static void addExceptionListener(ExceptionEventListener exceptionEventListener, String string) {
        if (m_AliasesName.containsKey(string)) {
            ((QueryNavigator)m_AliasesName.get(string)).addExceptionEventListener(exceptionEventListener);
        }
    }

    public static void removeExceptionListener(ExceptionEventListener exceptionEventListener, String string) {
        if (m_AliasesName.containsKey(string)) {
            ((QueryNavigator)m_AliasesName.get(string)).removeExceptionEventListener(exceptionEventListener);
        }
    }

    public synchronized void setAliasName(String string) {
        if (Beans.isDesignTime()) {
            this.m_AliasName = string;
            return;
        }
        if (this.m_AliasName != null && string != null) {
            if (this.m_AliasName.equals(string)) {
                this.registerAlias(string);
                return;
            }
            this.announceException(new ExceptionEvent(1, WARNING_MESSAGE_ALIAS_NAME, this, null));
            return;
        }
        if (this.m_AliasName == null && string != null) {
            this.registerAlias(string);
            return;
        }
        if (this.m_AliasName != null && string == null) {
            m_AliasesName.remove(this.m_AliasName);
        }
    }

    public boolean gxecute() {
        return this.autoStart;
    }

    public boolean getExecute() {
        return this.m_Live;
    }

    public void execute(boolean bl) {
        if (this.m_Live == bl) {
            return;
        }
        this.m_Live = bl;
        if (Beans.isDesignTime()) {
            return;
        }
        if (this.m_Live) {
            this.startEngine(this.m_AliasName);
        }
    }

    private void registerAlias(String string) {
        if (m_AliasesName.containsKey(string)) {
            ((QueryNavigator)m_AliasesName.get(string)).close();
            m_AliasesName.remove(string);
        }
        this.m_AliasName = string;
        m_AliasesName.put(string, this);
        try {
            QuerySynchronizer.addSynchronizable(this);
            return;
        }
        catch (IllegalRelationshipException illegalRelationshipException) {
            this.announceException(new ExceptionEvent(1, illegalRelationshipException.getMessage(), this, null));
            return;
        }
    }

    private void startEngine(String string) {
        if (Beans.isDesignTime()) {
            return;
        }
        this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applLoad, ApplicationTask.connectingDB, this, ""));
        this.startQueryByExample();
        if (this.m_DirtySaveMessage == null) {
            this.m_DirtySaveMessage = String.valueOf(MyResource.getString("QueryNavigator_DirtySave")) + this.getTableName();
        }
        if (this.m_Live) {
            this.restart();
        }
        this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applLoad, null, this, ""));
    }

    public String getMasterAliasName() {
        return this.m_MasterAliasName;
    }

    public synchronized void setMasterName(String string) {
        this.setMasterAliasName(string);
    }

    public synchronized void setMasterAliasName(String string) {
        if (Beans.isDesignTime()) {
            this.m_MasterAliasName = string;
            return;
        }
        if (this.m_MasterAliasName != null && string != null) {
            this.announceException(new ExceptionEvent(1, WARNING_MESSAGE_MASTER_ALIAS_NAME, this, null));
            return;
        }
        if (this.m_MasterAliasName == null && string != null) {
            this.m_MasterAliasName = string;
            return;
        }
        boolean bl = this.m_MasterAliasName != null && string == null;
    }

    public synchronized void setLink(SynchronizerLink synchronizerLink) {
        this.m_SynchronizerLink = synchronizerLink;
        this.m_SynchronizerLink.addPropertyChangeListener(this);
    }

    public SynchronizerLink getLink() {
        return this.m_SynchronizerLink;
    }

    public int saveAll(int n) throws SQLException {
        int n2 = 0;
        try {
            if (n == 1) {
                this.announceOnBeforeRecordSave(new RecordSaveEvent(this, 1, this.getDirtyRowsNumber(), -1, null));
                this.rowsSaved = 0;
            }
            switch (n) {
                case 2: {
                    n2 = this.saveAllIntern(2);
                    break;
                }
                case 1: {
                    n2 = this.saveDelete();
                    break;
                }
                case 5: {
                    n2 = this.saveIntern();
                    break;
                }
                case 4: {
                    this.m_ObjectVector = null;
                    this.m_ObjectEnumeration = null;
                    this.dataChanged = false;
                    this.announceRecordNavigateOnBeforeNavigate(new RecordNavigateEvent(this, 5));
                    this.startQueryByExample();
                    this.announceRecordNavigateOnAfterNavigate(new RecordNavigateEvent(this, 5));
                    System.gc();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(MyResource.getString("QueryNavigator_SaveAll1"));
                }
            }
            if (n == 2) {
                this.announceOnAfterRecordSave(new RecordSaveEvent(this, 1, this.rowsSaved, -1, null));
            }
        }
        catch (RelationshipPendingException relationshipPendingException) {
            this.treatPendingException(relationshipPendingException);
        }
        return n2;
    }

    public boolean isDirty() {
        boolean bl = false;
        if (this.m_ObjectVector == null || !this.dataChanged) {
            return false;
        }
        Enumeration enumeration = this.m_ObjectVector.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            PersistentObject persistentObject = (PersistentObject)enumeration.nextElement();
            bl = persistentObject.isDirty();
            if (bl) break;
            ++n;
        }
        return bl;
    }

    public boolean isEmpty() {
        boolean bl = false;
        bl = this.getCurrentObject() == this.m_QBECursor.getFocusObject() || this.getCurrentObject() == null;
        return bl;
    }

    public Connection getConnection() {
        return this.getQBEObject().getConnection();
    }

    public synchronized void navigate(int n, Integer n2) {
        try {
            switch (n) {
                case 6: {
                    this.startQueryByExample();
                    return;
                }
                case 3: {
                    this.firstIntern();
                    return;
                }
                case 2: {
                    this.previousIntern(true);
                    return;
                }
                case 1: {
                    this.nextIntern(true);
                    return;
                }
                case 5: {
                    this.goToIntern(n2);
                    return;
                }
                case 4: {
                    this.restartIntern();
                    return;
                }
                case 7: {
                    this.insertIntern();
                    return;
                }
            }
            throw new IllegalArgumentException(MyResource.getString("QueryNavigator_Navigate1"));
        }
        catch (Exception exception) {
            return;
        }
    }

    public void executeQuery(Synchronizable synchronizable) {
    }

    protected String getRowState(PersistentObject persistentObject) {
        if (persistentObject != null) {
            if (persistentObject.getMarkedAsDeleted()) {
                return markedAsDeletedString;
            }
            if (persistentObject.getMarkedAsNew()) {
                return markedAsNewString;
            }
            if (persistentObject.getMarkedAsModified()) {
                return markedAsModifiedString;
            }
            if (persistentObject.getMarkedAsQBE()) {
                return markedAsQBEString;
            }
            return markedAsExistingString;
        }
        return MyResource.getString("QueryNavigator_NoRows");
    }

    public String getRowState() throws PositionOutOfRangeException {
        this.m_VariableCursor.setPosition(this.m_CurrentCursor.getPosition());
        PersistentObject persistentObject = (PersistentObject)this.m_VariableCursor.getFocusObject();
        return this.getRowState(persistentObject);
    }

    public int getCurrentRowNumber() {
        if (this.isQBERow()) {
            return 0;
        }
        return this.m_CurrentCursor.getPosition();
    }

    protected Object getSpecialFeature(int n, int n2) {
        if (SpecialFeatures[n] == "NumberOfRows") {
            return new Integer(this.getTotalNumberOfRows());
        }
        if (SpecialFeatures[n] == CurrentDataSource) {
            return this;
        }
        int n3 = this.getCurrentRowNumber();
        if (this.m_CurrentCursor != this.m_QBECursor) {
            if (SpecialFeatures[n] == "RowNumber") {
                return new Integer(n3 + 1 + n2);
            }
            if (SpecialFeatures[n] == "RowState") {
                try {
                    this.m_VariableCursor.setPosition(this.m_CurrentCursor.getPosition() + n2);
                    PersistentObject persistentObject = (PersistentObject)this.m_VariableCursor.getFocusObject();
                    return this.getRowState(persistentObject);
                }
                catch (Exception exception) {
                    return "";
                }
            }
        } else {
            return new Integer(0);
        }
        return "";
    }

    protected void setSpecialFeature(int n, int n2, Object object) throws PositionOutOfRangeException {
        this.getCurrentRowNumber();
        if (this.m_CurrentCursor != this.m_QBECursor && SpecialFeatures[n] == "RowNumber") {
            try {
                Number number = LocalizedValueGenerator.parseNumberValue(object.toString(), 4);
                if (number != null) {
                    this.go_to(number.intValue());
                    return;
                }
            }
            catch (ParseException parseException) {
                System.out.println(parseException.getMessage());
                throw new PositionOutOfRangeException();
            }
        }
    }

    public Object getValue(int n, int n2) {
        PersistentObject persistentObject = null;
        Name name = new Name(this.mediatords.getDataBinding());
        int n3 = n2 - name.getNumberOfCols() + SpecialFeatures.length;
        try {
            if (n3 >= 0 && SpecialFeatures[n3].equals(CurrentDataSource)) {
                return this;
            }
            if (this.m_CurrentCursor.getPosition() == -1 && n > 0) {
                return null;
            }
            int n4 = this.m_NavigationCursor.getPosition() + n;
            if (this.m_CurrentCursor == this.m_QBECursor) {
                persistentObject = (PersistentObject)this.m_CurrentCursor.getFocusObject();
            } else if (n4 >= 0) {
                this.m_VariableCursor.setPosition(n4);
                persistentObject = (PersistentObject)this.m_VariableCursor.getFocusObject();
            }
        }
        catch (PositionOutOfRangeException positionOutOfRangeException) {}
        if (persistentObject != null) {
            if (n3 < 0) {
                Object object = persistentObject.getValueAsObject(n2, 1);
                return object;
            }
            return this.getSpecialFeature(n3, n);
        }
        return null;
    }

    public void setValueAsQBE(Object object, int n) {
        Cursor cursor = this.m_CurrentCursor;
        try {
            this.m_CurrentCursor = this.m_QBECursor;
            this.setValue(object, 0, n);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.m_CurrentCursor = cursor;
            throw throwable;
        }
        Object var5_4 = null;
        this.m_CurrentCursor = cursor;
    }

    public final synchronized void setValue(Object object, int n, int n2) {
        block11: {
            String string = new String();
            this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applUpdate, ApplicationTask.updateTask, this, ""));
            try {
                PersistentObject persistentObject;
                if (n != 0) {
                    this.m_VariableCursor.setPosition(this.m_NavigationCursor.getPosition() + n);
                    persistentObject = (PersistentObject)this.m_VariableCursor.getFocusObject();
                } else {
                    persistentObject = (PersistentObject)this.m_CurrentCursor.getFocusObject();
                }
                if (persistentObject != null) {
                    Name name = new Name(this.mediatords.getDataBinding());
                    if (n2 < name.getNumberOfCols() - SpecialFeatures.length) {
                        PersistentObjectModel persistentObjectModel = persistentObject.getDataModel();
                        PersistentObjectMemberModel persistentObjectMemberModel = persistentObjectModel.getMemberModel(n2);
                        string = persistentObjectMemberModel.getName();
                        Object object2 = persistentObject.getValueAsObject(n2, 1);
                        if (this.isQBERow()) {
                            this.announceOnBeforeColumnDataChange(new ColumnDataEvent(this, -1, n2, object2, object, 0));
                            persistentObject.setValueAsQBE(n2, object, false);
                            this.announceOnAfterColumnDataChange(new ColumnDataEvent(this, -1, n2, object2, persistentObject.getValueAsObject(n2, 1), 0));
                        } else {
                            this.announceOnBeforeColumnDataChange(new ColumnDataEvent(this, this.getCurrentRowNumber(), n2, object2, object, 0));
                            persistentObject.setValueAsObject(n2, object);
                            this.setDisplaced(n2, persistentObject.getValueAsObject(n2, 1), persistentObject);
                            this.dataChanged = true;
                            this.announceOnAfterColumnDataChange(new ColumnDataEvent(this, this.getCurrentRowNumber(), n2, object2, persistentObject.getValueAsObject(n2, 1), 0));
                        }
                        this.moveDataToUI(this.getCurrentRowNumber(), 6);
                        this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applUpdate, null, this, String.valueOf(MyResource.getString("QueryNavigator_SetValue3")) + string + MyResource.getString("QueryNavigator_SetValue2") + object));
                        return;
                    }
                    this.setSpecialFeature(n2 - name.getNumberOfCols() + SpecialFeatures.length, n, object);
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.moveDataToUI(this.getCurrentRowNumber(), 7);
                this.announceException(new ExceptionEvent(2, String.valueOf(numberFormatException.getMessage()) + MyResource.getString("QueryNavigator_SetValue1") + string, this, numberFormatException));
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.announceException(new ExceptionEvent(1, arrayIndexOutOfBoundsException.getMessage(), this, arrayIndexOutOfBoundsException));
                return;
            }
            catch (PositionOutOfRangeException positionOutOfRangeException) {
                this.announceException(new ExceptionEvent(1, positionOutOfRangeException.getMessage(), this, positionOutOfRangeException));
                return;
            }
            catch (Exception exception) {
                if (!(exception instanceof PersistentObject.RecordException)) break block11;
                this.announceException(new ExceptionEvent(1, exception.getMessage(), this, exception));
            }
        }
    }

    public Hashtable findRecord(String string, Object object) {
        return this.findRecord(this.getQBEObject().getColumnIndex(string), object);
    }

    public Hashtable findRecord(int n, Object object) {
        Hashtable hashtable = null;
        if (n < 0) {
            return hashtable;
        }
        try {
            int n2 = 0;
            try {
                while (true) {
                    PersistentObject persistentObject;
                    if ((persistentObject = (PersistentObject)this.getElementAt(n2)).getValueAsString(n, 0).equals(object.toString())) {
                        hashtable = persistentObject.toHashtable();
                        break;
                    }
                    ++n2;
                }
            }
            catch (PositionOutOfRangeException positionOutOfRangeException) {
            }
        }
        catch (Exception exception) {}
        return hashtable;
    }

    protected void setDisplaced(int n, Object object, PersistentObject persistentObject) {
    }

    public Object getValueFromFirst(int n, int n2) {
        try {
            this.m_VariableCursor.setPosition(n);
            PersistentObject persistentObject = (PersistentObject)this.m_VariableCursor.getFocusObject();
            if (persistentObject != null) {
                return persistentObject.getValueAsObject(n2, 1);
            }
        }
        catch (PositionOutOfRangeException positionOutOfRangeException) {}
        return "";
    }

    public void setValueFromFirst(Object object, int n, int n2) {
        try {
            this.m_VariableCursor.setPosition(n);
            PersistentObject persistentObject = (PersistentObject)this.m_VariableCursor.getFocusObject();
            if (persistentObject != null) {
                this.announceOnBeforeColumnDataChange(new ColumnDataEvent(this, this.getCurrentRowNumber(), n2, persistentObject.getValueAsObject(n2, 1), object, 0));
                persistentObject.setValueAsObject(n2, object);
                this.setDisplaced(n2, persistentObject.getValueAsObject(n2, 1), persistentObject);
                this.dataChanged = true;
                if (persistentObject.getMarkedAsModified()) {
                    this.announceOnAfterColumnDataChange(new ColumnDataEvent(this, this.getCurrentRowNumber(), n2, persistentObject.getValueAsObject(n2, 1), object, 0));
                } else {
                    this.announceOnAfterColumnDataChange(new ColumnDataEvent(this, this.getCurrentRowNumber(), n2, persistentObject.getValueAsObject(n2, 1), object, 1));
                }
                this.moveDataToUI(this.getCurrentRowNumber(), 6);
                return;
            }
        }
        catch (PositionOutOfRangeException positionOutOfRangeException) {
            this.announceException(new ExceptionEvent(1, positionOutOfRangeException.getMessage(), this, positionOutOfRangeException));
        }
    }

    public Object getElementAt(int n) throws PositionOutOfRangeException {
        if (n >= 0) {
            while (!this.poSetIsLargeEnough(n) && this.isExpandable()) {
                this.expandPOSet();
            }
            if (this.poSetIsLargeEnough(n)) {
                return (PersistentObject)this.m_ObjectVector.elementAt(n);
            }
        }
        throw new PositionOutOfRangeException();
    }

    public boolean EOF() {
        boolean bl = false;
        int n = this.getCurrentRowNumber() + 1;
        int n2 = 0;
        if (this.m_ObjectVector != null) {
            n2 = this.m_ObjectVector.size();
        }
        if (!this.newSet && n == n2) {
            bl = true;
        }
        return bl;
    }

    public boolean BOF() {
        boolean bl = false;
        if (this.getCurrentRowNumber() == 0) {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean isExpandable() {
        return this.m_ObjectEnumeration != null && this.m_ObjectEnumeration.hasMoreElements();
    }

    boolean poSetIsLargeEnough(int n) {
        return this.m_ObjectVector != null && this.m_ObjectVector.size() > n;
    }

    protected boolean expandPOSet() {
        boolean bl = false;
        if (this.m_ObjectEnumeration != null && (bl = this.m_ObjectEnumeration.hasMoreElements())) {
            if (this.m_ObjectVector == null) {
                this.m_ObjectVector = new Vector();
            }
            this.m_ObjectVector.addElement(this.m_ObjectEnumeration.nextElement());
        }
        return bl;
    }

    public final void next() throws PositionOutOfRangeException {
        this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applNext, ApplicationTask.nextTask, this, ""));
        try {
            if (this.m_SynchronizerLink != null) {
                this.m_SynchronizerLink.navigate(1, null);
            }
            this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applNext, null, this, String.valueOf(MyResource.getString("QueryNavigator_GotoRow")) + (this.m_NavigationCursor.getPosition() + 1)));
            return;
        }
        catch (ParentInvalidRecordException parentInvalidRecordException) {
            this.announceException(new ExceptionEvent(7, parentInvalidRecordException.getMessage(), this, parentInvalidRecordException));
            return;
        }
        catch (RelationshipPendingException relationshipPendingException) {
            this.treatPendingException(relationshipPendingException);
            return;
        }
    }

    private void treatPendingException(RelationshipPendingException relationshipPendingException) {
        if (!relationshipPendingException.getMessage().equals("Easy way out")) {
            this.announceException(new ExceptionEvent(8, relationshipPendingException.getMessage(), this, relationshipPendingException));
        }
    }

    private final void nextIntern(boolean bl) throws PositionOutOfRangeException {
        int n;
        PersistentObject persistentObject;
        PersistentObject persistentObject2;
        block4: {
            if (this.EOF()) {
                return;
            }
            persistentObject2 = null;
            persistentObject = null;
            int n2 = this.m_NavigationCursor.getPosition();
            n = n2 + 1;
            try {
                persistentObject2 = (PersistentObject)this.m_NavigationCursor.getFocusObject();
                this.announceRecordNavigateOnBeforeNavigate(new RecordNavigateEvent(this, 2, n, persistentObject2, null));
                this.getElementAt(n);
                this.m_NavigationCursor.setPosition(n);
                this.m_CurrentCursor = this.m_NavigationCursor;
                persistentObject = (PersistentObject)this.m_NavigationCursor.getFocusObject();
                this.moveDataToUI(this.getCurrentRowNumber(), 2);
                this.getElementAt(n + 1);
                if (n == 0) {
                    this.announceRecordNavigateOnBoundary(new RecordNavigateEvent(this, 8));
                }
            }
            catch (PositionOutOfRangeException positionOutOfRangeException) {
                this.getTotalNumberOfRows();
                if (!bl) break block4;
                this.announceRecordNavigateOnBoundary(new RecordNavigateEvent(this, 9));
            }
        }
        this.announceRecordNavigateOnAfterNavigate(new RecordNavigateEvent(this, 2, n, persistentObject2, persistentObject, persistentObject.isDirty(), this.isDirty()));
    }

    public final void first() throws PositionOutOfRangeException {
        try {
            if (this.m_SynchronizerLink != null) {
                this.m_SynchronizerLink.navigate(3, null);
                return;
            }
        }
        catch (ParentInvalidRecordException parentInvalidRecordException) {
            this.announceException(new ExceptionEvent(7, parentInvalidRecordException.getMessage(), this, parentInvalidRecordException));
            return;
        }
        catch (RelationshipPendingException relationshipPendingException) {
            this.treatPendingException(relationshipPendingException);
        }
    }

    private final void firstIntern() throws PositionOutOfRangeException {
        int n = 0;
        boolean bl = this.isQBERow();
        try {
            this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applFirst, ApplicationTask.nextTask, this, ""));
            this.getElementAt(n);
            if (!bl) {
                this.announceRecordNavigateOnBeforeNavigate(new RecordNavigateEvent(this, 0, 0, (PersistentObject)this.getCurrentObject(), null));
            }
            this.m_NavigationCursor.setPosition(n);
            this.m_CurrentCursor = this.m_NavigationCursor;
            if (bl) {
                this.announceRecordNavigateOnBeforeNavigate(new RecordNavigateEvent(this, 0, 0, (PersistentObject)this.getCurrentObject(), null));
            }
            PersistentObject persistentObject = (PersistentObject)this.m_NavigationCursor.getFocusObject();
            this.moveDataToUI(this.getCurrentRowNumber(), 2);
            this.announceRecordNavigateOnBoundary(new RecordNavigateEvent(this, 8));
            try {
                this.getElementAt(n + 1);
            }
            catch (PositionOutOfRangeException positionOutOfRangeException) {
                this.getTotalNumberOfRows();
                this.announceRecordNavigateOnBoundary(new RecordNavigateEvent(this, 9));
            }
            this.announceRecordNavigateOnAfterNavigate(new RecordNavigateEvent(this, 0, 0, null, persistentObject, persistentObject.isDirty(), this.isDirty()));
            this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applFirst, null, this, String.valueOf(MyResource.getString("QueryNavigator_GotoRow")) + (this.m_NavigationCursor.getPosition() + 1)));
            return;
        }
        catch (PositionOutOfRangeException positionOutOfRangeException) {
            this.startQueryByExample();
            this.announceRecordNavigateOnBoundary(new RecordNavigateEvent(this, 10));
            this.announceException(new ExceptionEvent(3, "NO ROWS", this, positionOutOfRangeException));
            this.moveDataToUI(0, 2);
            throw positionOutOfRangeException;
        }
        catch (Exception exception) {
            this.announceException(new ExceptionEvent(1, exception.getMessage(), this, exception));
            return;
        }
    }

    private final void goToRow(int n) {
        PersistentObject persistentObject = null;
        PersistentObject persistentObject2 = null;
        if (n > 0) {
            persistentObject2 = (PersistentObject)this.m_NavigationCursor.getFocusObject();
            try {
                this.getElementAt(n - 1);
                this.announceRecordNavigateOnBeforeNavigate(new RecordNavigateEvent(this, 6, n, persistentObject2, null));
                this.m_NavigationCursor.setPosition(n - 1);
                this.m_CurrentCursor = this.m_NavigationCursor;
                this.moveDataToUI(this.getCurrentRowNumber(), 2);
                persistentObject = (PersistentObject)this.m_NavigationCursor.getFocusObject();
                this.announceRecordNavigateOnAfterNavigate(new RecordNavigateEvent(this, 6, n, persistentObject2, persistentObject, persistentObject.isDirty(), this.isDirty()));
                if (this.BOF()) {
                    this.announceRecordNavigateOnBoundary(new RecordNavigateEvent(this, 8, n, persistentObject2, persistentObject, persistentObject.isDirty(), this.isDirty()));
                    return;
                }
                if (this.EOF()) {
                    this.announceRecordNavigateOnBoundary(new RecordNavigateEvent(this, 9, n, persistentObject2, persistentObject, persistentObject.isDirty(), this.isDirty()));
                    return;
                }
            }
            catch (PositionOutOfRangeException positionOutOfRangeException) {
                this.announceException(new ExceptionEvent(1, "Request for invalid row ignored.", this, null));
                return;
            }
        }
    }

    public void go_to(int n) {
        this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applGoto, null, this, ""));
        try {
            if (this.m_SynchronizerLink != null) {
                this.m_SynchronizerLink.navigate(5, new Integer(n));
            }
            if (n != this.getTotalNumberOfRows()) {
                this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applGoto, null, this, String.valueOf(MyResource.getString("QueryNavigator_GotoRow")) + (this.m_NavigationCursor.getPosition() + 1)));
                return;
            }
            this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applGoto, null, this, String.valueOf(LAST_ROW) + (this.m_NavigationCursor.getPosition() + 1)));
            return;
        }
        catch (ParentInvalidRecordException parentInvalidRecordException) {
            this.announceException(new ExceptionEvent(7, parentInvalidRecordException.getMessage(), this, parentInvalidRecordException));
            return;
        }
        catch (RelationshipPendingException relationshipPendingException) {
            this.treatPendingException(relationshipPendingException);
            return;
        }
    }

    private void goToIntern(int n) {
        this.goToRow(n);
    }

    public final void previous() throws PositionOutOfRangeException {
        this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applPrevious, ApplicationTask.previousTask, this, ""));
        try {
            if (this.m_SynchronizerLink != null) {
                this.m_SynchronizerLink.navigate(2, null);
            }
            this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applPrevious, null, this, String.valueOf(MyResource.getString("QueryNavigator_GotoRow")) + (this.m_NavigationCursor.getPosition() + 1)));
            return;
        }
        catch (ParentInvalidRecordException parentInvalidRecordException) {
            this.announceException(new ExceptionEvent(7, parentInvalidRecordException.getMessage(), this, parentInvalidRecordException));
            return;
        }
        catch (RelationshipPendingException relationshipPendingException) {
            this.treatPendingException(relationshipPendingException);
            return;
        }
    }

    private final void previousIntern(boolean bl) throws PositionOutOfRangeException {
        int n = this.m_NavigationCursor.getPosition();
        try {
            int n2 = n - 1;
            PersistentObject persistentObject = (PersistentObject)this.m_NavigationCursor.getFocusObject();
            this.getElementAt(n2);
            this.announceRecordNavigateOnBeforeNavigate(new RecordNavigateEvent(this, 3, n2, persistentObject, null));
            this.m_NavigationCursor.setPosition(n2);
            this.m_CurrentCursor = this.m_NavigationCursor;
            PersistentObject persistentObject2 = (PersistentObject)this.m_NavigationCursor.getFocusObject();
            this.moveDataToUI(this.getCurrentRowNumber(), 2);
            this.announceRecordNavigateOnAfterNavigate(new RecordNavigateEvent(this, 3, n2, persistentObject, persistentObject2, persistentObject2.isDirty(), this.isDirty()));
            this.getElementAt(n2 - 1);
            return;
        }
        catch (PositionOutOfRangeException positionOutOfRangeException) {
            PersistentObject persistentObject = (PersistentObject)this.getCurrentObject();
            this.announceRecordNavigateOnBoundary(new RecordNavigateEvent(this, 8, 0, null, null, persistentObject.isDirty(), this.isDirty()));
            throw positionOutOfRangeException;
        }
        catch (Exception exception) {
            this.announceException(new ExceptionEvent(1, exception.getMessage(), this, exception));
            return;
        }
    }

    public String getAliasName() {
        return this.m_AliasName;
    }

    public void setClassName(String string) {
        this.m_POClassName = string;
        if (Beans.isDesignTime()) {
            return;
        }
        try {
            this.m_POFactory = Class.forName(string);
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.announceException(new ExceptionEvent(1, classNotFoundException.getMessage(), this, classNotFoundException));
            return;
        }
    }

    public String getClassName() {
        return this.m_POClassName;
    }

    public String getDataName() {
        return this.getClassName();
    }

    String getTableName() {
        if (this.getCurrentObject() == null) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(((PersistentObject)this.getCurrentObject()).getDataName(","), "@");
        String string = (String)stringTokenizer.nextElement();
        if (string == null) {
            string = this.getDataName();
        }
        return string;
    }

    public String getSaveChangesWindowClass() {
        return this.m_SaveChangesWindowClass;
    }

    public void setSaveChangesWindowClass(String string) {
        this.m_SaveChangesWindowClass = string;
    }

    public String getDirtySaveMessage() {
        return this.m_DirtySaveMessage;
    }

    public void setDirtySaveMessage(String string) {
        this.m_DirtySaveMessage = string;
    }

    protected synchronized void initPO(PersistentObject persistentObject) {
        persistentObject.initDataStorage();
    }

    public void createQueryByExampleRow() {
        PersistentObject persistentObject = null;
        try {
            if (this.m_POFactory == null) {
                this.setClassName(this.m_POClassName);
            }
            try {
                persistentObject = (PersistentObject)this.m_POFactory.newInstance();
                this.initPO(persistentObject);
                persistentObject.setMarkedAsQBE(true);
            }
            catch (InstantiationException instantiationException) {
                System.out.println(instantiationException.getMessage());
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                return;
            }
            this.m_QBECursor.setFocusObject(persistentObject);
            this.m_CurrentCursor = this.m_QBECursor;
            String string = persistentObject.getDataName(",");
            String string2 = "";
            int n = 0;
            while (n < SpecialFeatures.length) {
                string2 = String.valueOf(string2) + "," + SpecialFeatures[n];
                ++n;
            }
            Vector vector = new Vector();
            QueryNavigator queryNavigator = this;
            synchronized (queryNavigator) {
                if (this.triggerListeners != null) {
                    vector = (Vector)this.triggerListeners.clone();
                }
            }
            int n2 = 0;
            while (n2 < vector.size()) {
                Name name = new Name(this.m_AliasName, String.valueOf(string.substring(string.indexOf("@") + 1, string.length())) + string2);
                ((TriggerUIListener)vector.elementAt(n2)).setDataBinding(name.getFullName());
                ++n2;
            }
            this.moveDataToUI(0, 7);
            return;
        }
        catch (Exception exception) {
            this.announceException(new ExceptionEvent(1, exception.getMessage(), this, exception));
            throw new RuntimeException(exception.getMessage());
        }
    }

    public final void startQBE() {
        String string = "startQBE";
        try {
            this.checkSQLAdapter(string);
            if (this.m_SynchronizerLink != null) {
                this.announceRecordNavigateOnBeforeNavigate(new RecordNavigateEvent(this, 5));
                this.m_SynchronizerLink.navigate(6, null);
                this.announceRecordNavigateOnAfterNavigate(new RecordNavigateEvent(this, 5));
                return;
            }
        }
        catch (ParentInvalidRecordException parentInvalidRecordException) {
            this.announceException(new ExceptionEvent(7, parentInvalidRecordException.getMessage(), this, parentInvalidRecordException));
            return;
        }
        catch (RelationshipPendingException relationshipPendingException) {
            this.treatPendingException(relationshipPendingException);
            return;
        }
        catch (SQLException sQLException) {
            this.announceException(new ExceptionEvent(1, sQLException.getMessage(), this, sQLException));
        }
    }

    public synchronized void startQueryByExample() {
        this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applQbe, ApplicationTask.qbeTask, this, ""));
        this.getQBEObject();
        this.m_CurrentCursor = this.m_QBECursor;
        this.moveDataToUI(0, 1);
        this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applQbe, null, this, ""));
    }

    public synchronized void executeQueryByExample() {
        PersistentObject persistentObject = this.getQBEObject();
        if (persistentObject == null) {
            return;
        }
        if (persistentObject.isDirty()) {
            try {
                persistentObject.checkQBEValues();
                return;
            }
            catch (QBExlator.QBExlatException qBExlatException) {
                this.announceException(new ExceptionEvent(2, String.valueOf(qBExlatException.getMessage()) + MyResource.getString("QueryNavigator_InvalidQBE1"), this, new Exception(qBExlatException.getMessage())));
                throw new RuntimeException(MyResource.getString("QueryNavigator_InvalidQBE2"));
            }
        }
    }

    public void delete() {
        this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applDelete, ApplicationTask.deleteTask, this, ""));
        this.announceOnBeforeColumnDataChange(new ColumnDataEvent(this, this.getCurrentRowNumber(), 0, null, null, 2));
        this.setMarkedAsDeleted();
        this.dataChanged = true;
        this.moveDataToUI(this.getCurrentRowNumber(), 3);
        this.announceOnAfterColumnDataChange(new ColumnDataEvent(this, this.getCurrentRowNumber(), 0, null, null, 2));
        this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applDelete, null, this, String.valueOf(MyResource.getString("QueryNavigator_Delete")) + (this.m_NavigationCursor.getPosition() + 1)));
    }

    public synchronized void save() {
        try {
            if (this.m_SynchronizerLink != null) {
                if (this.dbEngineType == 7) {
                    this.m_SynchronizerLink.saveAll();
                    return;
                }
                this.m_SynchronizerLink.save();
                return;
            }
        }
        catch (RelationshipPendingException relationshipPendingException) {
            this.treatPendingException(relationshipPendingException);
            return;
        }
        catch (ParentInvalidRecordException parentInvalidRecordException) {
            this.announceException(new ExceptionEvent(7, parentInvalidRecordException.getMessage(), this, parentInvalidRecordException));
            return;
        }
        catch (SQLException sQLException) {
            this.announceException(new ExceptionEvent(1, sQLException.getMessage(), this, sQLException));
        }
    }

    private int transitionRowStateToSaveEventType(PersistentObject persistentObject) {
        int n = -1;
        n = persistentObject.getMarkedAsNew() ? 0 : (persistentObject.getMarkedAsModified() ? 2 : (persistentObject.getMarkedAsDeleted() ? 1 : -1));
        return n;
    }

    public synchronized int saveIntern() throws SQLException {
        int n = 0;
        this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applSave, ApplicationTask.saveTask, this, String.valueOf(MyResource.getString("QueryNavigator_SaveIntern")) + (this.m_NavigationCursor.getPosition() + 1)));
        PersistentObject persistentObject = (PersistentObject)this.getCurrentObject();
        if (this.isEmpty()) {
            return n;
        }
        if (persistentObject == null) {
            return n;
        }
        int n2 = this.transitionRowStateToSaveEventType(persistentObject);
        boolean bl = persistentObject.getMarkedAsDeleted();
        persistentObject.getMarkedAsNew();
        String string = this.getOperation(persistentObject.getOperation());
        boolean bl2 = persistentObject.getMarkedAsMisplaced();
        try {
            if (!persistentObject.isOperationNothing()) {
                this.announceOnBeforeRecordSave(new RecordSaveEvent(this, 0, 1, n2, persistentObject));
            }
            n = persistentObject.save();
            if (!bl && !bl2) {
                this.m_UpdatedRecordsVector.addElement(persistentObject);
            } else {
                this.m_DeletedRecordsVector.addElement(persistentObject);
            }
            if (n >= 1) {
                this.commitState();
            }
            this.announceOnAfterRecordSave(new RecordSaveEvent(this, 0, n, n2, persistentObject));
            this.moveDataToUI(this.getCurrentRowNumber(), 6);
            persistentObject = (PersistentObject)this.getCurrentObject();
            string = String.valueOf(string) + n + " " + MyResource.getString("QueryNavigator_SAIntern4");
            this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applSave, null, this, string));
        }
        catch (Exception exception) {
            this.announceException(new ExceptionEvent(1, exception.getMessage(), this, exception));
            throw new SQLException(exception.getMessage());
        }
        return n;
    }

    private String getOperation(int n) {
        String string = "";
        switch (n) {
            case 13: {
                string = MyResource.getString("QueryNavigator_SaveNothing");
                break;
            }
            case 14: {
                string = MyResource.getString("QueryNavigator_SaveInserted");
                break;
            }
            case 15: {
                string = MyResource.getString("QueryNavigator_SaveUpdated");
                break;
            }
            case 16: {
                string = MyResource.getString("QueryNavigator_SaveDeleted");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid try to call getOperation in QueryNavigator");
            }
        }
        return string;
    }

    public void setMarkedAsDeleted() {
        try {
            PersistentObject persistentObject = (PersistentObject)this.m_CurrentCursor.getFocusObject();
            if (persistentObject != null) {
                persistentObject.setMarkedAsDeleted(true);
                return;
            }
        }
        catch (Exception exception) {
            this.announceException(new ExceptionEvent(1, exception.getMessage(), this, exception));
        }
    }

    public boolean isQBERow() {
        return this.m_CurrentCursor == this.m_QBECursor;
    }

    public void undoColumnChanges(int n) {
        try {
            PersistentObject persistentObject = (PersistentObject)this.m_CurrentCursor.getFocusObject();
            if (persistentObject != null) {
                this.announceOnBeforeUndoEvent(persistentObject);
                persistentObject.undoColumnChanges(n);
                this.announceOnAfterUndoEvent(persistentObject);
                this.moveDataToUI(this.getCurrentRowNumber(), 6);
                return;
            }
        }
        catch (Exception exception) {
            this.announceException(new ExceptionEvent(1, exception.getMessage(), this, exception));
        }
    }

    private void announceOnAfterUndoEvent(PersistentObject persistentObject) {
        if (!persistentObject.getMarkedAsModified()) {
            if (this.isQBERow()) {
                this.announceOnAfterColumnDataChange(new ColumnDataEvent(this, -1, 0, null, null, 1));
                return;
            }
            this.announceOnAfterColumnDataChange(new ColumnDataEvent(this, this.getCurrentRowNumber(), 0, null, null, 1));
        }
    }

    private void announceOnBeforeUndoEvent(PersistentObject persistentObject) {
        if (this.isQBERow()) {
            this.announceOnBeforeColumnDataChange(new ColumnDataEvent(this, -1, 0, null, null, 1));
            return;
        }
        this.announceOnBeforeColumnDataChange(new ColumnDataEvent(this, this.getCurrentRowNumber(), 0, null, null, 1));
    }

    public void undoChanges() {
        try {
            this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applClear, ApplicationTask.clearTask, this, ""));
            PersistentObject persistentObject = (PersistentObject)this.m_CurrentCursor.getFocusObject();
            if (persistentObject != null) {
                this.announceOnBeforeUndoEvent(persistentObject);
                Integer[] integerArray = persistentObject.getModifiedColumns();
                int n = 0;
                while (n < integerArray.length) {
                    this.setValue(persistentObject.getValueAsObject(integerArray[n], 0), 0, integerArray[n]);
                    ++n;
                }
                if (!persistentObject.getMarkedAsNew()) {
                    persistentObject.resetState();
                }
                this.announceOnAfterUndoEvent(persistentObject);
                this.moveDataToUI(this.getCurrentRowNumber(), 6);
            }
            this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applClear, ApplicationTask.clearTask, this, ""));
            return;
        }
        catch (Exception exception) {
            this.announceException(new ExceptionEvent(1, exception.getMessage(), this, exception));
            return;
        }
    }

    private int saveDelete() throws RelationshipPendingException, SQLException {
        return this.saveAllIntern(1);
    }

    private int saveAllIntern(int n) throws RelationshipPendingException, SQLException {
        Enumeration enumeration;
        if (this.m_ObjectVector == null) {
            return this.rowsSaved;
        }
        this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applSaveAll, ApplicationTask.saveAllTask, this, ""));
        Object object = this.m_ObjectVector;
        synchronized (object) {
            if (this.m_ObjectVector.size() == 0) {
                int n2 = this.rowsSaved;
                Object var6_5 = null;
                return n2;
            }
            PersistentObject persistentObject = (PersistentObject)this.m_ObjectVector.elementAt(0);
            try {
                if (this.getQBEObject() instanceof RecordDefinition) {
                    Connection connection = persistentObject.getConnection();
                }
            }
            catch (Exception exception) {
                this.announceException(new ExceptionEvent(1, exception.getMessage(), this, exception));
                throw new RuntimeException(exception.getMessage());
            }
            enumeration = this.m_ObjectVector.elements();
        }
        boolean bl = true;
        showSaveWindow = true;
        object = new int[3];
        int n3 = 0;
        while (n3 < ((Object)object).length) {
            object[n3] = false;
            ++n3;
        }
        int n4 = 1;
        while (enumeration.hasMoreElements()) {
            PersistentObject persistentObject = (PersistentObject)enumeration.nextElement();
            boolean bl2 = persistentObject.getMarkedAsMisplaced();
            int n5 = this.transitionRowStateToSaveEventType(persistentObject);
            int n6 = 0;
            try {
                switch (n) {
                    case 2: {
                        if (persistentObject.getMarkedAsDeleted()) break;
                        if (bl2) {
                            this.m_DeletedRecordsVector.addElement(persistentObject);
                        }
                        this.m_UpdatedRecordsVector.addElement(persistentObject);
                        try {
                            switch (persistentObject.getOperation()) {
                                case 14: {
                                    Object object2 = object;
                                    object2[0] = object2[0] + true;
                                    break;
                                }
                                case 15: {
                                    Object object3 = object;
                                    object3[1] = object3[1] + true;
                                    break;
                                }
                            }
                            n5 = this.transitionRowStateToSaveEventType(persistentObject);
                            if (!persistentObject.isOperationNothing()) {
                                this.announceOnBeforeRecordSave(new RecordSaveEvent(this, 0, 1, n5, persistentObject));
                            }
                            n6 = persistentObject.save();
                            this.rowsSaved += n6;
                        }
                        catch (Exception exception) {
                            this.announceException(new ExceptionEvent(1, exception.getMessage(), this, exception));
                            this.announceRecordSaveException(new RecordSaveEvent(this, 0, 1, 1, persistentObject, exception, persistentObject.getStatement()));
                        }
                        break;
                    }
                    case 1: {
                        if (!persistentObject.getMarkedAsDeleted()) break;
                        try {
                            n5 = this.transitionRowStateToSaveEventType(persistentObject);
                            if (!persistentObject.isOperationNothing()) {
                                this.announceOnBeforeRecordSave(new RecordSaveEvent(this, 0, 1, n5, persistentObject));
                            }
                            n6 = persistentObject.save();
                            this.rowsSaved += n6;
                            Object object4 = object;
                            object4[2] = object4[2] + true;
                            this.m_DeletedRecordsVector.addElement(persistentObject);
                        }
                        catch (Exception exception) {
                            this.announceException(new ExceptionEvent(1, exception.getMessage(), this, exception));
                            this.announceRecordSaveException(new RecordSaveEvent(this, 3, 1, 1, persistentObject, exception, persistentObject.getStatement()));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(MyResource.getString("QueryNavigator_IllegalSaveAll"));
                    }
                }
                if (n6 >= 1) {
                    this.announceOnAfterRecordSave(new RecordSaveEvent(this, 0, 1, n5, persistentObject));
                }
            }
            catch (Exception exception) {
                bl = false;
                String string = String.valueOf(MyResource.getString("QueryNavigator_SAIntern1")) + String.valueOf(n4) + MyResource.getString("QueryNavigator_SAIntern2") + exception.getMessage();
                this.announceException(new ExceptionEvent(1, string, this, exception));
                throw new SQLException(exception.getMessage());
            }
            ++n4;
        }
        if (this.rowsSaved > 0) {
            this.announceEvent((int[])object);
        }
        return this.rowsSaved;
    }

    private void announceEvent(int[] nArray) {
        String string = "";
        try {
            if (nArray[0] > 0) {
                string = String.valueOf(MyResource.getString("QueryNavigator_SaveInserted")) + nArray[0] + " " + MyResource.getString("QueryNavigator_SAIntern3");
                this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applSaveAll, null, this, string));
            }
            if (nArray[1] > 0) {
                string = String.valueOf(MyResource.getString("QueryNavigator_SaveUpdated")) + nArray[1] + " " + MyResource.getString("QueryNavigator_SAIntern3");
                this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applSaveAll, null, this, string));
            }
            if (nArray[2] > 0) {
                string = String.valueOf(MyResource.getString("QueryNavigator_SaveDeleted")) + nArray[2] + " " + MyResource.getString("QueryNavigator_SAIntern3");
                this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applSaveAll, null, this, string));
                return;
            }
        }
        catch (Exception exception) {
            System.out.println("EXCEPTION" + exception.getMessage());
        }
    }

    public int getDirtyRowsNumber() {
        int n = 0;
        if (this.m_ObjectVector == null) {
            return n;
        }
        Enumeration enumeration = this.m_ObjectVector.elements();
        int n2 = 1;
        while (enumeration.hasMoreElements()) {
            PersistentObject persistentObject = (PersistentObject)enumeration.nextElement();
            if (!persistentObject.isOperationNothing()) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public int saveAll() {
        try {
            if (this.m_SynchronizerLink != null) {
                this.m_SynchronizerLink.saveAll();
            }
        }
        catch (RelationshipPendingException relationshipPendingException) {
            this.treatPendingException(relationshipPendingException);
        }
        catch (ParentInvalidRecordException parentInvalidRecordException) {
            this.announceException(new ExceptionEvent(7, parentInvalidRecordException.getMessage(), this, parentInvalidRecordException));
        }
        catch (SQLException sQLException) {
            this.announceException(new ExceptionEvent(1, sQLException.getMessage(), this, sQLException));
        }
        return 0;
    }

    public int saveAllLevels() {
        try {
            if (this.m_SynchronizerLink != null) {
                this.m_SynchronizerLink.saveAllLevels();
            }
        }
        catch (RelationshipPendingException relationshipPendingException) {
            this.treatPendingException(relationshipPendingException);
        }
        catch (ParentInvalidRecordException parentInvalidRecordException) {
            this.announceException(new ExceptionEvent(7, parentInvalidRecordException.getMessage(), this, parentInvalidRecordException));
        }
        return 0;
    }

    public void restart() {
        this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applLoad, ApplicationTask.connectingDB, this, ""));
        try {
            if (this.m_SynchronizerLink != null) {
                this.m_SynchronizerLink.navigate(4, null);
            }
        }
        catch (ParentInvalidRecordException parentInvalidRecordException) {
            this.announceException(new ExceptionEvent(7, parentInvalidRecordException.getMessage(), this, parentInvalidRecordException));
        }
        catch (RelationshipPendingException relationshipPendingException) {
            this.treatPendingException(relationshipPendingException);
        }
        this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applLoad, null, this, ""));
    }

    void restartIntern() {
        this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applRestart, ApplicationTask.restartTask, this, ""));
        this.executeQueryByExample();
        this.newSet = false;
        System.gc();
        this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applRestart, null, this, ""));
    }

    public void insert() {
        this.taskAction.tb.announceData(new TaskBusEvent(0, ChainTasks.applNew, ApplicationTask.newTask, this, ""));
        try {
            try {
                if (this.m_SynchronizerLink != null) {
                    this.m_SynchronizerLink.navigate(7, null);
                }
            }
            catch (ParentInvalidRecordException parentInvalidRecordException) {
                this.announceException(new ExceptionEvent(7, parentInvalidRecordException.getMessage(), this, parentInvalidRecordException));
            }
            catch (RelationshipPendingException relationshipPendingException) {
                this.treatPendingException(relationshipPendingException);
            }
            Object var2_3 = null;
            this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applNew, null, this, String.valueOf(MyResource.getString("QueryNavigator_Insert")) + (this.m_NavigationCursor.getPosition() + 1)));
            return;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.taskAction.tb.announceData(new TaskBusEvent(2, ChainTasks.applNew, null, this, String.valueOf(MyResource.getString("QueryNavigator_Insert")) + (this.m_NavigationCursor.getPosition() + 1)));
            throw throwable;
        }
    }

    protected void insertIntern() {
        if (!this.getExecute() || this.isQBERow()) {
            this.restart();
        }
        PersistentObject persistentObject = null;
        this.announceRecordNavigateOnBeforeNavigate(new RecordNavigateEvent(this, 4));
        try {
            persistentObject = (PersistentObject)this.m_POFactory.newInstance();
            this.initPO(persistentObject);
        }
        catch (InstantiationException instantiationException) {
            this.announceException(new ExceptionEvent(1, instantiationException.getMessage(), this, instantiationException));
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.announceException(new ExceptionEvent(1, illegalAccessException.getMessage(), this, illegalAccessException));
            return;
        }
        persistentObject.setMarkedAsNew(true);
        QueryNavigator queryNavigator = this;
        synchronized (queryNavigator) {
            int n;
            if (this.m_ObjectVector == null) {
                this.m_ObjectVector = new Vector();
            }
            if ((n = this.m_NavigationCursor.getPosition()) == -1) {
                n = 0;
            }
            this.m_ObjectVector.insertElementAt(persistentObject, n);
            try {
                this.m_NavigationCursor.setPosition(n);
                this.m_CurrentCursor = this.m_NavigationCursor;
                this.announceRecordNavigateOnAfterNavigate(new RecordNavigateEvent(this, 4, n, null, persistentObject));
            }
            catch (PositionOutOfRangeException positionOutOfRangeException) {}
            return;
        }
    }

    protected synchronized void moveDataToUI(int n, int n2) {
        this.TriggerUI(n, n2);
    }

    public synchronized void addTriggerUIListener(TriggerUIListener triggerUIListener) {
        this.triggerListeners.addElement(triggerUIListener);
    }

    public synchronized void removeTriggerUIListener(TriggerUIListener triggerUIListener) {
        this.triggerListeners.removeElement(triggerUIListener);
    }

    protected void TriggerUI(int n, int n2) {
        Vector vector;
        TriggerUIEvent triggerUIEvent = new TriggerUIEvent(this, n, n2);
        QueryNavigator queryNavigator = this;
        synchronized (queryNavigator) {
            if (this.triggerListeners == null) {
                Object var6_6 = null;
                return;
            }
            vector = (Vector)this.triggerListeners.clone();
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            ((TriggerUIListener)vector.elementAt(n3)).commitUI(triggerUIEvent);
            ++n3;
        }
    }

    public void setAutoStart(boolean bl) {
        this.autoStart = bl;
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public synchronized void addExceptionEventListener(ExceptionEventListener exceptionEventListener) {
        this.listenersExceptions.addElement(exceptionEventListener);
    }

    public synchronized void removeExceptionEventListener(ExceptionEventListener exceptionEventListener) {
        this.listenersExceptions.removeElement(exceptionEventListener);
    }

    public void announceException(ExceptionEvent exceptionEvent) {
        Vector vector;
        Object object = this;
        synchronized (object) {
            if (this.listenersExceptions == null) {
                Object var4_3 = null;
                return;
            }
            vector = (Vector)this.listenersExceptions.clone();
        }
        object = new ExceptionEvent(exceptionEvent.getEventType(), exceptionEvent.getExceptionName(), exceptionEvent.getSource());
        int n = 0;
        while (n < vector.size()) {
            ExceptionEventListener exceptionEventListener = (ExceptionEventListener)vector.elementAt(n);
            exceptionEventListener.handleExceptionEvent((ExceptionEvent)object);
            ++n;
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public int getTotalNumberOfRows() {
        if (this.newSet) {
            int n = 0;
            try {
                while (true) {
                    this.getElementAt(n);
                    ++n;
                }
            }
            catch (PositionOutOfRangeException positionOutOfRangeException) {
                this.newSet = false;
                this.announceRecordNavigateOnBoundary(new RecordNavigateEvent(this, 11));
            }
        }
        if (this.isQBERow()) {
            return 1;
        }
        if (this.m_ObjectVector == null) {
            return 0;
        }
        return this.m_ObjectVector.size();
    }

    public Object getCurrentObject() {
        if (this.m_CurrentCursor != null) {
            return this.m_CurrentCursor.getFocusObject();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public synchronized void commitState() {
        block9: {
            int n = this.m_NavigationCursor.getPosition();
            boolean bl = false;
            Enumeration enumeration = this.m_UpdatedRecordsVector.elements();
            while (enumeration.hasMoreElements()) {
                ((PersistentObject)enumeration.nextElement()).resetState();
            }
            Enumeration enumeration2 = this.m_DeletedRecordsVector.elements();
            while (enumeration2.hasMoreElements()) {
                bl = true;
                this.m_ObjectVector.removeElement(enumeration2.nextElement());
            }
            if (bl) {
                try {
                    this.m_NavigationCursor.setPosition(n - this.m_DeletedRecordsVector.size());
                }
                catch (PositionOutOfRangeException positionOutOfRangeException) {}
                this.m_CurrentCursor = this.m_NavigationCursor;
                try {
                    this.nextIntern(false);
                }
                catch (PositionOutOfRangeException positionOutOfRangeException) {
                    if (this.m_NavigationCursor.getPosition() == -1) {
                        this.startQueryByExample();
                        this.announceException(new ExceptionEvent(3, "NO ROWS", this, positionOutOfRangeException));
                    }
                    if (this.m_NavigationCursor.getPosition() == 0) {
                        this.announceRecordNavigateOnBoundary(new RecordNavigateEvent(this, 8));
                        this.announceRecordNavigateOnBoundary(new RecordNavigateEvent(this, 9));
                    }
                    if (this.m_NavigationCursor.getPosition() != 1) break block9;
                    this.announceRecordNavigateOnBoundary(new RecordNavigateEvent(this, 9));
                }
            }
        }
        this.moveDataToUI(this.getCurrentRowNumber(), 6);
        this.m_UpdatedRecordsVector = new Vector();
        this.m_DeletedRecordsVector = new Vector();
    }

    public synchronized void close() {
        if (!Beans.isDesignTime()) {
            if (this.m_ObjectVector != null) {
                Enumeration enumeration = this.m_ObjectVector.elements();
                int n = 0;
                while (enumeration.hasMoreElements()) {
                    PersistentObject persistentObject = (PersistentObject)enumeration.nextElement();
                    persistentObject.close();
                    ++n;
                }
            }
            m_AliasesName.remove(this.m_AliasName);
            try {
                this.mediatords.killAll();
            }
            catch (Throwable throwable) {
                this.announceException(new ExceptionEvent(1, MyResource.getString("QueryNavigator_CloseException"), this, null));
            }
            this.closes.firePropertyChange("close", new Boolean(false), new Boolean(true));
            this.m_SynchronizerLink.removePropertyChangeListener(this);
            try {
                this.finalize();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }

    public PersistentObject getQBEObject() {
        Object object = this.m_QBECursor.getFocusObject();
        if (object == null) {
            this.createQueryByExampleRow();
            object = this.m_QBECursor.getFocusObject();
        }
        return (PersistentObject)object;
    }

    public void handleExceptionEvent(ExceptionEvent exceptionEvent) {
        System.out.println(exceptionEvent.getExceptionName());
    }

    public String toString() {
        return this.getAliasName();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.closes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.closes.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "close") {
            this.close();
        }
    }

    public synchronized void addRecordNavigateEventListener(RecordNavigateEventListener recordNavigateEventListener) {
        this.listenersRecordNavigate.addElement(recordNavigateEventListener);
    }

    public synchronized void removeRecordNavigateEventListener(RecordNavigateEventListener recordNavigateEventListener) {
        this.listenersRecordNavigate.removeElement(recordNavigateEventListener);
    }

    public void announceRecordNavigateOnBeforeNavigate(RecordNavigateEvent recordNavigateEvent) {
        Vector vector;
        QueryNavigator queryNavigator = this;
        synchronized (queryNavigator) {
            if (this.listenersRecordNavigate == null) {
                Object var4_4 = null;
                return;
            }
            vector = (Vector)this.listenersRecordNavigate.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            RecordNavigateEventListener recordNavigateEventListener = (RecordNavigateEventListener)vector.elementAt(n);
            try {
                recordNavigateEventListener.onBeforeRecordNavigate(recordNavigateEvent);
            }
            catch (Exception exception) {}
            ++n;
        }
    }

    public void announceRecordNavigateOnAfterNavigate(RecordNavigateEvent recordNavigateEvent) {
        Vector vector;
        QueryNavigator queryNavigator = this;
        synchronized (queryNavigator) {
            if (this.listenersRecordNavigate == null) {
                Object var4_4 = null;
                return;
            }
            vector = (Vector)this.listenersRecordNavigate.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            RecordNavigateEventListener recordNavigateEventListener = (RecordNavigateEventListener)vector.elementAt(n);
            try {
                recordNavigateEventListener.onAfterRecordNavigate(recordNavigateEvent);
            }
            catch (Exception exception) {}
            ++n;
        }
    }

    public void announceRecordNavigateOnBoundary(RecordNavigateEvent recordNavigateEvent) {
        Vector vector;
        QueryNavigator queryNavigator = this;
        synchronized (queryNavigator) {
            if (this.listenersRecordNavigate == null) {
                Object var4_4 = null;
                return;
            }
            vector = (Vector)this.listenersRecordNavigate.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            RecordNavigateEventListener recordNavigateEventListener = (RecordNavigateEventListener)vector.elementAt(n);
            try {
                recordNavigateEventListener.onBoundaryRecord(recordNavigateEvent);
            }
            catch (Exception exception) {}
            ++n;
        }
    }

    public synchronized void addColumnDataEventListener(ColumnDataEventListener columnDataEventListener) {
        this.listenersColumnData.addElement(columnDataEventListener);
    }

    public synchronized void removeColumnDataEventListener(ColumnDataEventListener columnDataEventListener) {
        this.listenersColumnData.removeElement(columnDataEventListener);
    }

    public void announceOnBeforeColumnDataChange(ColumnDataEvent columnDataEvent) {
        try {
            Vector vector;
            QueryNavigator queryNavigator = this;
            synchronized (queryNavigator) {
                if (this.listenersColumnData == null) {
                    Object var4_5 = null;
                    return;
                }
                vector = (Vector)this.listenersColumnData.clone();
            }
            int n = 0;
            while (n < vector.size()) {
                ColumnDataEventListener columnDataEventListener = (ColumnDataEventListener)vector.elementAt(n);
                columnDataEventListener.onBeforeColumnDataChange(columnDataEvent);
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }

    public void announceOnAfterColumnDataChange(ColumnDataEvent columnDataEvent) {
        try {
            Vector vector;
            QueryNavigator queryNavigator = this;
            synchronized (queryNavigator) {
                if (this.listenersColumnData == null) {
                    Object var4_5 = null;
                    return;
                }
                vector = (Vector)this.listenersColumnData.clone();
            }
            int n = 0;
            while (n < vector.size()) {
                ColumnDataEventListener columnDataEventListener = (ColumnDataEventListener)vector.elementAt(n);
                columnDataEventListener.onAfterColumnDataChange(columnDataEvent);
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }

    public synchronized void addRecordSaveEventListener(RecordSaveEventListener recordSaveEventListener) {
        this.listenersRecordSave.addElement(recordSaveEventListener);
    }

    public synchronized void removeRecordSaveEventListener(RecordSaveEventListener recordSaveEventListener) {
        this.listenersRecordSave.removeElement(recordSaveEventListener);
    }

    public synchronized void addRecordSaveEventExceptionListener(RecordSaveEventExceptionListener recordSaveEventExceptionListener) {
        this.listenersRecordSaveException.addElement(recordSaveEventExceptionListener);
    }

    public synchronized void removeRecordSaveEventExceptionListener(RecordSaveEventExceptionListener recordSaveEventExceptionListener) {
        this.listenersRecordSaveException.removeElement(recordSaveEventExceptionListener);
    }

    public void announceOnBeforeRecordSave(RecordSaveEvent recordSaveEvent) {
        try {
            Vector vector;
            QueryNavigator queryNavigator = this;
            synchronized (queryNavigator) {
                if (this.listenersRecordSave == null) {
                    Object var4_5 = null;
                    return;
                }
                vector = (Vector)this.listenersRecordSave.clone();
            }
            int n = 0;
            while (n < vector.size()) {
                RecordSaveEventListener recordSaveEventListener = (RecordSaveEventListener)vector.elementAt(n);
                recordSaveEventListener.onBeforeRecordSave(recordSaveEvent);
                ++n;
            }
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
    }

    public void announceRecordSaveException(RecordSaveEvent recordSaveEvent) throws RecordSaveException {
        Vector vector;
        QueryNavigator queryNavigator = this;
        synchronized (queryNavigator) {
            if (this.listenersRecordSaveException == null) {
                Object var4_4 = null;
                return;
            }
            vector = (Vector)this.listenersRecordSaveException.clone();
        }
        int n = vector.size();
        if (n == 0) {
            throw new RecordSaveException(recordSaveEvent.getException().getMessage(), recordSaveEvent);
        }
        QueryNavigator queryNavigator2 = null;
        int n2 = 0;
        while (n2 < n) {
            RecordSaveEventExceptionListener recordSaveEventExceptionListener = (RecordSaveEventExceptionListener)vector.elementAt(n2);
            if (recordSaveEventExceptionListener == this) {
                queryNavigator2 = this;
            } else {
                recordSaveEventExceptionListener.onRecordSaveException(recordSaveEvent);
            }
            ++n2;
        }
        if (queryNavigator2 != null) {
            queryNavigator2.onRecordSaveException(recordSaveEvent);
        }
    }

    public void announceOnAfterRecordSave(RecordSaveEvent recordSaveEvent) {
        Vector vector;
        QueryNavigator queryNavigator = this;
        synchronized (queryNavigator) {
            if (this.listenersRecordSave == null) {
                Object var4_4 = null;
                return;
            }
            vector = (Vector)this.listenersRecordSave.clone();
        }
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            RecordSaveEventListener recordSaveEventListener = (RecordSaveEventListener)vector.elementAt(n2);
            recordSaveEventListener.onAfterRecordSave(recordSaveEvent);
            ++n2;
        }
    }

    public static QueryNavigator getQueryNavigatorObject(String string) {
        QueryNavigator queryNavigator = null;
        if (m_AliasesName.containsKey(string)) {
            queryNavigator = (QueryNavigator)m_AliasesName.get(string);
        }
        return queryNavigator;
    }

    public void onRecordSaveException(RecordSaveEvent recordSaveEvent) throws RecordSaveException {
        if (!this.m_SaveChangesWindowClass.equals(SAVE_DEFAULT_JFC_WINDOW) && !this.m_SaveChangesWindowClass.equals(SAVE_DEFAULT_JFC11_WINDOW)) {
            throw new RecordSaveException("", recordSaveEvent);
        }
        try {
            if (showSaveWindow) {
                PersistentObject persistentObject = recordSaveEvent.getRecord();
                PersistentObjectModel persistentObjectModel = persistentObject.getDataModel();
                int n = persistentObjectModel.getMemberCount() + 1;
                Object[][] objectArray = new Object[2][n];
                Vector<String> vector = new Vector<String>();
                String[] stringArray = new String[n];
                stringArray[0] = MyResource.getString("QueryNavigator_RecordSave1");
                objectArray[0][0] = MyResource.getString("QueryNavigator_RecordSave2");
                objectArray[1][0] = MyResource.getString("QueryNavigator_RecordSave3");
                int n2 = 1;
                while (n2 < n) {
                    objectArray[0][n2] = persistentObject.getValueAsObject(n2 - 1, 1);
                    objectArray[1][n2] = persistentObject.getValueAsObject(n2 - 1, 0);
                    if (!this.isEqualColumnValue(objectArray[0][n2], objectArray[1][n2])) {
                        vector.addElement(persistentObjectModel.getMemberModel(n2 - 1).getName());
                    }
                    ++n2;
                }
                int n3 = 1;
                while (n3 < n) {
                    stringArray[n3] = persistentObjectModel.getMemberModel(n3 - 1).getName();
                    ++n3;
                }
                Object[] objectArray2 = new String[vector.size()];
                vector.copyInto(objectArray2);
                SaveTransactionChanges saveTransactionChanges = this.m_SaveChangesWindowClass.equals(SAVE_DEFAULT_JFC11_WINDOW) ? (SaveTransactionChanges)Class.forName("symantec.itools.db.beans.javax.swing.JSaveTransactionChangesWindow").newInstance() : (SaveTransactionChanges)Class.forName("symantec.itools.db.beans.binding.SaveTransactionChangesWindow").newInstance();
                switch (saveTransactionChanges.show(stringArray, objectArray, (String[])objectArray2, recordSaveEvent.getException().getMessage(), recordSaveEvent.getStatement(), this.applet)) {
                    case 2: {
                        showSaveWindow = false;
                        return;
                    }
                    case 1: {
                        throw new RecordSaveException("", recordSaveEvent);
                    }
                    default: {
                        throw new IllegalArgumentException(MyResource.getString("QueryNavigator_IllegalSaveAll"));
                    }
                    case 0: {
                        return;
                    }
                }
            }
        }
        catch (RecordSaveException recordSaveException) {
            throw recordSaveException;
        }
        catch (Exception exception) {}
    }

    private boolean isEqualColumnValue(Object object, Object object2) {
        boolean bl = false;
        try {
            bl = object == null && object2 == null ? true : (object == null && object2 != null ? object2.equals(object) : (object != null && object2 == null ? object.equals(object2) : (object != null && object2 != null ? object2.equals(object) : false)));
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public void last() {
        int n = this.getTotalNumberOfRows();
        this.go_to(n);
    }

    private void checkSQLAdapter(String string) throws SQLException {
        String string2 = "";
        if (this.getQBEObject() instanceof SQLRecordDefinition) {
            if (string == "startQBE") {
                string2 = String.valueOf(MyResource.getString("QueryNavigator_StartQBE1")) + string + MyResource.getString("QueryNavigator_StartQBE2");
            }
            throw new SQLException(string2);
        }
    }

    public class TaskAction
    implements TaskBusMember,
    TaskBusEventListener {
        public TaskBus tb;

        public TaskAction() {
            QueryNavigator.this = QueryNavigator.this;
            if (this.tb == null) {
                TaskBus.joinTaskBus(this);
            }
        }

        public void handleTaskBusEvent(TaskBusEvent taskBusEvent) {
        }

        public void setTaskBus(TaskBus taskBus) {
            this.tb = taskBus;
            this.tb.addTaskBusEventListener(this);
        }

        public TaskBus getTaskBus() {
            return this.tb;
        }
    }
}

