/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.binding;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import symantec.itools.db.beans.binding.BasicDataSource;
import symantec.itools.db.beans.binding.MediatorDS;
import symantec.itools.db.beans.binding.Name;
import symantec.itools.db.beans.binding.TriggerUIEvent;
import symantec.itools.db.beans.binding.TriggerUIListener;

public class SingleRowBDSSupport
implements BasicDataSource,
Serializable {
    private static Hashtable hashBindNames = new Hashtable();
    private transient Object[] values;
    protected transient MediatorDS mediatorDS;
    private Vector triggerUIListeners;
    private Object source;

    public synchronized Object[] getValues() {
        return this.values;
    }

    public synchronized void setValues(Object[] objectArray) {
        this.values = objectArray;
    }

    public synchronized Object getValues(int n) {
        Object object = null;
        try {
            object = this.values[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            object = null;
        }
        return object;
    }

    public synchronized void setValues(int n, Object object) {
        if (this.values == null) {
            this.values = new Object[n + 1];
        }
        if (this.values.length <= n) {
            Object[] objectArray = new Object[n + 1];
            System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
            this.values = objectArray;
        }
        this.values[n] = object;
    }

    protected synchronized MediatorDS getMediatorDS() {
        return this.mediatorDS;
    }

    protected synchronized void setMediatorDS(MediatorDS mediatorDS) {
        this.mediatorDS = mediatorDS;
        if (mediatorDS != null) {
            this.mediatorDS.setOutput(this.source);
            String[] stringArray = new String[]{"getValue(Row,Col)"};
            String[] stringArray2 = new String[]{"setValue(Value,Row,Col)"};
            this.mediatorDS.setSetMethods(stringArray2);
            this.mediatorDS.setGetMethods(stringArray);
        }
    }

    public SingleRowBDSSupport() {
        this.source = this;
    }

    public SingleRowBDSSupport(Object object) {
        this.source = object;
    }

    public Object getValue(int n, int n2) {
        Object object = null;
        if (n == 0) {
            object = this.getValues(n2);
        }
        return object;
    }

    public void setValue(Object object, int n, int n2) {
        if (n == 0) {
            this.setValues(n2, object);
        }
    }

    public synchronized void addTriggerUIListener(TriggerUIListener triggerUIListener) {
        if (this.triggerUIListeners == null) {
            this.triggerUIListeners = new Vector();
        }
        this.triggerUIListeners.addElement(triggerUIListener);
    }

    public synchronized void removeTriggerUIListener(TriggerUIListener triggerUIListener) {
        if (this.triggerUIListeners == null) {
            return;
        }
        this.triggerUIListeners.removeElement(triggerUIListener);
    }

    public int getTotalNumberOfRows() {
        int n = 0;
        if (this.values != null) {
            n = 1;
        }
        return n;
    }

    public int getCurrentRowNumber() {
        int n = -1;
        if (this.values != null) {
            n = 0;
        }
        return n;
    }

    public void triggerUI() {
        if (this.triggerUIListeners == null || this.triggerUIListeners.size() == 0) {
            return;
        }
        Vector vector = null;
        TriggerUIEvent triggerUIEvent = new TriggerUIEvent(this.source, 0, 7);
        SingleRowBDSSupport singleRowBDSSupport = this;
        synchronized (singleRowBDSSupport) {
            vector = (Vector)this.triggerUIListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            ((TriggerUIListener)vector.elementAt(n)).commitUI(triggerUIEvent);
            ++n;
        }
    }

    public synchronized void setDataBinding(Name name) {
        if (this.triggerUIListeners != null) {
            if (hashBindNames.containsKey(name.getFullName())) {
                ((SingleRowBDSSupport)hashBindNames.get(name.getFullName())).reInitDataItem(name);
            }
            Vector vector = (Vector)this.triggerUIListeners.clone();
            int n = 0;
            while (n < vector.size()) {
                ((TriggerUIListener)vector.elementAt(n)).setDataBinding(name.getFullName());
                ++n;
            }
            hashBindNames.put(name.getFullName(), this);
        }
    }

    protected void reInitDataItem(Name name) {
        if (this.mediatorDS != null) {
            this.mediatorDS.killAll(name.getTableName());
        }
        hashBindNames.remove(name.getFullName());
    }
}

