/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import symantec.itools.db.beans.binding.Connection;
import symantec.itools.db.beans.binding.PersistentObject;
import symantec.itools.db.beans.binding.PersistentObjectModel;
import symantec.itools.db.beans.binding.Synchronizable;
import symantec.itools.db.beans.jdbc.ColumnMetaData;
import symantec.itools.db.beans.jdbc.DataModel;
import symantec.itools.db.beans.jdbc.JdbcResourceLoader;
import symantec.itools.db.beans.qbe.QBExlator;
import symantec.itools.db.beans.util.LocalizedValueGenerator;

public abstract class BaseRecordDefinition
implements PersistentObject {
    protected Vector m_OriginalValues;
    protected Vector m_ModifiedValues;
    private static JdbcResourceLoader resourceLoader = JdbcResourceLoader.getInstance();
    private static ResourceBundle MyResource = resourceLoader.getBundle();
    protected static final String TableSeparator = "@";
    protected static final String CLASS_NAME = "BaseRecordDefinition";
    protected static final String UNEXPECTED_ERROR = String.valueOf(MyResource.getString("BaseRecordDefinition_Unexpected")) + "BaseRecordDefinition" + ".";
    protected static final String OVERRIDDEN_ERROR = String.valueOf(MyResource.getString("BaseRecordDefinition_Overridden")) + "BaseRecordDefinition" + ".";
    protected static final String MISMATCH_RESULT_ERROR = MyResource.getString("BaseRecordDefinition_MismatchResult");
    protected static final String INVALID_DATATYPE_ERROR = MyResource.getString("BaseRecordDefinition_InvalidDatatype");
    protected static final String WRONG_DATE_ERROR = MyResource.getString("BaseRecordDefinition_WrongDate");
    protected static final String INVALID_SIZE = MyResource.getString("BaseRecordDefinition_InvalidSize");
    protected static final String IS = MyResource.getString("BaseRecordDefinition_Is");
    private boolean debug = false;
    protected RecordState recordState = new RecordState();
    protected boolean m_QBERow = false;

    public int getColumnIndex(String string) {
        if (string == null) {
            return -1;
        }
        int n = -1;
        int n2 = 0;
        ColumnMetaData columnMetaData = (ColumnMetaData)this.getDataModel().getMemberModel(n2);
        while (columnMetaData != null) {
            if (columnMetaData.getColumnName().equals(string)) {
                n = n2;
                break;
            }
            columnMetaData = (ColumnMetaData)this.getDataModel().getMemberModel(++n2);
        }
        if (n == -1) {
            String string2 = string.startsWith("[") && string.endsWith("]") ? string.substring(1, string.length() - 1) : (!string.startsWith("[") && !string.endsWith("]") ? "[" + string + "]" : string);
            n2 = 0;
            columnMetaData = (ColumnMetaData)this.getDataModel().getMemberModel(n2);
            while (columnMetaData != null) {
                if (columnMetaData.getColumnName().equals(string2)) {
                    n = n2;
                    break;
                }
                columnMetaData = (ColumnMetaData)this.getDataModel().getMemberModel(++n2);
            }
        }
        return n;
    }

    protected Number getNumberFromString(String string, int n) throws ParseException {
        return LocalizedValueGenerator.parseNumberValue(string, n);
    }

    protected java.util.Date getDateFromString(String string, int n) throws ParseException {
        return LocalizedValueGenerator.parseDateValue(string, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getDBObject(Object object, int n) throws NumberFormatException {
        String string = "getDBObject";
        Object object2 = null;
        try {
            if (object == null) {
                return null;
            }
            int n2 = this.getMemberModel(n).getDataType();
            switch (n2) {
                case -7: {
                    if (object instanceof String) {
                        return new Boolean((String)object);
                    }
                    if (object instanceof Object) {
                        return (Boolean)object;
                    }
                }
                case -6: {
                    if (object instanceof String) {
                        return new Short(this.getNumberFromString((String)object, n2).shortValue());
                    }
                    if (object instanceof Number) {
                        return new Short(((Number)object).shortValue());
                    }
                    if (object instanceof Object) {
                        return new Short(object.toString());
                    }
                }
                case 5: {
                    if (object instanceof String) {
                        return new Short(this.getNumberFromString((String)object, n2).shortValue());
                    }
                    if (object instanceof Number) {
                        return new Short(((Number)object).shortValue());
                    }
                    if (object instanceof Object) {
                        return (Short)object;
                    }
                }
                case -5: {
                    if (object instanceof String) {
                        return new Long(this.getNumberFromString((String)object, n2).longValue());
                    }
                    if (object instanceof Number) {
                        return new Long(((Number)object).longValue());
                    }
                    if (object instanceof Object) {
                        return (Long)object;
                    }
                }
                case 6: {
                    if (object instanceof String) {
                        return new Float(this.getNumberFromString((String)object, n2).floatValue());
                    }
                    if (object instanceof Number) {
                        return new Double(((Number)object).doubleValue());
                    }
                    if (object instanceof Object) {
                        return (Double)object;
                    }
                }
                case 8: {
                    if (object instanceof String) {
                        return new Double(this.getNumberFromString((String)object, n2).doubleValue());
                    }
                    if (object instanceof Number) {
                        return new Double(((Number)object).doubleValue());
                    }
                    if (object instanceof Object) {
                        return (Double)object;
                    }
                }
                case 7: {
                    if (object instanceof String) {
                        return new Float(this.getNumberFromString((String)object, n2).floatValue());
                    }
                    if (object instanceof Number) {
                        return new Float(((Number)object).floatValue());
                    }
                    if (object instanceof Object) {
                        return (Float)object;
                    }
                }
                case 4: {
                    if (object instanceof String) {
                        return new Integer(this.getNumberFromString((String)object, n2).intValue());
                    }
                    if (object instanceof Integer) {
                        return object;
                    }
                    if (object instanceof Number) {
                        return new Integer(((Number)object).intValue());
                    }
                    if (object instanceof Object) {
                        return (Integer)object;
                    }
                }
                case 1: {
                    if (object instanceof String) {
                        int n3 = ((DataModel)this.getDataModel()).getColumnMetaData(n).getColumnDisplaySize();
                        if (n3 >= ((String)object).length()) return object;
                        throw new NumberFormatException(String.valueOf(INVALID_SIZE) + (n + 1) + IS + n3);
                    }
                    if (object instanceof Object) {
                        return (String)object;
                    }
                }
                case 12: {
                    int n4 = ((DataModel)this.getDataModel()).getColumnMetaData(n).getColumnDisplaySize();
                    if (n4 >= ((String)object).length()) return (String)object;
                    throw new NumberFormatException(String.valueOf(INVALID_SIZE) + (n + 1) + IS + n4);
                }
                case -1: {
                    return object;
                }
                case -2: {
                    if (!(object instanceof String)) return object;
                    return ((String)object).getBytes();
                }
                case -3: {
                    if (!(object instanceof String)) return object;
                    return ((String)object).getBytes();
                }
                case -4: {
                    return object;
                }
                case 2: {
                    if (object instanceof BigDecimal) {
                        return (BigDecimal)object;
                    }
                    if (object instanceof String) {
                        Number number = this.getNumberFromString((String)object, n2);
                        return new BigDecimal(number.toString());
                    }
                    if (object instanceof Number) {
                        return new BigDecimal(((Number)object).toString());
                    }
                    if (object instanceof Object) {
                        return (BigDecimal)object;
                    }
                }
                case 3: {
                    if (object instanceof BigDecimal) {
                        return (BigDecimal)object;
                    }
                    if (object instanceof String) {
                        Number number = this.getNumberFromString((String)object, n2);
                        return new BigDecimal(number.toString());
                    }
                    if (object instanceof Number) {
                        return new BigDecimal(((Number)object).toString());
                    }
                    if (object instanceof Object) {
                        return (BigDecimal)object;
                    }
                }
                case 91: {
                    if (object instanceof Date) {
                        return object;
                    }
                    if (object instanceof String) {
                        java.util.Date date = this.getDateFromString((String)object, n2);
                        if (date == null) return null;
                        return new Date(date.getTime());
                    }
                    if (!(object instanceof Object)) return object2;
                    return (Date)object;
                }
                case 92: {
                    if (object instanceof Time) {
                        return object;
                    }
                    if (object instanceof String) {
                        java.util.Date date = this.getDateFromString((String)object, n2);
                        if (date == null) return null;
                        return new Time(date.getTime());
                    }
                    if (!(object instanceof Object)) return object2;
                    return (Time)object;
                }
                case 93: {
                    if (object instanceof Timestamp) {
                        return object;
                    }
                    if (object instanceof String) {
                        java.util.Date date = this.getDateFromString((String)object, n2);
                        if (date == null) return null;
                        return new Timestamp(date.getTime());
                    }
                    if (!(object instanceof Object)) return object2;
                    return (Timestamp)object;
                }
                case 1111: {
                    return object;
                }
                default: {
                    return object2;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw numberFormatException;
        }
        catch (ClassCastException classCastException) {
            throw classCastException;
        }
        catch (ParseException parseException) {
            throw new NumberFormatException(parseException.getMessage());
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            throw new RecordDefinitionException(String.valueOf(UNEXPECTED_ERROR) + string);
        }
    }

    public String getDataName(String string) {
        String string2 = "getDataName";
        try {
            if (this.getDataModel() == null) {
                return "";
            }
            if (this.getDataModel().getMemberCount() == 0) {
                return "";
            }
            String string3 = String.valueOf(this.getDataModel().getModelName()) + TableSeparator;
            int n = 0;
            while (n < this.getDataModel().getMemberCount() - 1) {
                string3 = String.valueOf(string3) + this.getDataModel().getMemberModel(n).getName() + string;
                ++n;
            }
            string3 = String.valueOf(string3) + this.getDataModel().getMemberModel(n).getName();
            if (this.debug) {
                System.out.println(String.valueOf(string2) + ": " + string3);
            }
            return string3;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string2);
            throw new RecordDefinitionException(String.valueOf(UNEXPECTED_ERROR) + string2);
        }
    }

    public synchronized Object getValueAsObject(int n, int n2) {
        String string = "getValueAsObject";
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            switch (n2) {
                case 0: {
                    byteArrayInputStream = (ByteArrayInputStream)this.m_OriginalValues.elementAt(n);
                    break;
                }
                case 1: {
                    int n3 = this.getMemberModel(n).getDataType();
                    byteArrayInputStream = (ByteArrayInputStream)this.m_ModifiedValues.elementAt(n);
                    if (n3 == -4 && byteArrayInputStream != null && byteArrayInputStream instanceof ByteArrayOutputStream) {
                        ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)((Object)byteArrayInputStream);
                        byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(UNEXPECTED_ERROR) + string);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw arrayIndexOutOfBoundsException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            throw new RecordDefinitionException(String.valueOf(UNEXPECTED_ERROR) + string);
        }
        return byteArrayInputStream;
    }

    public String getValueAsString(int n, int n2) {
        String string = "getValueAsString";
        Object object = null;
        try {
            int n3 = this.getMemberModel(n).getDataType();
            object = this.getValueAsObject(n, n2);
            if (object == null) {
                object = new String();
            }
            if (n3 == -3 || n3 == -2) {
                byte[] byArray = (byte[])object;
                StringBuffer stringBuffer = null;
                int n4 = 0;
                while (n4 < byArray.length) {
                    stringBuffer.append(byArray[n4]);
                    ++n4;
                }
                object = stringBuffer;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw arrayIndexOutOfBoundsException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            throw new RecordDefinitionException(String.valueOf(UNEXPECTED_ERROR) + string);
        }
        return object.toString();
    }

    public void setValueAsInteger(int n, Integer n2) throws NumberFormatException {
        this.setValueAsObject(n, n2);
    }

    public void setValueAsString(int n, String string) throws NumberFormatException {
        this.setValueAsObject(n, string);
    }

    public synchronized void setValueAsObject(int n, Object object) throws NumberFormatException {
        String string = "setValueAsObject";
        if (n == -1) {
            return;
        }
        try {
            if (this.m_ModifiedValues == null) {
                this.m_ModifiedValues = new Vector(this.getDataModel().getMemberCount());
            }
            object = this.getDBObject(object, n);
            this.m_ModifiedValues.setElementAt(object, n);
            if (!this.equalsVector(this.m_OriginalValues, this.m_ModifiedValues)) {
                this.setMarkedAsModified(true);
                return;
            }
            if (this.getMarkedAsModified()) {
                this.recordState.setStateUndo(2);
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw arrayIndexOutOfBoundsException;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_ModifiedValues.setElementAt(object, n);
            throw numberFormatException;
        }
        catch (Exception exception) {
            this.errorTreaten(exception, string);
            throw new RecordDefinitionException(String.valueOf(UNEXPECTED_ERROR) + string);
        }
    }

    public void initDataStorage() {
        int n = this.getDataModel().getMemberCount();
        this.m_OriginalValues = new Vector(n);
        this.m_ModifiedValues = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            this.m_OriginalValues.addElement(null);
            this.m_ModifiedValues.addElement(null);
            ++n2;
        }
    }

    void bringUpToDate() {
        Enumeration enumeration = this.m_ModifiedValues.elements();
        this.m_OriginalValues = new Vector();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.m_OriginalValues.addElement(e);
        }
        this.setMarkedAsModified(false);
    }

    public synchronized void undoChanges() {
        Enumeration enumeration = this.m_OriginalValues.elements();
        this.m_ModifiedValues = new Vector();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.m_ModifiedValues.addElement(e);
        }
        this.setMarkedAsModified(false);
        this.setMarkedAsDeleted(false);
        this.setMarkedAsDisplaced(false);
    }

    public Integer[] getModifiedColumns() {
        int n;
        Object[] objectArray = null;
        if (this.m_OriginalValues == null && this.m_ModifiedValues == null) {
            return objectArray;
        }
        int n2 = this.m_OriginalValues.size();
        if (n2 != (n = this.m_ModifiedValues.size())) {
            return objectArray;
        }
        Vector<Integer> vector = new Vector<Integer>();
        int n3 = 0;
        while (n3 < n2) {
            if (!this.equalsColumn(this.m_OriginalValues, n3, this.m_ModifiedValues)) {
                vector.addElement(new Integer(n3));
            }
            ++n3;
        }
        objectArray = new Integer[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private synchronized boolean equalsVector(Vector vector, Vector vector2) {
        int n;
        boolean bl = true;
        if (vector == null && vector2 == null) {
            return true;
        }
        if (vector == null && vector2 != null || vector != null && vector2 == null) {
            return false;
        }
        int n2 = vector.size();
        if (n2 != (n = vector2.size())) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            boolean bl2 = bl = bl && this.equalsColumn(vector, n3, vector2);
            if (!bl) break;
            ++n3;
        }
        return bl;
    }

    private boolean equalsColumn(Vector vector, int n, Vector vector2) {
        Object e = vector.elementAt(n);
        Object e2 = vector2.elementAt(n);
        try {
            if (e == null && e2 == null) {
                return true;
            }
            if (e == null && e2 != null) {
                return e2.equals(e);
            }
            if (e != null && e2 == null) {
                return e.equals(e2);
            }
            if (e != null && e2 != null) {
                return e2.toString().equals(e.toString());
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    ColumnMetaData getMemberModel(int n) {
        return (ColumnMetaData)this.getDataModel().getMemberModel(n);
    }

    abstract Object getObjectFromResultSet(int var1, ResultSet var2) throws SQLException;

    protected void errorTreaten(Exception exception, String string) {
        String string2 = "errorTreaten";
        throw new RuntimeException(String.valueOf(OVERRIDDEN_ERROR) + string2);
    }

    public Hashtable toHashtable() {
        String string = "toHashtable";
        throw new RuntimeException(String.valueOf(OVERRIDDEN_ERROR) + string);
    }

    public void resetState() {
        this.recordState.reset();
        Enumeration enumeration = this.m_ModifiedValues.elements();
        this.m_OriginalValues = new Vector();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.m_OriginalValues.addElement(e);
        }
    }

    public void undoColumnChanges(int n) {
        this.setValueAsObject(n, this.getValueAsObject(n, 0));
    }

    public int getOperation() {
        return this.recordState.getOperation();
    }

    public synchronized void setMarkedAsNew(boolean bl) {
        try {
            if (bl) {
                this.recordState.setState(1);
                return;
            }
            this.recordState.setStateUndo(1);
            return;
        }
        catch (RecordState.StateException stateException) {
            throw new RecordDefinitionException("The row was found in a invalid state");
        }
    }

    public synchronized boolean getMarkedAsNew() {
        return this.recordState.getExternalState() == 110;
    }

    public synchronized void setMarkedAsDeleted(boolean bl) {
        try {
            if (bl) {
                this.recordState.setState(4);
                return;
            }
            this.recordState.setStateUndo(4);
            return;
        }
        catch (RecordState.StateException stateException) {
            throw new RecordDefinitionException("The row was found in a invalid state");
        }
    }

    public boolean getMarkedAsDeleted() {
        return this.recordState.getExternalState() == 112;
    }

    public synchronized void setMarkedAsDisplaced(boolean bl) {
        try {
            if (bl) {
                this.recordState.setState(8);
                return;
            }
            this.recordState.setStateUndo(8);
            return;
        }
        catch (RecordState.StateException stateException) {
            throw new RecordDefinitionException("The row was found in a invalid state");
        }
    }

    public boolean getMarkedAsMisplaced() {
        return this.recordState.isMisplaced();
    }

    public synchronized void setMarkedAsQBE(boolean bl) {
        this.m_QBERow = true;
    }

    public boolean getMarkedAsQBE() {
        return this.m_QBERow;
    }

    public synchronized void setMarkedAsModified(boolean bl) {
        try {
            if (bl) {
                this.recordState.setState(2);
                return;
            }
            this.recordState.setStateUndo(2);
            return;
        }
        catch (RecordState.StateException stateException) {
            throw new RecordDefinitionException("The row was found in a invalid state");
        }
    }

    public synchronized boolean getMarkedAsModified() {
        return this.recordState.getExternalState() == 111;
    }

    public boolean isDirty() {
        return !this.equalsVector(this.m_OriginalValues, this.m_ModifiedValues) || this.recordState.getExternalState() != 109;
    }

    public boolean isOperationNothing() {
        return this.recordState.getOperation() == 13;
    }

    public void close() {
    }

    public abstract Connection getConnection();

    public abstract Enumeration querySimilarObjects();

    public abstract Enumeration querySimilarObjects(String var1, String[] var2) throws Exception;

    public abstract Enumeration querySimilarObjects(String var1, Synchronizable.JoinRecordList var2, String[] var3) throws Exception;

    public abstract int save();

    public abstract PersistentObjectModel getDataModel();

    public abstract String getStatement();

    public abstract void getQBEObjectValues(Vector var1);

    public abstract void setValueAsQBE(int var1, Object var2, boolean var3);

    public abstract void checkQBEValues() throws QBExlator.QBExlatException;

    public abstract void setSQLAdapter(Object var1);

    public class RecordDefinitionException
    extends PersistentObject.RecordException {
        String message;

        RecordDefinitionException(String string) {
            BaseRecordDefinition.this = BaseRecordDefinition.this;
            new RuntimeException(string);
            this.message = string;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class RecordState {
        public static final int ORIGINAL = 0;
        public static final int INSERTED = 1;
        public static final int MODIFIED = 2;
        public static final int DELETED = 4;
        public static final int MISPLACED = 8;
        public static final int INSERTED_MODIFIED = 3;
        public static final int INSERTED_DELETED = 5;
        public static final int MODIFIED_DELETED = 6;
        public static final int INSERTED_MODIFIED_DELETED = 7;
        public static final int NUMBER_OF_STATES = 4;
        public static final int FIRST_VALUE = 0;
        public static final int LAST_VALUE = 15;
        public static final int EXISTING_STATE = 109;
        public static final int INSERTED_STATE = 110;
        public static final int MODIFIED_STATE = 111;
        public static final int DELETED_STATE = 112;
        public static final int INSERTED_MISPLACED = 113;
        public static final int MODIFIED_MISPLACED = 114;
        int state = 0;

        RecordState() {
        }

        synchronized void reset() {
            this.state = 0;
        }

        public boolean equals(RecordState recordState) {
            return recordState.state == this.state;
        }

        int getOperation() throws StateException {
            int n = 13;
            int n2 = this.state >= 8 ? this.state - 8 : this.state;
            switch (n2) {
                case 0: {
                    n = 13;
                    break;
                }
                case 1: {
                    n = 14;
                    break;
                }
                case 2: {
                    n = 15;
                    break;
                }
                case 3: {
                    n = 14;
                    break;
                }
                case 4: {
                    n = 16;
                    break;
                }
                case 5: {
                    n = 13;
                    break;
                }
                case 6: {
                    n = 16;
                    break;
                }
                case 7: {
                    n = 13;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid call to getOperation()");
                }
            }
            return n;
        }

        synchronized void setState(int n) throws StateException {
            int n2 = 0;
            if ((this.state & n) > 0) {
                return;
            }
            if (this.state == 4 && n == 2) {
                return;
            }
            if ((this.state & 2) == 0 && n == 8) {
                throw new StateException("Invalid try to set the State of the Record to MISPLACED.");
            }
            n2 = this.state + n;
            if (n2 > 15 || n2 < 0) {
                throw new StateException("Invalid try to set the State");
            }
            this.state += n;
        }

        synchronized void setStateUndo(int n) throws StateException {
            int n2 = 0;
            if ((this.state & n) <= 0) {
                return;
            }
            n2 = this.state - n;
            if (n2 > 15 || n2 < 0) {
                throw new StateException("Invalid try to set the State");
            }
            this.state = n2;
        }

        boolean isMisplaced() {
            return (this.state & 8) > 0;
        }

        int getExternalState() {
            int n;
            int n2 = this.state >= 8 ? this.state - 8 : this.state;
            switch (n2) {
                case 0: {
                    n = 109;
                    break;
                }
                case 1: {
                    n = 110;
                    break;
                }
                case 2: {
                    n = 111;
                    break;
                }
                case 3: {
                    n = 110;
                    break;
                }
                case 4: {
                    n = 112;
                    break;
                }
                case 5: {
                    n = 112;
                    break;
                }
                case 6: {
                    n = 112;
                    break;
                }
                case 7: {
                    n = 112;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid try to call getState");
                }
            }
            return n;
        }

        class StateException
        extends RuntimeException {
            StateException(String string) {
                super(string);
                RecordState.this = RecordState.this;
            }
        }
    }
}

