/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.jdbc;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class ResultSetHelper
implements Serializable {
    protected ResultSetHelper() {
    }

    public static Object getObject(ResultSet resultSet, int n) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnType(n);
        return ResultSetHelper.getObject(resultSet, n, n2);
    }

    public static Object getObject(ResultSet resultSet, int n, int n2) throws SQLException {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        Object object = null;
        switch (n2) {
            case -7: {
                boolean bl = resultSet.getBoolean(n);
                object = new Boolean(bl);
                break;
            }
            case -6: {
                try {
                    byte by = resultSet.getByte(n);
                    object = new Byte(by);
                }
                catch (SQLException sQLException) {
                    String string = resultSet.getString(n);
                    object = new Byte(string);
                }
                break;
            }
            case 5: {
                try {
                    short s = resultSet.getShort(n);
                    object = new Short(s);
                }
                catch (SQLException sQLException) {
                    String string = resultSet.getString(n);
                    object = new Short(string);
                }
                break;
            }
            case 4: {
                try {
                    int n3 = resultSet.getInt(n);
                    object = new Integer(n3);
                }
                catch (SQLException sQLException) {
                    String string = resultSet.getString(n);
                    object = new Integer(string);
                }
                break;
            }
            case -5: {
                try {
                    long l = resultSet.getLong(n);
                    object = new Long(l);
                }
                catch (SQLException sQLException) {
                    String string = resultSet.getString(n);
                    object = new Long(string);
                }
                break;
            }
            case 6: 
            case 7: {
                try {
                    float f = resultSet.getFloat(n);
                    object = new Float(f);
                }
                catch (SQLException sQLException) {
                    String string = resultSet.getString(n);
                    object = new Float(string);
                }
                break;
            }
            case 8: {
                try {
                    double d = resultSet.getDouble(n);
                    object = new Double(d);
                }
                catch (SQLException sQLException) {
                    String string = resultSet.getString(n);
                    object = new Double(string);
                }
                break;
            }
            case 2: 
            case 3: {
                try {
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int n4 = resultSetMetaData.getScale(n);
                    object = resultSet.getBigDecimal(n, n4);
                }
                catch (SQLException sQLException) {
                    String string = resultSet.getString(n);
                    object = new BigDecimal(string);
                }
                break;
            }
            case 1: 
            case 12: {
                object = resultSet.getString(n);
                break;
            }
            case -1: {
                object = ResultSetHelper.getLongVarChar(resultSet, n);
                break;
            }
            case 91: {
                object = resultSet.getDate(n);
                break;
            }
            case 92: {
                object = resultSet.getTime(n);
                break;
            }
            case 93: {
                object = resultSet.getTimestamp(n);
                break;
            }
            case -3: 
            case -2: {
                object = resultSet.getBytes(n);
                break;
            }
            case -4: {
                InputStream inputStream = resultSet.getBinaryStream(n);
                if (inputStream == null) break;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[4096];
                int n5 = -1;
                try {
                    while ((n5 = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n5);
                    }
                    byteArrayOutputStream.flush();
                    ((OutputStream)byteArrayOutputStream).close();
                    inputStream.close();
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException.toString());
                }
                object = byteArrayOutputStream;
                break;
            }
            case 0: {
                object = null;
                break;
            }
            default: {
                object = resultSet.getObject(n);
            }
        }
        return object;
    }

    protected static String getLongVarChar(ResultSet resultSet, int n) throws SQLException {
        String string = null;
        Object object = resultSet.getClass().getName().equals("symantec.itools.db.jdbc.ResultSet") ? resultSet.getAsciiStream(n) : resultSet.getObject(n);
        if (object != null) {
            if (object instanceof String) {
                string = (String)object;
            } else if (object instanceof InputStream) {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[4096];
                try {
                    int n2;
                    while ((n2 = bufferedReader.read(cArray, 0, cArray.length)) != -1) {
                        stringBuffer.append(cArray, 0, n2);
                    }
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException.toString());
                }
                string = stringBuffer.toString();
            } else {
                string = object.toString();
            }
        }
        return string;
    }
}

