/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.beans.util;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import symantec.itools.db.beans.util.NumberConverter;
import symantec.itools.db.beans.util.UtilResourceLoader;

public class LocalizedValueGenerator {
    public static final boolean PERFORM_LOCALIZATION = true;
    public static final boolean debug = false;
    private static UtilResourceLoader resourceLoader;
    private static ResourceBundle MyResource;
    private static DecimalFormat defDecimalFormat;
    private static Locale defLocale;
    private static DateFormat defDateFormat;
    private static DateFormat defTimeFormat;
    private static DateFormat defDateTimeFormat;
    private static String PARSE_EXCP_MESSAGE;
    private static int defFractionDigits;
    private static final int DEFAULT_VALUES = 100;
    private static final char ZERO_CHAR = '0';
    private static final char NBS_CHAR = '\u00a0';
    private static final int START_POS = 0;
    private static final String INT_ZERO_STRING = "0";
    private static String DEC_ZERO_STRING;
    private static Vector styleVector;
    private static NumberConverter numberConv;

    static {
        DEC_ZERO_STRING = "";
        styleVector = new Vector();
        numberConv = new NumberConverter();
        resourceLoader = UtilResourceLoader.getInstance();
        MyResource = resourceLoader.getBundle();
        defLocale = Locale.getDefault();
        defDecimalFormat = (DecimalFormat)NumberFormat.getNumberInstance(defLocale);
        defFractionDigits = ((NumberFormat)defDecimalFormat).getMaximumFractionDigits();
        defDateFormat = DateFormat.getDateInstance();
        defTimeFormat = DateFormat.getTimeInstance();
        defDateTimeFormat = DateFormat.getDateTimeInstance();
        LocalizedValueGenerator.initializeStyleVector();
        PARSE_EXCP_MESSAGE = MyResource.getString("Parse Exception while converting string to number");
        DEC_ZERO_STRING = String.valueOf(DEC_ZERO_STRING) + '0';
        DEC_ZERO_STRING = String.valueOf(DEC_ZERO_STRING) + defDecimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
        DEC_ZERO_STRING = String.valueOf(DEC_ZERO_STRING) + '0';
    }

    private LocalizedValueGenerator() {
    }

    public static synchronized Object formatValue(Object object, boolean bl) {
        Object object2 = null;
        if (LocalizedValueGenerator.isObjToBeLocalized(object)) {
            try {
                if (LocalizedValueGenerator.isObjOfNumberType(object)) {
                    if (object != null) {
                        ((NumberFormat)defDecimalFormat).setGroupingUsed(bl);
                        if (object instanceof Float) {
                            Float f = (Float)object;
                            int n = LocalizedValueGenerator.getScaleForNumber(f);
                            ((NumberFormat)defDecimalFormat).setMaximumFractionDigits(n);
                            object2 = defDecimalFormat.format(f.floatValue());
                            ((NumberFormat)defDecimalFormat).setMaximumFractionDigits(defFractionDigits);
                        } else if (object instanceof Double) {
                            Double d = (Double)object;
                            int n = LocalizedValueGenerator.getScaleForNumber(d);
                            ((NumberFormat)defDecimalFormat).setMaximumFractionDigits(n);
                            object2 = defDecimalFormat.format(d);
                            ((NumberFormat)defDecimalFormat).setMaximumFractionDigits(defFractionDigits);
                        } else if (object instanceof BigDecimal) {
                            BigDecimal bigDecimal = (BigDecimal)object;
                            int n = LocalizedValueGenerator.getScaleForNumber(bigDecimal);
                            ((NumberFormat)defDecimalFormat).setMaximumFractionDigits(n);
                            object2 = defDecimalFormat.format(bigDecimal.doubleValue());
                            ((NumberFormat)defDecimalFormat).setMaximumFractionDigits(defFractionDigits);
                        } else if (object instanceof Short) {
                            Short s = (Short)object;
                            object2 = defDecimalFormat.format(s.longValue());
                        } else if (object instanceof Integer) {
                            Integer n = (Integer)object;
                            object2 = defDecimalFormat.format(n.longValue());
                        } else if (object instanceof Long) {
                            Long l = (Long)object;
                            object2 = defDecimalFormat.format(l);
                        } else {
                            BigDecimal bigDecimal = new BigDecimal(object.toString());
                            int n = LocalizedValueGenerator.getScaleForNumber(bigDecimal);
                            ((NumberFormat)defDecimalFormat).setMaximumFractionDigits(n);
                            object2 = defDecimalFormat.format(bigDecimal.doubleValue());
                            ((NumberFormat)defDecimalFormat).setMaximumFractionDigits(defFractionDigits);
                        }
                    }
                } else if (LocalizedValueGenerator.isObjOfDateType(object)) {
                    LocalizedValueGenerator.changeStyleOfDate(1);
                    if (object != null) {
                        if (object instanceof Date) {
                            Date date = (Date)object;
                            object2 = defDateFormat.format(date);
                        } else if (object instanceof Time) {
                            Time time = (Time)object;
                            object2 = defTimeFormat.format(time);
                        } else if (object instanceof Timestamp) {
                            Timestamp timestamp = (Timestamp)object;
                            object2 = defDateTimeFormat.format(timestamp);
                        }
                    }
                    LocalizedValueGenerator.changeStyleOfDate(100);
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        } else {
            object2 = object;
        }
        return object2;
    }

    public static synchronized boolean isObjToBeLocalized(Object object) {
        boolean bl = false;
        if (LocalizedValueGenerator.isObjOfNumberType(object) || LocalizedValueGenerator.isObjOfDateType(object)) {
            bl = true;
        }
        return bl;
    }

    public static synchronized Number parseNumberValue(String string, int n) throws ParseException {
        Object object;
        Number number = null;
        boolean bl = true;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        boolean bl3 = false;
        if (string.length() == 0) {
            bl3 = true;
            string3 = LocalizedValueGenerator.isNumberOfIntegerType(n) ? INT_ZERO_STRING : "0.0";
        } else {
            string3 = string;
        }
        String string4 = LocalizedValueGenerator.formatNumber(string3);
        Number number2 = defDecimalFormat.parse(string4);
        switch (n) {
            case -6: 
            case 5: {
                number = new Short(number2.shortValue());
                break;
            }
            case -5: {
                number = new Long(number2.longValue());
                break;
            }
            case 4: {
                number = new Integer(number2.intValue());
                break;
            }
            case 7: {
                if (bl3) {
                    number = new Float(number2.floatValue());
                    break;
                }
                string2 = numberConv.form(number2.doubleValue());
                number = new Float(string2);
                bl2 = true;
                break;
            }
            case 2: 
            case 3: {
                if (bl3) {
                    number = new BigDecimal(number2.doubleValue());
                    break;
                }
                string2 = numberConv.form(number2.doubleValue());
                number = new BigDecimal(string2);
                bl2 = true;
                break;
            }
            default: {
                if (bl3) {
                    number = new Double(number2.doubleValue());
                    break;
                }
                string2 = numberConv.form(number2.doubleValue());
                number = new Double(string2);
                bl2 = true;
            }
        }
        if (!(bl3 || (object = LocalizedValueGenerator.formatValue(number, false)).equals(INT_ZERO_STRING) || object.equals(DEC_ZERO_STRING))) {
            String string5 = LocalizedValueGenerator.prepareOldValueForComparision(string4, bl, bl2);
            String string6 = LocalizedValueGenerator.prepareNewValueForComparision(object.toString());
            string6 = LocalizedValueGenerator.prepareOldValueForComparision(string6, bl, bl2);
            if (!LocalizedValueGenerator.isScientificNotation(string5) && !string5.equals(string6)) {
                throw new ParseException(PARSE_EXCP_MESSAGE, 0);
            }
        }
        return number;
    }

    public static String formatNumber(String string) {
        int n;
        String string2 = string.toUpperCase();
        int n2 = string2.indexOf(defDecimalFormat.getDecimalFormatSymbols().getDecimalSeparator());
        char c = defDecimalFormat.getDecimalFormatSymbols().getGroupingSeparator();
        if (Character.isSpaceChar(c)) {
            string2 = LocalizedValueGenerator.replaceSpaceWithNBS(string2);
        }
        if (!LocalizedValueGenerator.isScientificNotation(string2)) {
            n = string2.length();
            if (n2 > -1) {
                while (n - 1 == string2.lastIndexOf(48)) {
                    string2 = string2.substring(0, n - 1);
                    n = string2.length();
                }
            }
        }
        if ((n = string2.lastIndexOf(69)) > -1 && n < string2.length() - 2 && string2.charAt(n + 1) == '+') {
            string2 = String.valueOf(string2.substring(0, n + 1)) + string2.substring(n + 2, string2.length());
        }
        while (n > -1 && n < string2.length() - 2 && string2.charAt(n + 1) == '0') {
            string2 = String.valueOf(string2.substring(0, n + 1)) + string2.substring(n + 2, string2.length());
        }
        if (n2 > -1) {
            while (n > n2 + 1 && string2.charAt(n - 1) == '0') {
                string2 = String.valueOf(string2.substring(0, n - 1)) + string2.substring(n);
                n = string2.lastIndexOf(69);
            }
        }
        return string2;
    }

    public static synchronized java.util.Date parseDateValue(String string, int n) throws ParseException {
        return LocalizedValueGenerator.parseDateValue(string, n, 1);
    }

    public static synchronized boolean getLocalizationStatus() {
        return true;
    }

    protected static synchronized java.util.Date parseDateValue(String string, int n, int n2) throws ParseException {
        java.util.Date date;
        block26: {
            date = null;
            if (string == null || string.length() <= 0) break block26;
            try {
                switch (n) {
                    case 91: {
                        try {
                            date = Date.valueOf(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            try {
                                date = defDateFormat.parse(string);
                            }
                            catch (ParseException parseException) {
                                try {
                                    date = defDateTimeFormat.parse(string);
                                }
                                catch (ParseException parseException2) {
                                    date = defTimeFormat.parse(string);
                                }
                            }
                        }
                        break;
                    }
                    case 92: {
                        try {
                            date = Time.valueOf(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            try {
                                date = defTimeFormat.parse(string);
                            }
                            catch (ParseException parseException) {
                                try {
                                    date = defDateTimeFormat.parse(string);
                                }
                                catch (ParseException parseException3) {
                                    date = defDateFormat.parse(string);
                                }
                            }
                        }
                        break;
                    }
                    case 93: {
                        try {
                            date = Timestamp.valueOf(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            try {
                                date = defDateTimeFormat.parse(string);
                            }
                            catch (ParseException parseException) {
                                try {
                                    date = defDateFormat.parse(string);
                                }
                                catch (ParseException parseException4) {
                                    date = defTimeFormat.parse(string);
                                }
                            }
                        }
                        break;
                    }
                }
                LocalizedValueGenerator.initializeStyleVector();
                LocalizedValueGenerator.changeStyleOfDate(100);
            }
            catch (ParseException parseException) {
                if (styleVector.isEmpty()) {
                    LocalizedValueGenerator.initializeStyleVector();
                    LocalizedValueGenerator.changeStyleOfDate(100);
                    throw parseException;
                }
                int n3 = (Integer)styleVector.elementAt(0);
                styleVector.removeElementAt(0);
                LocalizedValueGenerator.changeStyleOfDate(n3);
                date = LocalizedValueGenerator.parseDateValue(string, n, n3);
            }
        }
        return date;
    }

    protected static synchronized Number getNumberFromString(String string, int n) {
        Number number = null;
        return number;
    }

    protected static synchronized boolean isObjOfNumberType(Object object) {
        boolean bl = false;
        if (object instanceof Number) {
            bl = true;
        }
        return bl;
    }

    protected static synchronized boolean isObjOfDateType(Object object) {
        boolean bl = false;
        if (object instanceof Date || object instanceof Time || object instanceof Timestamp) {
            bl = true;
        }
        return bl;
    }

    protected static synchronized java.util.Date getDateFromString(String string, int n) {
        java.util.Date date = null;
        return date;
    }

    protected static synchronized void changeStyleOfDate(int n) {
        if (n == 100) {
            defDateFormat = DateFormat.getDateInstance();
            defTimeFormat = DateFormat.getTimeInstance();
            defDateTimeFormat = DateFormat.getDateTimeInstance();
            return;
        }
        defDateFormat = DateFormat.getDateInstance(n, defLocale);
        defTimeFormat = DateFormat.getTimeInstance(n, defLocale);
        defDateTimeFormat = DateFormat.getDateTimeInstance(n, n, defLocale);
    }

    protected static synchronized void initializeStyleVector() {
        styleVector.removeAllElements();
        styleVector.addElement(new Integer(0));
        styleVector.addElement(new Integer(1));
        styleVector.addElement(new Integer(2));
        styleVector.addElement(new Integer(3));
    }

    protected static synchronized String prepareOldValueForComparision(String string, boolean bl, boolean bl2) {
        int n;
        String string2 = LocalizedValueGenerator.stripGroupingSep(string);
        if (bl) {
            while (string2.indexOf(48) == 0) {
                n = string2.indexOf(48);
                string2 = string2.substring(n + 1, string2.length());
            }
        }
        n = string2.length();
        char c = defDecimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
        if (bl2 && !LocalizedValueGenerator.isScientificNotation(string2) && string2.indexOf(c) != -1) {
            while (n - 1 == string2.lastIndexOf(48)) {
                string2 = string2.substring(0, n - 1);
                n = string2.length();
            }
        }
        if (n - 1 == string2.lastIndexOf(c)) {
            string2 = string2.substring(0, n - 1);
            n = string2.length();
        }
        if (string2.length() > 0) {
            if (c == string2.charAt(0)) {
                string2 = String.valueOf('0') + string2;
            }
        } else {
            string2 = "";
            string2 = String.valueOf(string2) + '0';
        }
        return string2;
    }

    protected static synchronized String prepareNewValueForComparision(String string) {
        String string2 = "";
        char c = defDecimalFormat.getDecimalFormatSymbols().getGroupingSeparator();
        string2 = string.length() > 0 ? (c == string.charAt(0) ? String.valueOf('0') + string : string) : String.valueOf(string2) + '0';
        return string2;
    }

    protected static synchronized String stripGroupingSep(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            char c = defDecimalFormat.getDecimalFormatSymbols().getGroupingSeparator();
            int n = 0;
            while (n < string.length()) {
                char c2 = string.charAt(n);
                if (c2 != c) {
                    stringBuffer.append(c2);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    protected static synchronized int getScaleForNumber(Number number) {
        int n = defFractionDigits;
        if (number instanceof Float || number instanceof Double) {
            String string = number.toString().toUpperCase();
            if (!LocalizedValueGenerator.isNumber(string)) {
                n = 0;
                return n;
            }
            int n2 = string.indexOf(46);
            if (n2 == -1 || n2 == string.length() - 1) {
                n = 0;
            } else {
                String string2 = string.substring(n2 + 1);
                int n3 = string2.indexOf(69);
                if (n3 > -1) {
                    int n4 = 0;
                    if (n3 < string2.length() - 1) {
                        String string3 = string2.substring(n3 + 1);
                        try {
                            n4 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    n = n3 - n4;
                    n = Math.max(n, 0);
                } else {
                    n = string2.length();
                }
            }
        } else if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            n = bigDecimal.scale();
        }
        n = Math.min(n, 8);
        return n;
    }

    protected static synchronized boolean isScientificNotation(String string) {
        boolean bl = false;
        string = string.toUpperCase();
        int n = string.indexOf("E");
        int n2 = string.lastIndexOf("E");
        int n3 = string.indexOf(".");
        int n4 = string.lastIndexOf(".");
        int n5 = string.length() - 1;
        if (n > 0 && n == n2 && n2 < n5 && n3 == 1 && n3 == n4 && n4 < n5) {
            bl = LocalizedValueGenerator.isNumber(string);
        }
        return bl;
    }

    protected static synchronized boolean isNumber(String string) {
        boolean bl = true;
        string = string.toUpperCase();
        char c = defDecimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
        char c2 = defDecimalFormat.getDecimalFormatSymbols().getMinusSign();
        char c3 = '+';
        char c4 = defDecimalFormat.getDecimalFormatSymbols().getGroupingSeparator();
        if (Character.isSpaceChar(c4)) {
            c4 = '\u00a0';
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c5 = string.charAt(n2);
            if (!Character.isDigit(c5) && c5 != c && c5 != 'E' && c5 != c2 && c5 != c3 && c5 != c4) {
                bl = false;
                break;
            }
            ++n2;
        }
        return bl;
    }

    protected static String replaceSpaceWithNBS(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            int n = 0;
            while (n < string.length()) {
                char c = string.charAt(n);
                if (Character.isSpaceChar(c)) {
                    stringBuffer.append('\u00a0');
                } else {
                    stringBuffer.append(c);
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    protected static boolean isNumberOfIntegerType(int n) {
        boolean bl = false;
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                bl = true;
                break;
            }
        }
        return bl;
    }
}

