/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.compress;

import symantec.itools.db.compress.IByteBuffer;

public class CByteBuffer
implements IByteBuffer {
    private byte[] m_byBase;
    private int m_nOffset;

    public CByteBuffer(byte[] byArray) {
        this.Load(byArray);
    }

    public CByteBuffer(int n) {
        this.Load(new byte[n]);
    }

    public void Reset() {
        this.m_nOffset = 0;
    }

    public int Available() {
        return this.m_byBase.length - this.m_nOffset;
    }

    public int Used() {
        return this.m_nOffset;
    }

    public int Increment(int n) {
        this.m_nOffset += n;
        return this.m_nOffset;
    }

    public int Decrement(int n) {
        this.m_nOffset -= n;
        return this.m_nOffset;
    }

    public byte[] Get(int n) {
        byte[] byArray = new byte[n];
        this.Get(byArray, 0, n);
        return byArray;
    }

    public int Get(byte[] byArray, int n, int n2) {
        if (this.m_nOffset + n2 > this.m_byBase.length) {
            n2 = this.m_byBase.length - this.m_nOffset;
        }
        System.arraycopy(this.m_byBase, this.m_nOffset, byArray, n, n2);
        this.m_nOffset += n2;
        return n2;
    }

    public int Put(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this.m_byBase, this.m_nOffset, n2);
        this.m_nOffset += n2;
        return n2;
    }

    public void Load(byte[] byArray) {
        this.m_byBase = byArray;
        this.m_nOffset = 0;
    }
}

