/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.compress;

import symantec.itools.db.compress.CBitBuffer;
import symantec.itools.db.compress.CByteBuffer;
import symantec.itools.db.compress.CCodeDescriptor;
import symantec.itools.db.compress.CCodeTree;
import symantec.itools.db.compress.CZip;
import symantec.itools.db.compress.IBitBuffer;
import symantec.itools.db.compress.IByteBuffer;

public class CZipExpand {
    private static final byte[] sm_abyLenTable = new byte[]{2, 3, 3, 3, 7, 11};
    private static final int WINDOW_SIZE = 32768;
    private byte[] m_abyLookBack;
    private int m_nToPtr;
    private boolean m_fCompatible;
    private boolean m_fFixed;
    private CCodeDescriptor m_codedescBits;
    private CCodeDescriptor m_codedescLiteral;
    private CCodeDescriptor m_codedescDistance;
    private CCodeTree m_codetreeBits;
    private CCodeTree m_codetreeLiteral;
    private CCodeTree m_codetreeDistance;

    public void Initialize(boolean bl) {
        this.m_fCompatible = bl;
        this.m_abyLookBack = new byte[32768];
        this.m_nToPtr = 0;
        this.m_fFixed = false;
        this.m_codedescBits = new CCodeDescriptor(19);
        this.m_codedescLiteral = new CCodeDescriptor(288);
        this.m_codedescDistance = new CCodeDescriptor(32);
        this.m_codetreeLiteral = new CCodeTree(576);
        this.m_codetreeDistance = new CCodeTree(64);
        this.m_codetreeBits = new CCodeTree(0);
    }

    public int Expand(byte[] byArray, byte[] byArray2) {
        CBitBuffer cBitBuffer = new CBitBuffer(byArray);
        CByteBuffer cByteBuffer = new CByteBuffer(byArray2);
        return this.Expand(cBitBuffer, cByteBuffer);
    }

    /*
     * Unable to fully structure code
     */
    public int Expand(IBitBuffer var1_1, IByteBuffer var2_2) {
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = 0;
        if (this.m_fCompatible) {
            var1_1.Skip(16);
        }
        do {
            var6_6 = (int)var1_1.Get(3);
            var7_7 = var6_6 >>> 1;
            block0 : switch (var7_7) {
                case 0: {
                    var1_1.Skip(5);
                    var8_8 = (int)var1_1.Get(32);
                    var3_3 = var8_8 & 65535;
                    if ((var3_3 ^ ~var8_8 >>> 16) == 0) ** GOTO lbl31
                    return -1;
lbl-1000:
                    // 1 sources

                    {
                        var10_10 = var3_3;
                        var9_9 = 32768 - this.m_nToPtr;
                        if (var10_10 > var9_9) {
                            var10_10 = var9_9;
                        }
                        if (var10_10 == 0) {
                            return -1;
                        }
                        var1_1.GetBytes(this.m_abyLookBack, this.m_nToPtr, var10_10);
                        var2_2.Put(this.m_abyLookBack, this.m_nToPtr, var10_10);
                        this.m_nToPtr += var10_10;
                        if (this.m_nToPtr >= 32768) {
                            this.m_nToPtr = 0;
                        }
                        var3_3 -= var10_10;
lbl31:
                        // 2 sources

                        ** while (var3_3 != 0)
                    }
lbl32:
                    // 1 sources

                    break;
                }
                case 1: 
                case 2: {
                    if (var7_7 == 2) {
                        this.BuildDynamicTree(var1_1);
                    } else {
                        this.BuildFixedTree(var1_1);
                    }
                    while (true) {
                        if (((var5_5 = this.m_codetreeLiteral.Value(var9_9 = (int)var1_1.Peek(8))) & 32768) != 0) {
                            var1_1.Skip(8);
                            var5_5 = this.Decode(var1_1, this.m_codetreeLiteral, var5_5);
                        } else {
                            var1_1.Skip(this.m_codetreeLiteral.Length(var9_9));
                        }
                        if (var5_5 == 256) break block0;
                        if (var5_5 <= 256) ** GOTO lbl84
                        var3_3 = CZip.nLengthExtraCode[var5_5 - 257];
                        if (CZip.byLengthExtraBits[var5_5 - 257] != 0) {
                            var3_3 += (int)var1_1.Get(CZip.byLengthExtraBits[var5_5 - 257]);
                        }
                        if (((var5_5 = this.m_codetreeDistance.Value(var9_9 = (int)var1_1.Peek(8))) & 32768) != 0) {
                            var1_1.Skip(8);
                            var5_5 = this.Decode(var1_1, this.m_codetreeDistance, var5_5);
                        } else {
                            var1_1.Skip(this.m_codetreeDistance.Length(var9_9));
                        }
                        var4_4 = CZip.nDistanceExtraCode[var5_5];
                        if (CZip.byDistanceExtraBits[var5_5] != 0) {
                            var4_4 += (int)var1_1.Get(CZip.byDistanceExtraBits[var5_5]);
                        }
                        var10_10 = this.m_nToPtr - var4_4;
                        if (this.m_nToPtr < var4_4) {
                            var10_10 += 32768;
                        }
                        if (var10_10 >= this.m_nToPtr) ** GOTO lbl64
                        if (32768 - this.m_nToPtr > var3_3 && var10_10 + var3_3 <= this.m_nToPtr) ** GOTO lbl68
                        v0 = false;
                        ** GOTO lbl67
lbl64:
                        // 1 sources

                        if (32768 - var10_10 < var3_3) ** GOTO lbl73
                        if (this.m_nToPtr + var3_3 <= var10_10) ** GOTO lbl68
                        v0 = false;
lbl67:
                        // 2 sources

                        if (!v0) ** GOTO lbl73
lbl68:
                        // 3 sources

                        var2_2.Put(this.m_abyLookBack, var10_10, var3_3);
                        System.arraycopy(this.m_abyLookBack, var10_10, this.m_abyLookBack, this.m_nToPtr, var3_3);
                        this.m_nToPtr += var3_3;
                        continue;
lbl73:
                        // 2 sources

                        do {
                            var2_2.Put(this.m_abyLookBack, var10_10, 1);
                            this.m_abyLookBack[this.m_nToPtr] = this.m_abyLookBack[var10_10];
                            ++this.m_nToPtr;
                            if (this.m_nToPtr == 32768) {
                                this.m_nToPtr = 0;
                            }
                            if (++var10_10 != 32768) continue;
                            var10_10 = 0;
                        } while (--var3_3 != 0);
                        continue;
lbl84:
                        // 1 sources

                        this.m_abyLookBack[this.m_nToPtr] = (byte)var5_5;
                        var2_2.Put(this.m_abyLookBack, this.m_nToPtr, 1);
                        ++this.m_nToPtr;
                        if (this.m_nToPtr < 32768) continue;
                        this.m_nToPtr = 0;
                    }
                }
                case 3: {
                    return -1;
                }
            }
        } while ((var6_6 & 1) == 0);
        return var2_2.Used();
    }

    private void BuildDynamicTree(IBitBuffer iBitBuffer) {
        this.m_fFixed = false;
        int n = (int)iBitBuffer.Get(14);
        int n2 = (n & 0x1F) + 257;
        int n3 = ((n >>>= 5) & 0x1F) + 1;
        int n4 = ((n >>>= 5) & 0xF) + 4;
        this.m_codedescBits.Clear();
        int n5 = 0;
        n5 = 0;
        while (n5 < n4) {
            n = (int)iBitBuffer.Get(3);
            if (n != 0) {
                this.m_codedescBits.Set(CZip.byBitLengthValues[n5], (byte)n);
            }
            ++n5;
        }
        this.m_codetreeBits.Build(this.m_codedescBits, 19);
        this.m_codedescLiteral.Clear();
        this.m_codedescDistance.Clear();
        CCodeDescriptor cCodeDescriptor = this.m_codedescLiteral;
        int n6 = 0;
        int n7 = 0;
        int n8 = n2 + n3;
        n5 = 0;
        do {
            int n9 = (int)iBitBuffer.Peek(7);
            iBitBuffer.Skip(this.m_codetreeBits.Length(n9));
            n = this.m_codetreeBits.Value(n9);
            if (n < 16) {
                n7 = n;
                n = 1;
            } else {
                n9 = (n - 16) * 2;
                n = (int)iBitBuffer.Get(sm_abyLenTable[n9]);
                n += sm_abyLenTable[n9 + 1];
                if (n9 != 0) {
                    n7 = 0;
                }
            }
            if (n7 == 0) {
                n6 += n;
                if (cCodeDescriptor == this.m_codedescDistance || (n5 += n) < n2) continue;
                cCodeDescriptor = this.m_codedescDistance;
                n6 -= n2;
                continue;
            }
            do {
                cCodeDescriptor.Set(n6, (byte)n7);
                ++n6;
                if (cCodeDescriptor == this.m_codedescDistance || ++n5 != n2) continue;
                cCodeDescriptor = this.m_codedescDistance;
                n6 = 0;
            } while (--n != 0);
        } while (n5 < n8);
        this.m_codetreeLiteral.Build(this.m_codedescLiteral, n2);
        this.m_codetreeDistance.Build(this.m_codedescDistance, n3);
    }

    private void BuildFixedTree(IBitBuffer iBitBuffer) {
        if (this.m_fFixed) {
            return;
        }
        this.m_fFixed = true;
        this.m_codedescLiteral.Clear();
        int n = 288;
        int n2 = 8;
        do {
            if (n == 280) {
                n2 = 7;
            } else if (n == 256) {
                n2 = 9;
            } else if (n == 144) {
                n2 = 8;
            }
            this.m_codedescLiteral.Set(--n, (byte)n2);
        } while (n != 0);
        this.m_codetreeLiteral.Build(this.m_codedescLiteral, 288);
        this.m_codedescDistance.Clear();
        n = 32;
        do {
            this.m_codedescDistance.Set(--n, (byte)5);
        } while (n != 0);
        this.m_codetreeDistance.Build(this.m_codedescDistance, 32);
    }

    private int Decode(IBitBuffer iBitBuffer, CCodeTree cCodeTree, int n) {
        int n2 = n;
        int n3 = (int)iBitBuffer.Peek(7);
        int n4 = 0;
        n3 = (n3 | 0x80) << 1;
        while ((n3 >>>= 1) != 1) {
            ++n4;
            if (((n2 = cCodeTree.GetTree(n2, n3)) & 0x8000) != 0) continue;
            iBitBuffer.Skip(n4);
            break;
        }
        return n2;
    }
}

