/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.jdbc;

import java.io.EOFException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import symantec.itools.db.jdbc.PreparedStatement;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.Field;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NetString;
import symantec.itools.db.net.Param;

public final class CallableStatement
extends PreparedStatement
implements java.sql.CallableStatement {
    private final int METHOD_registerOutParameter = 0;
    private final int METHOD_registerOutParameterWithScale = 1;
    private final int METHOD_wasNull = 2;
    private final int METHOD_getString = 3;
    private final int METHOD_getBoolean = 4;
    private final int METHOD_getByte = 5;
    private final int METHOD_getShort = 6;
    private final int METHOD_getInt = 7;
    private final int METHOD_getLong = 8;
    private final int METHOD_getFloat = 9;
    private final int METHOD_getDouble = 10;
    private final int METHOD_getBigDecimal = 11;
    private final int METHOD_getBytes = 12;
    private final int METHOD_getDate = 13;
    private final int METHOD_getTime = 14;
    private final int METHOD_getTimestamp = 15;
    private final int METHOD_getObject = 16;

    protected int getNumberOfMethods() {
        return super.getNumberOfMethods() + 16 + 1;
    }

    CallableStatement(int n, ClientSession clientSession) throws SQLException {
        super(n, clientSession);
    }

    public void registerOutParameter(int n, int n2) throws SQLException {
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, n2));
        this.invokeMethod(super.getNumberOfMethods(), vector);
    }

    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, n2));
        vector.addElement(new Param(0, n3));
        this.invokeMethod(super.getNumberOfMethods() + 1, vector);
    }

    public boolean wasNull() throws SQLException {
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 2);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public String getString(int n) throws SQLException {
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 3, n);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public boolean getBoolean(int n) throws SQLException {
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 4, n);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public byte getByte(int n) throws SQLException {
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 5, n);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getByte();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public short getShort(int n) throws SQLException {
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 6, n);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getShort();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getInt(int n) throws SQLException {
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 7, n);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public long getLong(int n) throws SQLException {
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 8, n);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getLong();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public float getFloat(int n) throws SQLException {
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 9, n);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getFloat();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public double getDouble(int n) throws SQLException {
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 10, n);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getDouble();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, n2));
        Vector vector2 = this.invokeMethod(super.getNumberOfMethods() + 11, vector);
        NetString netString = (NetString)vector2.elementAt(0);
        return new BigDecimal(netString.getString());
    }

    public byte[] getBytes(int n) throws SQLException {
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 12, n);
        NetData netData = (NetData)vector.elementAt(0);
        return netData.getBytes();
    }

    public Date getDate(int n) throws SQLException {
        try {
            Vector vector = this.invokeMethod(super.getNumberOfMethods() + 13, n);
            NetData netData = (NetData)vector.elementAt(0);
            int n2 = netData.getInt();
            netData = (NetData)vector.elementAt(1);
            int n3 = netData.getInt() - 1;
            netData = (NetData)vector.elementAt(2);
            int n4 = netData.getInt();
            return new Date(n2, n3, n4);
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            Vector vector = this.invokeMethod(super.getNumberOfMethods() + 14, n);
            NetData netData = (NetData)vector.elementAt(0);
            int n2 = netData.getInt();
            netData = (NetData)vector.elementAt(1);
            int n3 = netData.getInt();
            netData = (NetData)vector.elementAt(2);
            int n4 = netData.getInt();
            return new Time(n2, n3, n4);
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            Vector vector = this.invokeMethod(super.getNumberOfMethods() + 15, n);
            NetData netData = (NetData)vector.elementAt(0);
            int n2 = netData.getInt();
            netData = (NetData)vector.elementAt(1);
            int n3 = netData.getInt() - 1;
            netData = (NetData)vector.elementAt(2);
            int n4 = netData.getInt();
            netData = (NetData)vector.elementAt(3);
            int n5 = netData.getInt();
            netData = (NetData)vector.elementAt(4);
            int n6 = netData.getInt();
            netData = (NetData)vector.elementAt(5);
            int n7 = netData.getInt();
            netData = (NetData)vector.elementAt(6);
            int n8 = netData.getInt();
            return new Timestamp(n2, n3, n4, n5, n6, n7, n8);
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public Object getObject(int n) throws SQLException {
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 16, n);
        Field field = (Field)vector.elementAt(0);
        return field.getObject();
    }
}

