/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.jdbc;

import java.io.EOFException;
import java.sql.SQLException;
import java.util.Vector;
import symantec.itools.db.jdbc.ProxyObject;
import symantec.itools.db.jdbc.ResultSet;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.Field;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NetString;
import symantec.itools.db.net.Param;
import symantec.itools.db.net.TextParam;

public final class DatabaseMetaData
extends ProxyObject
implements java.sql.DatabaseMetaData {
    private String _url;
    private final int METHOD_allProceduresAreCallable = 0;
    private final int METHOD_allTablesAreSelectable = 1;
    private final int METHOD_getURL = 2;
    private final int METHOD_getUserName = 3;
    private final int METHOD_isReadOnly = 4;
    private final int METHOD_nullsAreSortedHigh = 5;
    private final int METHOD_nullsAreSortedLow = 6;
    private final int METHOD_nullsAreSortedAtStart = 7;
    private final int METHOD_nullsAreSortedAtEnd = 8;
    private final int METHOD_getDatabaseProductName = 9;
    private final int METHOD_getDatabaseProductVersion = 10;
    private final int METHOD_getDriverName = 11;
    private final int METHOD_getDriverVersion = 12;
    private final int METHOD_getDriverMajorVersion = 13;
    private final int METHOD_getDriverMinorVersion = 14;
    private final int METHOD_usesLocalFiles = 15;
    private final int METHOD_usesLocalFilePerTable = 16;
    private final int METHOD_supportsMixedCaseIdentifiers = 17;
    private final int METHOD_storesUpperCaseIdentifiers = 18;
    private final int METHOD_storesLowerCaseIdentifiers = 19;
    private final int METHOD_storesMixedCaseIdentifiers = 20;
    private final int METHOD_supportsMixedCaseQuotedIdentifiers = 21;
    private final int METHOD_storesUpperCaseQuotedIdentifiers = 22;
    private final int METHOD_storesLowerCaseQuotedIdentifiers = 23;
    private final int METHOD_storesMixedCaseQuotedIdentifiers = 24;
    private final int METHOD_getIdentifierQuoteString = 25;
    private final int METHOD_getSQLKeywords = 26;
    private final int METHOD_getNumericFunctions = 27;
    private final int METHOD_getStringFunctions = 28;
    private final int METHOD_getSystemFunctions = 29;
    private final int METHOD_getTimeDateFunctions = 30;
    private final int METHOD_getSearchStringEscape = 31;
    private final int METHOD_getExtraNameCharacters = 32;
    private final int METHOD_supportsAlterTableWithAddColumn = 33;
    private final int METHOD_supportsAlterTableWithDropColumn = 34;
    private final int METHOD_supportsColumnAliasing = 35;
    private final int METHOD_nullPlusNonNullIsNull = 36;
    private final int METHOD_supportsConvert = 37;
    private final int METHOD_supportsConvert2 = 38;
    private final int METHOD_supportsTableCorrelationNames = 39;
    private final int METHOD_supportsDifferentTableCorrelationNames = 40;
    private final int METHOD_supportsExpressionsInOrderBy = 41;
    private final int METHOD_supportsOrderByUnrelated = 42;
    private final int METHOD_supportsGroupBy = 43;
    private final int METHOD_supportsGroupByUnrelated = 44;
    private final int METHOD_supportsGroupByBeyondSelect = 45;
    private final int METHOD_supportsLikeEscapeClause = 46;
    private final int METHOD_supportsMultipleResultSets = 47;
    private final int METHOD_supportsMultipleTransactions = 48;
    private final int METHOD_supportsNonNullableColumns = 49;
    private final int METHOD_supportsMinimumSQLGrammar = 50;
    private final int METHOD_supportsCoreSQLGrammar = 51;
    private final int METHOD_supportsExtendedSQLGrammar = 52;
    private final int METHOD_supportsIntegrityEnhancementFacility = 53;
    private final int METHOD_supportsOuterJoins = 54;
    private final int METHOD_supportsFullOuterJoins = 55;
    private final int METHOD_supportsLimitedOuterJoins = 56;
    private final int METHOD_getSchemaTerm = 57;
    private final int METHOD_getProcedureTerm = 58;
    private final int METHOD_getCatalogTerm = 59;
    private final int METHOD_isCatalogAtStart = 60;
    private final int METHOD_getCatalogSeparator = 61;
    private final int METHOD_supportsSchemasInDML = 62;
    private final int METHOD_supportsSchemasInProcedureCalls = 63;
    private final int METHOD_supportsSchemasInTableDefinitions = 64;
    private final int METHOD_supportsSchemasInIndexDefinitions = 65;
    private final int METHOD_supportsSchemasInPrivilegeDefinitions = 66;
    private final int METHOD_supportsCatalogsInDML = 67;
    private final int METHOD_supportsCatalogsInProcedureCalls = 68;
    private final int METHOD_supportsCatalogsInTableDefinitions = 69;
    private final int METHOD_supportsCatalogsInIndexDefinitions = 70;
    private final int METHOD_supportsCatalogsInPrivilegeDefinitions = 71;
    private final int METHOD_supportsPositionedDelete = 72;
    private final int METHOD_supportsPositionedUpdate = 73;
    private final int METHOD_supportsSelectForUpdate = 74;
    private final int METHOD_supportsStoredProcedures = 75;
    private final int METHOD_supportsSubqueriesInComparisons = 76;
    private final int METHOD_supportsSubqueriesInExists = 77;
    private final int METHOD_supportsSubqueriesInIns = 78;
    private final int METHOD_supportsSubqueriesInQuantifieds = 79;
    private final int METHOD_supportsCorrelatedSubqueries = 80;
    private final int METHOD_supportsUnion = 81;
    private final int METHOD_supportsUnionAll = 82;
    private final int METHOD_supportsOpenCursorsAcrossCommit = 83;
    private final int METHOD_supportsOpenCursorsAcrossRollback = 84;
    private final int METHOD_supportsOpenStatementsAcrossCommit = 85;
    private final int METHOD_supportsOpenStatementsAcrossRollback = 86;
    private final int METHOD_getMaxBinaryLiteralLength = 87;
    private final int METHOD_getMaxCharLiteralLength = 88;
    private final int METHOD_getMaxColumnNameLength = 89;
    private final int METHOD_getMaxColumnsInGroupBy = 90;
    private final int METHOD_getMaxColumnsInIndex = 91;
    private final int METHOD_getMaxColumnsInOrderBy = 92;
    private final int METHOD_getMaxColumnsInSelect = 93;
    private final int METHOD_getMaxColumnsInTable = 94;
    private final int METHOD_getMaxConnections = 95;
    private final int METHOD_getMaxCursorNameLength = 96;
    private final int METHOD_getMaxIndexLength = 97;
    private final int METHOD_getMaxSchemaNameLength = 98;
    private final int METHOD_getMaxProcedureNameLength = 99;
    private final int METHOD_getMaxCatalogNameLength = 100;
    private final int METHOD_getMaxRowSize = 101;
    private final int METHOD_doesMaxRowSizeIncludeBlobs = 102;
    private final int METHOD_getMaxStatementLength = 103;
    private final int METHOD_getMaxStatements = 104;
    private final int METHOD_getMaxTableNameLength = 105;
    private final int METHOD_getMaxTablesInSelect = 106;
    private final int METHOD_getMaxUserNameLength = 107;
    private final int METHOD_getDefaultTransactionIsolation = 108;
    private final int METHOD_supportsTransactions = 109;
    private final int METHOD_supportsTransactionIsolationLevel = 110;
    private final int METHOD_supportsDDLAndDMLTransactions = 111;
    private final int METHOD_supportsDMLTransactionsOnly = 112;
    private final int METHOD_dataDefinitionCausesTransactionCommit = 113;
    private final int METHOD_dataDefinitionIgnoredInTransactions = 114;
    private final int METHOD_getProcedures = 115;
    private final int METHOD_getProcedureColumns = 116;
    private final int METHOD_getTables = 117;
    private final int METHOD_getSchemas = 118;
    private final int METHOD_getCatalogs = 119;
    private final int METHOD_getTableTypes = 120;
    private final int METHOD_getColumns = 121;
    private final int METHOD_getColumnPrivileges = 122;
    private final int METHOD_getTablePrivileges = 123;
    private final int METHOD_getBestRowIdentifier = 124;
    private final int METHOD_getVersionColumns = 125;
    private final int METHOD_getPrimaryKeys = 126;
    private final int METHOD_getImportedKeys = 127;
    private final int METHOD_getExportedKeys = 128;
    private final int METHOD_getCrossReference = 129;
    private final int METHOD_getTypeInfo = 130;
    private final int METHOD_getIndexInfo = 131;
    private final int METHOD_supportsANSI92EntryLevelSQL = 132;
    private final int METHOD_supportsANSI92IntermediateLevelSQL = 133;
    private final int METHOD_supportsANSI92FullLevelSQL = 134;
    private Vector _resultsets;
    private boolean _isClosed = false;
    int procedureResultUnknown;
    int procedureNoResult = 1;
    int procedureReturnsResult = 2;
    int procedureColumnUnknown;
    int procedureColumnIn = 1;
    int procedureColumnInOut = 2;
    int procedureColumnResult = 3;
    int procedureColumnOut = 4;
    int procedureColumnReturn = 5;
    int bestRowTemporary;
    int bestRowTransaction = 1;
    int bestRowSession = 2;
    int bestRowUnknown;
    int bestRowNotPseudo = 1;
    int bestRowPseudo = 2;
    int versionColumnUnknown;
    int versionColumnNotPseudo = 1;
    int versionColumnPseudo = 2;
    int importedKeyCascade;
    int importedKeyRestrict = 1;
    int importedKeySetNull = 2;
    int typeUnSearchable;
    int typeSearchLikeOnly = 1;
    int typeSearchNotLike = 2;
    int typeSearchable = 3;
    short tableIndexStatistic;
    short tableIndexClustered = 1;
    short tableIndexHashed = (short)2;
    short tableIndexOther = (short)3;

    DatabaseMetaData(int n, ClientSession clientSession, String string) throws SQLException {
        super("DatabaseMetaData", n, clientSession);
        this._url = string;
        this._resultsets = new Vector();
    }

    void close() throws SQLException {
        if (!this._isClosed) {
            int n = 0;
            while (n < this._resultsets.size()) {
                ResultSet resultSet = (ResultSet)this._resultsets.elementAt(n);
                resultSet.close();
                ++n;
            }
            this._resultsets.removeAllElements();
            this.disable();
            this._isClosed = true;
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        Vector vector = this.invokeMethod(0);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean allTablesAreSelectable() throws SQLException {
        Vector vector = this.invokeMethod(1);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public String getURL() throws SQLException {
        return this._url;
    }

    public String getUserName() throws SQLException {
        Vector vector = this.invokeMethod(3);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public boolean isReadOnly() throws SQLException {
        Vector vector = this.invokeMethod(4);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        Vector vector = this.invokeMethod(5);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean nullsAreSortedLow() throws SQLException {
        Vector vector = this.invokeMethod(6);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        Vector vector = this.invokeMethod(7);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        Vector vector = this.invokeMethod(8);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public String getDatabaseProductName() throws SQLException {
        Vector vector = this.invokeMethod(9);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public String getDatabaseProductVersion() throws SQLException {
        Vector vector = this.invokeMethod(10);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public String getDriverName() throws SQLException {
        Vector vector = this.invokeMethod(11);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public String getDriverVersion() throws SQLException {
        Vector vector = this.invokeMethod(12);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public int getDriverMajorVersion() {
        return 1;
    }

    public int getDriverMinorVersion() {
        return 21;
    }

    public boolean usesLocalFiles() throws SQLException {
        Vector vector = this.invokeMethod(15);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        Vector vector = this.invokeMethod(16);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        Vector vector = this.invokeMethod(17);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        Vector vector = this.invokeMethod(18);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        Vector vector = this.invokeMethod(19);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        Vector vector = this.invokeMethod(20);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        Vector vector = this.invokeMethod(21);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        Vector vector = this.invokeMethod(22);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        Vector vector = this.invokeMethod(23);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        Vector vector = this.invokeMethod(24);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public String getIdentifierQuoteString() throws SQLException {
        Vector vector = this.invokeMethod(25);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public String getSQLKeywords() throws SQLException {
        Vector vector = this.invokeMethod(26);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public String getNumericFunctions() throws SQLException {
        Vector vector = this.invokeMethod(27);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public String getStringFunctions() throws SQLException {
        Vector vector = this.invokeMethod(28);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public String getSystemFunctions() throws SQLException {
        Vector vector = this.invokeMethod(29);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public String getTimeDateFunctions() throws SQLException {
        Vector vector = this.invokeMethod(30);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public String getSearchStringEscape() throws SQLException {
        Vector vector = this.invokeMethod(31);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public String getExtraNameCharacters() throws SQLException {
        Vector vector = this.invokeMethod(32);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        Vector vector = this.invokeMethod(33);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        Vector vector = this.invokeMethod(34);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsColumnAliasing() throws SQLException {
        Vector vector = this.invokeMethod(35);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        Vector vector = this.invokeMethod(36);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsConvert() throws SQLException {
        Vector vector = this.invokeMethod(37);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, n2));
        Vector vector2 = this.invokeMethod(38, vector);
        NetData netData = (NetData)vector2.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        Vector vector = this.invokeMethod(39);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        Vector vector = this.invokeMethod(40);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        Vector vector = this.invokeMethod(41);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        Vector vector = this.invokeMethod(42);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsGroupBy() throws SQLException {
        Vector vector = this.invokeMethod(43);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        Vector vector = this.invokeMethod(44);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        Vector vector = this.invokeMethod(45);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        Vector vector = this.invokeMethod(46);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        Vector vector = this.invokeMethod(47);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        Vector vector = this.invokeMethod(48);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        Vector vector = this.invokeMethod(49);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        Vector vector = this.invokeMethod(50);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        Vector vector = this.invokeMethod(51);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        Vector vector = this.invokeMethod(52);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        Vector vector = this.invokeMethod(132);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        Vector vector = this.invokeMethod(133);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        Vector vector = this.invokeMethod(134);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        Vector vector = this.invokeMethod(53);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsOuterJoins() throws SQLException {
        Vector vector = this.invokeMethod(54);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        Vector vector = this.invokeMethod(55);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        Vector vector = this.invokeMethod(56);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public String getSchemaTerm() throws SQLException {
        Vector vector = this.invokeMethod(57);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public String getProcedureTerm() throws SQLException {
        Vector vector = this.invokeMethod(58);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public String getCatalogTerm() throws SQLException {
        Vector vector = this.invokeMethod(59);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public boolean isCatalogAtStart() throws SQLException {
        Vector vector = this.invokeMethod(60);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public String getCatalogSeparator() throws SQLException {
        Vector vector = this.invokeMethod(61);
        NetString netString = (NetString)vector.elementAt(0);
        return netString.getString();
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        Vector vector = this.invokeMethod(62);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        Vector vector = this.invokeMethod(63);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        Vector vector = this.invokeMethod(64);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        Vector vector = this.invokeMethod(65);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        Vector vector = this.invokeMethod(66);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        Vector vector = this.invokeMethod(67);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        Vector vector = this.invokeMethod(68);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        Vector vector = this.invokeMethod(69);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        Vector vector = this.invokeMethod(70);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        Vector vector = this.invokeMethod(71);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsPositionedDelete() throws SQLException {
        Vector vector = this.invokeMethod(72);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        Vector vector = this.invokeMethod(73);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        Vector vector = this.invokeMethod(74);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsStoredProcedures() throws SQLException {
        Vector vector = this.invokeMethod(75);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        Vector vector = this.invokeMethod(76);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        Vector vector = this.invokeMethod(77);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        Vector vector = this.invokeMethod(78);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        Vector vector = this.invokeMethod(79);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        Vector vector = this.invokeMethod(80);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsUnion() throws SQLException {
        Vector vector = this.invokeMethod(81);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsUnionAll() throws SQLException {
        Vector vector = this.invokeMethod(82);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        Vector vector = this.invokeMethod(83);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        Vector vector = this.invokeMethod(84);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        Vector vector = this.invokeMethod(85);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        Vector vector = this.invokeMethod(86);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        Vector vector = this.invokeMethod(87);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxCharLiteralLength() throws SQLException {
        Vector vector = this.invokeMethod(88);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxColumnNameLength() throws SQLException {
        Vector vector = this.invokeMethod(89);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        Vector vector = this.invokeMethod(90);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxColumnsInIndex() throws SQLException {
        Vector vector = this.invokeMethod(91);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        Vector vector = this.invokeMethod(92);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxColumnsInSelect() throws SQLException {
        Vector vector = this.invokeMethod(93);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxColumnsInTable() throws SQLException {
        Vector vector = this.invokeMethod(94);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxConnections() throws SQLException {
        Vector vector = this.invokeMethod(95);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxCursorNameLength() throws SQLException {
        Vector vector = this.invokeMethod(96);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxIndexLength() throws SQLException {
        Vector vector = this.invokeMethod(97);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxSchemaNameLength() throws SQLException {
        Vector vector = this.invokeMethod(98);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxProcedureNameLength() throws SQLException {
        Vector vector = this.invokeMethod(99);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxCatalogNameLength() throws SQLException {
        Vector vector = this.invokeMethod(100);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxRowSize() throws SQLException {
        Vector vector = this.invokeMethod(101);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        Vector vector = this.invokeMethod(102);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxStatementLength() throws SQLException {
        Vector vector = this.invokeMethod(103);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxStatements() throws SQLException {
        Vector vector = this.invokeMethod(104);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxTableNameLength() throws SQLException {
        Vector vector = this.invokeMethod(105);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxTablesInSelect() throws SQLException {
        Vector vector = this.invokeMethod(106);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getMaxUserNameLength() throws SQLException {
        Vector vector = this.invokeMethod(107);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        Vector vector = this.invokeMethod(108);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsTransactions() throws SQLException {
        Vector vector = this.invokeMethod(109);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        Vector vector = this.invokeMethod(110, n);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        Vector vector = this.invokeMethod(111);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        Vector vector = this.invokeMethod(112);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        Vector vector = this.invokeMethod(113);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        Vector vector = this.invokeMethod(114);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getBool();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public java.sql.ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        String string4 = "";
        String string5 = this.getCatalogTerm();
        if (string5 != "") {
            string4 = string;
        }
        String string6 = "";
        String string7 = this.getSchemaTerm();
        if (string7 != "") {
            string6 = string2;
        }
        Vector<TextParam> vector = new Vector<TextParam>();
        vector.addElement(new TextParam(0, string4));
        vector.addElement(new TextParam(0, string6));
        vector.addElement(new TextParam(0, string3));
        Vector vector2 = this.invokeMethod(115, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "";
        String string6 = this.getCatalogTerm();
        if (string6 != "") {
            string5 = string;
        }
        String string7 = "";
        String string8 = this.getSchemaTerm();
        if (string8 != "") {
            string7 = string2;
        }
        Vector<TextParam> vector = new Vector<TextParam>();
        vector.addElement(new TextParam(0, string5));
        vector.addElement(new TextParam(0, string7));
        vector.addElement(new TextParam(0, string3));
        vector.addElement(new TextParam(0, string4));
        Vector vector2 = this.invokeMethod(116, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        String string4 = "";
        String string5 = this.getCatalogTerm();
        if (string5 != "") {
            string4 = string;
        }
        String string6 = "";
        String string7 = this.getSchemaTerm();
        if (string7 != "") {
            string6 = string2;
        }
        Vector<TextParam> vector = new Vector<TextParam>();
        vector.addElement(new TextParam(0, string4));
        vector.addElement(new TextParam(0, string6));
        vector.addElement(new TextParam(0, string3));
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                vector.addElement(new TextParam(0, stringArray[n]));
                ++n;
            }
        }
        Vector vector2 = this.invokeMethod(117, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getSchemas() throws SQLException {
        Vector vector = this.invokeMethod(118);
        ResultSet resultSet = new ResultSet(vector, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getCatalogs() throws SQLException {
        Vector vector = this.invokeMethod(119);
        ResultSet resultSet = new ResultSet(vector, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getTableTypes() throws SQLException {
        Vector vector = this.invokeMethod(120);
        ResultSet resultSet = new ResultSet(vector, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "";
        String string6 = this.getCatalogTerm();
        if (string6 != "") {
            string5 = string;
        }
        String string7 = "";
        String string8 = this.getSchemaTerm();
        if (string8 != "") {
            string7 = string2;
        }
        Vector<TextParam> vector = new Vector<TextParam>();
        vector.addElement(new TextParam(0, string5));
        vector.addElement(new TextParam(0, string7));
        vector.addElement(new TextParam(0, string3));
        vector.addElement(new TextParam(0, string4));
        Vector vector2 = this.invokeMethod(121, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        String string5 = "";
        String string6 = this.getCatalogTerm();
        if (string6 != "") {
            string5 = string;
        }
        String string7 = "";
        String string8 = this.getSchemaTerm();
        if (string8 != "") {
            string7 = string2;
        }
        Vector<TextParam> vector = new Vector<TextParam>();
        vector.addElement(new TextParam(0, string5));
        vector.addElement(new TextParam(0, string7));
        vector.addElement(new TextParam(0, string3));
        vector.addElement(new TextParam(0, string4));
        Vector vector2 = this.invokeMethod(122, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        String string4 = "";
        String string5 = this.getCatalogTerm();
        if (string5 != "") {
            string4 = string;
        }
        String string6 = "";
        String string7 = this.getSchemaTerm();
        if (string7 != "") {
            string6 = string2;
        }
        Vector<TextParam> vector = new Vector<TextParam>();
        vector.addElement(new TextParam(0, string4));
        vector.addElement(new TextParam(0, string6));
        vector.addElement(new TextParam(0, string3));
        Vector vector2 = this.invokeMethod(123, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        String string4 = "";
        String string5 = this.getCatalogTerm();
        if (string5 != "") {
            string4 = string;
        }
        String string6 = "";
        String string7 = this.getSchemaTerm();
        if (string7 != "") {
            string6 = string2;
        }
        Vector<Field> vector = new Vector<Field>();
        vector.addElement(new TextParam(0, string4));
        vector.addElement(new TextParam(0, string6));
        vector.addElement(new TextParam(0, string3));
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, bl));
        Vector vector2 = this.invokeMethod(124, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        String string4 = "";
        String string5 = this.getCatalogTerm();
        if (string5 != "") {
            string4 = string;
        }
        String string6 = "";
        String string7 = this.getSchemaTerm();
        if (string7 != "") {
            string6 = string2;
        }
        Vector<TextParam> vector = new Vector<TextParam>();
        vector.addElement(new TextParam(0, string4));
        vector.addElement(new TextParam(0, string6));
        vector.addElement(new TextParam(0, string3));
        Vector vector2 = this.invokeMethod(125, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        String string4 = "";
        String string5 = this.getCatalogTerm();
        if (string5 != "") {
            string4 = string;
        }
        String string6 = "";
        String string7 = this.getSchemaTerm();
        if (string7 != "") {
            string6 = string2;
        }
        Vector<TextParam> vector = new Vector<TextParam>();
        vector.addElement(new TextParam(0, string4));
        vector.addElement(new TextParam(0, string6));
        vector.addElement(new TextParam(0, string3));
        Vector vector2 = this.invokeMethod(126, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        String string4 = "";
        String string5 = this.getCatalogTerm();
        if (string5 != "") {
            string4 = string;
        }
        String string6 = "";
        String string7 = this.getSchemaTerm();
        if (string7 != "") {
            string6 = string2;
        }
        Vector<TextParam> vector = new Vector<TextParam>();
        vector.addElement(new TextParam(0, string4));
        vector.addElement(new TextParam(0, string6));
        vector.addElement(new TextParam(0, string3));
        Vector vector2 = this.invokeMethod(127, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        String string4 = "";
        String string5 = this.getCatalogTerm();
        if (string5 != "") {
            string4 = string;
        }
        String string6 = "";
        String string7 = this.getSchemaTerm();
        if (string7 != "") {
            string6 = string2;
        }
        Vector<TextParam> vector = new Vector<TextParam>();
        vector.addElement(new TextParam(0, string4));
        vector.addElement(new TextParam(0, string6));
        vector.addElement(new TextParam(0, string3));
        Vector vector2 = this.invokeMethod(128, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        Vector<TextParam> vector = new Vector<TextParam>();
        vector.addElement(new TextParam(0, string));
        vector.addElement(new TextParam(0, string2));
        vector.addElement(new TextParam(0, string3));
        vector.addElement(new TextParam(0, string4));
        vector.addElement(new TextParam(0, string5));
        vector.addElement(new TextParam(0, string6));
        Vector vector2 = this.invokeMethod(129, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getTypeInfo() throws SQLException {
        Vector vector = this.invokeMethod(130);
        ResultSet resultSet = new ResultSet(vector, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }

    public java.sql.ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        String string4 = "";
        String string5 = this.getCatalogTerm();
        if (string5 != "") {
            string4 = string;
        }
        String string6 = "";
        String string7 = this.getSchemaTerm();
        if (string7 != "") {
            string6 = string2;
        }
        Vector<Field> vector = new Vector<Field>();
        vector.addElement(new TextParam(0, string4));
        vector.addElement(new TextParam(0, string6));
        vector.addElement(new TextParam(0, string3));
        vector.addElement(new Param(0, bl));
        vector.addElement(new Param(0, bl2));
        Vector vector2 = this.invokeMethod(131, vector);
        ResultSet resultSet = new ResultSet(vector2, this.getSession());
        this._resultsets.addElement(resultSet);
        return resultSet;
    }
}

