/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.jdbc;

import java.io.EOFException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import symantec.itools.db.jdbc.ResultSet;
import symantec.itools.db.jdbc.Statement;
import symantec.itools.db.net.BinaryOutputStream;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.Field;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.Param;
import symantec.itools.db.net.TextParam;

public class PreparedStatement
extends Statement
implements java.sql.PreparedStatement {
    private final int METHOD_executeQuery = 0;
    private final int METHOD_executeUpdate = 1;
    private final int METHOD_setNull = 2;
    private final int METHOD_setBoolean = 3;
    private final int METHOD_setByte = 4;
    private final int METHOD_setShort = 5;
    private final int METHOD_setInt = 6;
    private final int METHOD_setLong = 7;
    private final int METHOD_setFloat = 8;
    private final int METHOD_setDouble = 9;
    private final int METHOD_setBigDecimal = 10;
    private final int METHOD_setString = 11;
    private final int METHOD_setBytes = 12;
    private final int METHOD_setDate = 13;
    private final int METHOD_setTime = 14;
    private final int METHOD_setTimestamp = 15;
    private final int METHOD_clearParameters = 16;
    private final int METHOD_setObject1 = 17;
    private final int METHOD_setObject2 = 18;
    private final int METHOD_setObject3 = 19;
    private final int METHOD_execute = 20;
    private final int METHOD_getStream = 21;
    private InputStream _stream = null;
    private ClientSession _session;

    protected int getNumberOfMethods() {
        return super.getNumberOfMethods() + 21 + 1;
    }

    PreparedStatement(int n, ClientSession clientSession) throws SQLException {
        super(n, clientSession);
        this._session = clientSession;
    }

    public void closeStream() {
        if (this._stream != null) {
            try {
                this._stream.close();
            }
            catch (Exception exception) {}
            this._stream = null;
        }
    }

    BinaryOutputStream getRemoteStream(int n, boolean bl) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, bl));
        Vector vector2 = this.invokeMethod(super.getNumberOfMethods() + 21, vector);
        NetData netData = (NetData)vector2.elementAt(0);
        try {
            return new BinaryOutputStream(netData.getInt(), this._session);
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public java.sql.ResultSet executeQuery() throws SQLException {
        this.closeStream();
        Vector vector = this.invokeMethod(super.getNumberOfMethods());
        if (vector.size() > 0) {
            ResultSet resultSet = new ResultSet(vector, this.getSession());
            this.setCurrentResultSet(resultSet);
            return resultSet;
        }
        this.setCurrentResultSet(null);
        return null;
    }

    public int executeUpdate() throws SQLException {
        this.closeStream();
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 1);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            int n = netData.getInt();
            this.setCurrentResultSet(null);
            return n;
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public void setNull(int n, int n2) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, n2));
        this.invokeMethod(super.getNumberOfMethods() + 2, vector);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, bl));
        this.invokeMethod(super.getNumberOfMethods() + 3, vector);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, by));
        this.invokeMethod(super.getNumberOfMethods() + 4, vector);
    }

    public void setShort(int n, short s) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, s));
        this.invokeMethod(super.getNumberOfMethods() + 5, vector);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, n2));
        this.invokeMethod(super.getNumberOfMethods() + 6, vector);
    }

    public void setLong(int n, long l) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, l));
        this.invokeMethod(super.getNumberOfMethods() + 7, vector);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, f));
        this.invokeMethod(super.getNumberOfMethods() + 8, vector);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, d));
        this.invokeMethod(super.getNumberOfMethods() + 9, vector);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.closeStream();
        Vector<Field> vector = new Vector<Field>();
        vector.addElement(new Param(0, n));
        vector.addElement(new TextParam(0, bigDecimal.toString()));
        this.invokeMethod(super.getNumberOfMethods() + 10, vector);
    }

    public void setString(int n, String string) throws SQLException {
        this.closeStream();
        Vector<Field> vector = new Vector<Field>();
        vector.addElement(new Param(0, n));
        vector.addElement(new TextParam(0, string));
        this.invokeMethod(super.getNumberOfMethods() + 11, vector);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, byArray));
        vector.addElement(new Param(0, byArray.length));
        this.invokeMethod(super.getNumberOfMethods() + 12, vector);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, date.getYear() + 1900));
        vector.addElement(new Param(0, date.getMonth() + 1));
        vector.addElement(new Param(0, date.getDate()));
        this.invokeMethod(super.getNumberOfMethods() + 13, vector);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, time.getHours()));
        vector.addElement(new Param(0, time.getMinutes()));
        vector.addElement(new Param(0, time.getSeconds()));
        this.invokeMethod(super.getNumberOfMethods() + 14, vector);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.closeStream();
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        int n2 = timestamp.getYear();
        int n3 = timestamp.getMonth();
        int n4 = timestamp.getDate();
        int n5 = timestamp.getHours();
        int n6 = timestamp.getMinutes();
        int n7 = timestamp.getSeconds();
        int n8 = (timestamp.getNanos() + 500000) / 1000000;
        if (n8 >= 1000) {
            n8 = 0;
            if (++n7 >= 60) {
                n7 = 0;
                if (++n6 >= 60) {
                    n6 = 0;
                    if (++n5 >= 24) {
                        n5 = 0;
                        java.util.Date date = new java.util.Date(n2, n3, n4 + 1);
                        n2 = date.getYear();
                        n3 = date.getMonth();
                        n4 = date.getDate();
                    }
                }
            }
        }
        vector.addElement(new Param(0, n2 + 1900));
        vector.addElement(new Param(0, n3 + 1));
        vector.addElement(new Param(0, n4));
        vector.addElement(new Param(0, n5));
        vector.addElement(new Param(0, n6));
        vector.addElement(new Param(0, n7));
        vector.addElement(new Param(0, n8));
        this.invokeMethod(super.getNumberOfMethods() + 15, vector);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        BinaryOutputStream binaryOutputStream = this.getRemoteStream(n, true);
        binaryOutputStream.sendData(inputStream, n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        BinaryOutputStream binaryOutputStream = this.getRemoteStream(n, true);
        binaryOutputStream.sendData(inputStream, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        BinaryOutputStream binaryOutputStream = this.getRemoteStream(n, false);
        binaryOutputStream.sendData(inputStream, n2);
    }

    public void clearParameters() throws SQLException {
        this.closeStream();
        this.invokeMethod(super.getNumberOfMethods() + 16);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.closeStream();
        switch (n2) {
            case -7: {
                Boolean bl = (Boolean)object;
                this.setBoolean(n, bl);
                return;
            }
            case -6: {
                byte[] byArray = (byte[])object;
                this.setByte(n, byArray[0]);
                return;
            }
            case 5: {
                Integer n4 = (Integer)object;
                this.setShort(n, (short)n4.intValue());
                return;
            }
            case 4: {
                Integer n5 = (Integer)object;
                this.setInt(n, n5);
                return;
            }
            case -5: {
                Long l = (Long)object;
                this.setLong(n, l);
                return;
            }
            case 7: {
                Float f = (Float)object;
                this.setFloat(n, f.floatValue());
                return;
            }
            case 6: {
                Float f = (Float)object;
                this.setFloat(n, f.floatValue());
                return;
            }
            case 8: {
                Double d = (Double)object;
                this.setDouble(n, d);
                return;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(n, (BigDecimal)object);
                return;
            }
            case 1: {
                this.setString(n, (String)object);
                return;
            }
            case 12: {
                this.setString(n, (String)object);
                return;
            }
            case -1: {
                this.setString(n, (String)object);
                return;
            }
            case 91: {
                this.setDate(n, (Date)object);
                return;
            }
            case 92: {
                this.setTime(n, (Time)object);
                return;
            }
            case 93: {
                this.setTimestamp(n, (Timestamp)object);
                return;
            }
            case -2: {
                this.setBytes(n, (byte[])object);
                return;
            }
            case -3: {
                this.setBytes(n, (byte[])object);
                return;
            }
            case -4: {
                this.setBytes(n, (byte[])object);
                return;
            }
        }
        throw new SQLException("Unrecognized sql type" + String.valueOf(n2));
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.closeStream();
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.closeStream();
        String string = object.getClass().getName();
        int n2 = 0;
        n2 = string.equals("java.lang.String") ? 12 : (string.equals("java.math.BigDecimal") ? 2 : (string.equals("java.lang.Boolean") ? -7 : (string.equals("java.lang.Integer") ? 4 : (string.equals("java.lang.Long") ? -5 : (string.equals("java.lang.Float") ? 7 : (string.equals("java.lang.Double") ? 8 : (string.equals("java.sql.Date") ? 91 : (string.equals("java.sql.Time") ? 92 : (string.equals("java.sql.Timestamp") ? 93 : -3)))))))));
        this.setObject(n, object, n2);
    }

    public boolean execute() throws SQLException {
        this.closeStream();
        Vector vector = this.invokeMethod(super.getNumberOfMethods() + 20);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            boolean bl = netData.getBool();
            this.setCurrentResultSet(null);
            return bl;
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }
}

