/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.jdbc;

import java.io.EOFException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import symantec.itools.db.jdbc.ProxyObject;
import symantec.itools.db.jdbc.ResultSet;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.Warning;

class Statement
extends ProxyObject
implements java.sql.Statement {
    private final int METHOD_executeQuery = 0;
    private final int METHOD_executeUpdate = 1;
    private final int METHOD_close = 2;
    private final int METHOD_getMaxFieldSize = 3;
    private final int METHOD_setMaxFieldSize = 4;
    private final int METHOD_getMaxRows = 5;
    private final int METHOD_setMaxRows = 6;
    private final int METHOD_setEscapeProcessing = 7;
    private final int METHOD_getQueryTimeout = 8;
    private final int METHOD_setQueryTimeout = 9;
    private final int METHOD_cancel = 10;
    private final int METHOD_getWarnings = 11;
    private final int METHOD_clearWarnings = 12;
    private final int METHOD_execute = 13;
    private final int METHOD_getResultSet = 14;
    private final int METHOD_getUpdateCount = 15;
    private final int METHOD_getMoreResults = 16;
    private final int METHOD_setCursorName = 17;
    private ResultSet _currentRS;
    private boolean _isClosed = false;

    protected int getNumberOfMethods() {
        return 18;
    }

    protected void setCurrentResultSet(ResultSet resultSet) throws SQLException {
        if (this._currentRS != null) {
            this._currentRS.close();
        }
        this._currentRS = resultSet;
    }

    Statement(String string, int n, ClientSession clientSession) throws SQLException {
        super(string, n, clientSession);
    }

    Statement(int n, ClientSession clientSession) throws SQLException {
        super("Statement", n, clientSession);
    }

    protected void finalize() {
        try {
            this.close();
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        Vector vector = this.invokeMethod(0, string);
        ResultSet resultSet = new ResultSet(vector, this.getSession());
        this.setCurrentResultSet(resultSet);
        return resultSet;
    }

    public int executeUpdate(String string) throws SQLException {
        Vector vector = this.invokeMethod(1, string);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            int n = netData.getInt();
            this.setCurrentResultSet(null);
            return n;
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public void close() throws SQLException {
        if (!this._isClosed) {
            this.setCurrentResultSet(null);
            this.invokeMethod(2);
            this.disable();
            this._isClosed = true;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        Vector vector = this.invokeMethod(3);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.invokeMethod(4, n);
    }

    public int getMaxRows() throws SQLException {
        Vector vector = this.invokeMethod(5);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public void setMaxRows(int n) throws SQLException {
        this.invokeMethod(6, n);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.invokeMethod(7, bl);
    }

    public int getQueryTimeout() throws SQLException {
        Vector vector = this.invokeMethod(8);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.invokeMethod(9, n);
    }

    public void cancel() throws SQLException {
        this.invokeMethod(10);
    }

    public SQLWarning getWarnings() throws SQLException {
        SQLWarning sQLWarning = null;
        SQLWarning sQLWarning2 = null;
        SQLWarning sQLWarning3 = null;
        Vector vector = this.invokeMethod(11);
        int n = 0;
        while (n < vector.size()) {
            Warning warning = (Warning)vector.elementAt(n);
            sQLWarning2 = warning.toSQLWarning();
            if (sQLWarning == null) {
                sQLWarning = sQLWarning2;
            } else {
                sQLWarning3.setNextWarning(sQLWarning2);
            }
            sQLWarning3 = sQLWarning2;
            ++n;
        }
        return sQLWarning;
    }

    public void clearWarnings() throws SQLException {
        this.invokeMethod(12);
    }

    public boolean execute(String string) throws SQLException {
        Vector vector = this.invokeMethod(13, string);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            boolean bl = netData.getBool();
            this.setCurrentResultSet(null);
            return bl;
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        if (this._currentRS == null) {
            Vector vector = this.invokeMethod(14);
            ResultSet resultSet = new ResultSet(vector, this.getSession());
            this.setCurrentResultSet(resultSet);
        }
        return this._currentRS;
    }

    public int getUpdateCount() throws SQLException {
        Vector vector = this.invokeMethod(15);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public boolean getMoreResults() throws SQLException {
        Vector vector = this.invokeMethod(16);
        NetData netData = (NetData)vector.elementAt(0);
        try {
            boolean bl = netData.getBool();
            this.setCurrentResultSet(null);
            return bl;
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    public void setCursorName(String string) throws SQLException {
        this.invokeMethod(17, string);
    }
}

