/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.NetClass;
import symantec.itools.db.net.NetError;
import symantec.itools.db.net.ServerList;
import symantec.itools.db.net.ServerObject;

class ExceptionList
extends ServerObject {
    SQLException _e;

    ExceptionList(SQLException sQLException) {
        this._e = sQLException;
    }

    ExceptionList() {
        this._e = new SQLException("");
    }

    SQLException getSQLException() {
        return this._e;
    }

    int getType() {
        return 68;
    }

    void read(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        dataInputStream.readShort();
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray, 0, 4);
        ServerObject serverObject = (ServerObject)NetClass.getNextObject(dataInputStream);
        SQLException sQLException = this._e = null;
        while (serverObject.getType() == 49) {
            NetError netError = (NetError)serverObject;
            SQLException sQLException2 = netError.toSQLException();
            if (this._e == null) {
                sQLException = sQLException2;
                this._e = sQLException2;
            } else {
                sQLException.setNextException(sQLException2);
                sQLException = sQLException2;
            }
            serverObject = (ServerObject)NetClass.getNextObject(dataInputStream);
        }
        if (serverObject.getType() != 50) {
            this.onObjectError(serverObject);
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.getType());
        dataOutputStream.writeShort(4);
        dataOutputStream.writeBytes("ERR}");
        Vector<NetError> vector = new Vector<NetError>();
        SQLException sQLException = this._e;
        while (sQLException != null) {
            vector.addElement(new NetError(0, sQLException.getErrorCode(), sQLException.getMessage(), sQLException.getSQLState(), "", "{ERR"));
            sQLException = sQLException.getNextException();
        }
        ServerList serverList = new ServerList(vector);
        serverList.write(dataOutputStream);
    }
}

