/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Vector;
import symantec.itools.db.net.ClientSession;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.IO;
import symantec.itools.db.net.NetException;
import symantec.itools.db.net.SQLServerConnException;
import symantec.itools.db.net.SessionRequest;
import symantec.itools.db.net.SocketWrapper;

class MPlex {
    Vector _IOs;
    InetAddress _host;
    int _port;
    boolean _shareSocket;
    int _connectionID;
    ClientSession _sess;
    boolean _connLost;
    static final int SECURE_PORT = 8890;

    MPlex(InetAddress inetAddress, int n, boolean bl, ClientSession clientSession) {
        this._host = inetAddress;
        this._port = n;
        this._shareSocket = bl;
        this._sess = clientSession;
        this._IOs = new Vector();
        this._connLost = false;
    }

    SessionRequest connect() throws NetException, ErrorException {
        SessionRequest sessionRequest = new SessionRequest(this._sess);
        this._connectionID = sessionRequest.connect();
        if (this._connectionID == -1) {
            this.disconnect();
            this.close();
            throw new NetException("Client/Server Protocol Version Mismatch:  Client class files version conflicts with expected dbANYWHERE version; verify CLASSPATH environment setting.");
        }
        if (this._connectionID == -2) {
            return sessionRequest;
        }
        return null;
    }

    void disconnect() {
        try {
            SessionRequest sessionRequest = new SessionRequest(this._sess);
            sessionRequest.disconnect();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    short getNextID() throws NetException {
        short s = 0;
        while (s < this._IOs.size()) {
            if ((IO)this._IOs.elementAt(s) == null) {
                return s;
            }
            s = (short)(s + 1);
        }
        if (this._IOs.size() < 32765) {
            return (short)this._IOs.size();
        }
        throw new NetException("IO object limit reached");
    }

    SocketWrapper getSocket() throws NetException {
        SocketWrapper socketWrapper = null;
        if (!this._shareSocket || this._IOs.size() == 0) {
            if (this._port < 80) {
                throw new NetException("Port# must be 80 or higher");
            }
            try {
                socketWrapper = new SocketWrapper(this._host, this._port, this._port == 8890);
            }
            catch (UnknownHostException unknownHostException) {
                throw new NetException("Unknown host");
            }
            catch (IOException iOException) {
                throw new NetException("Server not responding");
            }
            catch (SecurityException securityException) {
                throw new NetException("Security exception");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NetException("Class not found (new SocketWrapper)");
            }
            catch (InstantiationException instantiationException) {
                throw new NetException("Instantiation exception (new SocketWrapper)");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new NetException("Illegal Access exception (new SocketWrapper)");
            }
        } else {
            IO iO = (IO)this._IOs.elementAt(0);
            socketWrapper = iO._sock;
        }
        return socketWrapper;
    }

    synchronized IO getIO() throws NetException, SQLException {
        Object object;
        IO iO;
        if (this._connLost) {
            throw new SQLServerConnException();
        }
        short s = this.getNextID();
        SocketWrapper socketWrapper = this.getSocket();
        if (!this._shareSocket || this._IOs.size() == 0) {
            iO = new IO(this, socketWrapper, s);
        } else {
            object = (IO)this._IOs.elementAt(0);
            iO = new IO(((IO)object)._writer, ((IO)object).getInputStream(), s);
        }
        if (s == this._IOs.size()) {
            this._IOs.addElement(iO);
        } else {
            this._IOs.setElementAt(iO, s);
        }
        if (s != 0 && !this._shareSocket) {
            try {
                object = new SessionRequest(this._sess);
                ((SessionRequest)object).reconnect(iO, this._connectionID);
            }
            catch (ErrorException errorException) {
                throw new NetException("Error reconnecting IO object");
            }
        }
        return iO;
    }

    synchronized void close() {
        int n = 0;
        while (n < this._IOs.size()) {
            if ((IO)this._IOs.elementAt(n) != null) {
                ((IO)this._IOs.elementAt(n)).close();
            }
            n = (short)(n + 1);
        }
        this._IOs.removeAllElements();
        this._connLost = true;
    }

    synchronized void releaseIO(IO iO) {
        if (iO._id != 0) {
            iO.close();
            this._IOs.setElementAt(null, iO._id);
        }
    }

    synchronized OutputStream getStream(short s) {
        IO iO = (IO)this._IOs.elementAt(s);
        return iO._readerOS;
    }

    synchronized void connectionLost() {
        this._connLost = true;
        this._sess.lostConnection();
    }
}

