/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.IOException;
import java.sql.SQLException;
import symantec.itools.db.net.Attribute;
import symantec.itools.db.net.BigInt;
import symantec.itools.db.net.Binary;
import symantec.itools.db.net.Bit;
import symantec.itools.db.net.Char;
import symantec.itools.db.net.EOT;
import symantec.itools.db.net.Entity;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.ExceptionList;
import symantec.itools.db.net.LongVarBinary;
import symantec.itools.db.net.LongVarChar;
import symantec.itools.db.net.NetBigDecimal;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NetDataCompressed;
import symantec.itools.db.net.NetDate;
import symantec.itools.db.net.NetDouble;
import symantec.itools.db.net.NetError;
import symantec.itools.db.net.NetFloat;
import symantec.itools.db.net.NetInteger;
import symantec.itools.db.net.NetRecord;
import symantec.itools.db.net.NetString;
import symantec.itools.db.net.NetTime;
import symantec.itools.db.net.NetTimestamp;
import symantec.itools.db.net.Param;
import symantec.itools.db.net.Real;
import symantec.itools.db.net.SQLServerConnException;
import symantec.itools.db.net.ServerList;
import symantec.itools.db.net.ServerObject;
import symantec.itools.db.net.SmallInt;
import symantec.itools.db.net.TextParam;
import symantec.itools.db.net.TinyInt;
import symantec.itools.db.net.VarBinary;
import symantec.itools.db.net.VarChar;
import symantec.itools.db.net.Warning;

class NetClass {
    static Object getObject(short s) {
        ServerObject serverObject = null;
        switch (s) {
            case 50: {
                serverObject = new EOT();
                break;
            }
            case 51: {
                serverObject = new NetData();
                break;
            }
            case 79: {
                serverObject = new NetDataCompressed();
                break;
            }
            case 52: {
                serverObject = new NetString();
                break;
            }
            case 49: {
                serverObject = new NetError();
                break;
            }
            case 54: {
                serverObject = new ServerList();
                break;
            }
            case 57: {
                serverObject = new Param();
                break;
            }
            case 58: {
                serverObject = new TextParam();
                break;
            }
            case 68: {
                serverObject = new ExceptionList();
                break;
            }
            case 59: {
                serverObject = new NetRecord();
                break;
            }
            case 69: {
                serverObject = new Char();
                break;
            }
            case 70: {
                serverObject = new Binary();
                break;
            }
            case 71: {
                serverObject = new VarBinary();
                break;
            }
            case 72: {
                serverObject = new LongVarBinary();
                break;
            }
            case 73: {
                serverObject = new VarChar();
                break;
            }
            case 74: {
                serverObject = new LongVarChar();
                break;
            }
            case 75: {
                serverObject = new NetDate();
                break;
            }
            case 76: {
                serverObject = new NetTime();
                break;
            }
            case 77: {
                serverObject = new NetTimestamp();
                break;
            }
            case 78: {
                serverObject = new BigInt();
                break;
            }
            case 80: {
                serverObject = new NetDouble();
                break;
            }
            case 81: {
                serverObject = new NetFloat();
                break;
            }
            case 82: {
                serverObject = new NetInteger();
                break;
            }
            case 83: {
                serverObject = new NetBigDecimal();
                break;
            }
            case 84: {
                serverObject = new Real();
                break;
            }
            case 85: {
                serverObject = new SmallInt();
                break;
            }
            case 86: {
                serverObject = new TinyInt();
                break;
            }
            case 87: {
                serverObject = new Bit();
                break;
            }
            case 88: {
                serverObject = new Warning();
                break;
            }
            case 62: {
                serverObject = new Attribute();
                break;
            }
            case 64: {
                serverObject = new Entity();
                break;
            }
            default: {
                serverObject = new NetError();
            }
        }
        return serverObject;
    }

    static Object getNextObject(DataInputStream dataInputStream) throws ErrorException, IOException, SQLException {
        byte by;
        Object object = null;
        try {
            by = dataInputStream.readByte();
        }
        catch (IOException iOException) {
            throw new SQLServerConnException();
        }
        object = NetClass.getObject(by);
        if (object != null) {
            ((ServerObject)object).read(dataInputStream);
        }
        return object;
    }

    NetClass() {
    }
}

