/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.SQLException;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.ServerObject;

public class NetData
extends ServerObject {
    int _length;
    byte[] _data;

    public NetData(byte[] byArray) {
        this._data = byArray;
        this._length = byArray.length;
    }

    public NetData(byte[] byArray, int n) {
        this._data = byArray;
        this._length = n;
    }

    public NetData(byte by) {
        this._length = 1;
        this._data = new byte[this._length];
        this._data[0] = by;
    }

    public NetData(short s) {
        this._length = 2;
        this._data = new byte[this._length];
        this._data[0] = (byte)(s >>> 8 & 0xFF);
        this._data[1] = (byte)(s & 0xFF);
    }

    public NetData(boolean bl) {
        this._length = 1;
        this._data = new byte[this._length];
        this._data[0] = (byte)(bl ? 1 : 0);
    }

    public NetData(int n) {
        this._length = 4;
        this._data = new byte[this._length];
        this._data[0] = (byte)(n >>> 24 & 0xFF);
        this._data[1] = (byte)(n >>> 16 & 0xFF);
        this._data[2] = (byte)(n >>> 8 & 0xFF);
        this._data[3] = (byte)(n & 0xFF);
    }

    public NetData(long l) {
        this._length = 8;
        this._data = new byte[this._length];
        this._data[0] = (byte)((int)(l >>> 56) & 0xFF);
        this._data[1] = (byte)((int)(l >>> 48) & 0xFF);
        this._data[2] = (byte)((int)(l >>> 40) & 0xFF);
        this._data[3] = (byte)((int)(l >>> 32) & 0xFF);
        this._data[4] = (byte)((int)(l >>> 24) & 0xFF);
        this._data[5] = (byte)((int)(l >>> 16) & 0xFF);
        this._data[6] = (byte)((int)(l >>> 8) & 0xFF);
        this._data[7] = (byte)((int)l & 0xFF);
    }

    public NetData(float f) {
        this._length = 4;
        this._data = new byte[this._length];
        int n = Float.floatToIntBits(f);
        this._data[0] = (byte)(n >>> 24 & 0xFF);
        this._data[1] = (byte)(n >>> 16 & 0xFF);
        this._data[2] = (byte)(n >>> 8 & 0xFF);
        this._data[3] = (byte)(n & 0xFF);
    }

    public NetData(double d) {
        this._length = 8;
        this._data = new byte[this._length];
        long l = Double.doubleToLongBits(d);
        this._data[0] = (byte)((int)(l >>> 56) & 0xFF);
        this._data[1] = (byte)((int)(l >>> 48) & 0xFF);
        this._data[2] = (byte)((int)(l >>> 40) & 0xFF);
        this._data[3] = (byte)((int)(l >>> 32) & 0xFF);
        this._data[4] = (byte)((int)(l >>> 24) & 0xFF);
        this._data[5] = (byte)((int)(l >>> 16) & 0xFF);
        this._data[6] = (byte)((int)(l >>> 8) & 0xFF);
        this._data[7] = (byte)((int)l & 0xFF);
    }

    public NetData(String string) {
        this._length = string.length();
        this._data = new byte[this._length];
        int n = 0;
        while (n < this._length) {
            this._data[n] = (byte)string.charAt(n);
            ++n;
        }
    }

    public NetData() {
        this._length = 0;
        this._data = new byte[this._length];
    }

    int getType() {
        return 51;
    }

    void read(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        this._length = dataInputStream.readShort();
        if (this._length > 0) {
            this._data = new byte[this._length];
            dataInputStream.readFully(this._data, 0, this._length);
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.getType());
        dataOutputStream.writeShort(this._length);
        if (this._length > 0) {
            dataOutputStream.write(this._data, 0, this._length);
        }
    }

    public int getInt() throws EOFException {
        if (this._length >= 4) {
            int n = this._data[0] & 0xFF;
            int n2 = this._data[1] & 0xFF;
            int n3 = this._data[2] & 0xFF;
            int n4 = this._data[3] & 0xFF;
            return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
        }
        throw new EOFException();
    }

    public short getShort() throws EOFException {
        if (this._length >= 2) {
            int n = this._data[0] & 0xFF;
            int n2 = this._data[1] & 0xFF;
            return (short)((n << 8) + n2);
        }
        throw new EOFException();
    }

    public boolean getBool() throws EOFException {
        if (this._length >= 1) {
            byte by = this._data[0];
            return by != 0;
        }
        throw new EOFException();
    }

    public byte getByte() throws EOFException {
        if (this._length >= 1) {
            return (byte)(this._data[0] & 0xFF);
        }
        throw new EOFException();
    }

    public long getLong() throws EOFException {
        if (this._length >= 8) {
            int n = this.getInt();
            int n2 = this._data[4] & 0xFF;
            int n3 = this._data[5] & 0xFF;
            int n4 = this._data[6] & 0xFF;
            int n5 = this._data[7] & 0xFF;
            int n6 = (n2 << 24) + (n3 << 16) + (n4 << 8) + n5;
            return (long)(n << 32) + ((long)n6 & 0xFFFFFFFFL);
        }
        throw new EOFException();
    }

    public float getFloat() throws EOFException {
        return Float.intBitsToFloat(this.getInt());
    }

    public double getDouble() throws EOFException {
        return Double.longBitsToDouble(this.getLong());
    }

    public byte[] getBytes() {
        return this._data;
    }
}

