/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.NetClass;
import symantec.itools.db.net.NetString;
import symantec.itools.db.net.SQLConnectionException;
import symantec.itools.db.net.ServerObject;

class NetError
extends ServerObject {
    int _severity;
    int _errorID;
    int _type;
    Vector _errorStr;
    String _leader;

    NetError(byte by, int n, String string, String string2, String string3, String string4) {
        this._severity = by;
        this._errorID = n;
        this._errorStr = new Vector();
        this._errorStr.addElement(new NetString(string));
        this._errorStr.addElement(new NetString(string2));
        this._errorStr.addElement(new NetString(string3));
        this._leader = string4;
    }

    int getSeverity() {
        return this._severity;
    }

    int getID() {
        return this._errorID;
    }

    String getErrorString(int n) {
        if (n > this._errorStr.size()) {
            return new String("");
        }
        NetString netString = (NetString)this._errorStr.elementAt(n);
        return new String(netString.getString());
    }

    SQLException toSQLException() {
        if (this._type == 8) {
            return new SQLConnectionException(this.getErrorString(0), this.getErrorString(1), this.getID());
        }
        return new SQLException(this.getErrorString(0), this.getErrorString(1), this.getID());
    }

    NetError() {
    }

    int getType() {
        return 49;
    }

    void read(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        this._severity = 0;
        dataInputStream.readShort();
        byte[] byArray = new byte[4];
        dataInputStream.readFully(byArray, 0, 4);
        this._leader = new String(byArray, 0);
        this._errorID = dataInputStream.readInt();
        this._type = dataInputStream.readInt();
        this._errorStr = new Vector();
        int n = 0;
        while (n < 2) {
            ServerObject serverObject = (ServerObject)NetClass.getNextObject(dataInputStream);
            if (serverObject.getType() == 52) {
                this._errorStr.addElement(serverObject);
            } else {
                this.onObjectError(serverObject);
            }
            ++n;
        }
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.getType());
        dataOutputStream.writeShort(9);
        dataOutputStream.writeBytes(this._leader);
        dataOutputStream.writeByte(this._severity);
        dataOutputStream.writeInt(this._errorID);
        int n = 0;
        while (n < 2) {
            NetString netString = (NetString)this._errorStr.elementAt(n);
            netString.write(dataOutputStream);
            ++n;
        }
    }
}

