/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import symantec.itools.db.net.DateTimeField;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.NetData;

class NetTime
extends DateTimeField {
    Time _timeVal;

    NetTime() {
    }

    int getType() {
        return 76;
    }

    void readData(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        short s3 = dataInputStream.readShort();
        this._timeVal = new Time(s, s2, s3);
    }

    void writeData(DataOutputStream dataOutputStream) throws IOException {
        if (this._timeVal == null) {
            this._timeVal = new Time(4, 5, 6);
        }
        NetData netData = new NetData((short)this._timeVal.getHours());
        netData.write(dataOutputStream);
        netData = new NetData((short)this._timeVal.getMinutes());
        netData.write(dataOutputStream);
        netData = new NetData((short)this._timeVal.getSeconds());
        netData.write(dataOutputStream);
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this._timeVal.toString();
    }

    public Time getTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this._timeVal;
    }

    public void setString(String string) throws SQLException {
        this._timeVal = Time.valueOf(string);
        this._null = false;
    }

    public void setTime(Time time) throws SQLException {
        this._timeVal = time;
        this._null = false;
    }

    public void setTimestamp(Timestamp timestamp) throws SQLException {
        this._timeVal = new Time(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
        this._null = false;
    }

    public int getSQLType() {
        return 92;
    }

    public Object getObject() throws SQLException {
        return new Time(this._timeVal.getHours(), this._timeVal.getMinutes(), this._timeVal.getSeconds());
    }

    public void setObject(Object object) throws SQLException {
        this.setTime((Time)object);
    }
}

