/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import symantec.itools.db.net.DateTimeField;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.NetData;

class NetTimestamp
extends DateTimeField {
    Timestamp _tsVal;

    NetTimestamp() {
    }

    int getType() {
        return 77;
    }

    void readData(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        int n = dataInputStream.readShort();
        n -= 1900;
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        short s3 = dataInputStream.readShort();
        short s4 = dataInputStream.readShort();
        short s5 = dataInputStream.readShort();
        short s6 = dataInputStream.readShort();
        int n2 = s6 * 1000000;
        if (!this._null) {
            try {
                this._tsVal = new Timestamp(n, s - 1, s2, s3, s4, s5, n2);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._tsVal = new Timestamp(97, 3, 20, 4, 5, 6, 7);
                this._null = true;
                return;
            }
        }
        this._tsVal = new Timestamp(97, 3, 20, 4, 5, 6, 7);
    }

    void writeData(DataOutputStream dataOutputStream) throws IOException {
        Object object;
        if (this._tsVal == null) {
            this._tsVal = new Timestamp(97, 3, 20, 4, 5, 6, 7);
        }
        int n = this._tsVal.getYear();
        int n2 = this._tsVal.getMonth();
        int n3 = this._tsVal.getDate();
        int n4 = this._tsVal.getHours();
        int n5 = this._tsVal.getMinutes();
        int n6 = this._tsVal.getSeconds();
        int n7 = (this._tsVal.getNanos() + 500000) / 1000000;
        if (n7 >= 1000) {
            n7 = 0;
            if (++n6 >= 60) {
                n6 = 0;
                if (++n5 >= 60) {
                    n5 = 0;
                    if (++n4 >= 24) {
                        n4 = 0;
                        object = new java.sql.Date(n, n2, n3 + 1);
                        n = ((Date)object).getYear();
                        n2 = ((Date)object).getMonth();
                        n3 = ((Date)object).getDate();
                    }
                }
            }
        }
        object = new NetData((short)(n + 1900));
        ((NetData)object).write(dataOutputStream);
        object = new NetData((short)(n2 + 1));
        ((NetData)object).write(dataOutputStream);
        object = new NetData((short)n3);
        ((NetData)object).write(dataOutputStream);
        object = new NetData((short)n4);
        ((NetData)object).write(dataOutputStream);
        object = new NetData((short)n5);
        ((NetData)object).write(dataOutputStream);
        object = new NetData((short)n6);
        ((NetData)object).write(dataOutputStream);
        object = new NetData((short)n7);
        ((NetData)object).write(dataOutputStream);
    }

    public String getString() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this._tsVal.toString();
    }

    public java.sql.Date getDate() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new java.sql.Date(this._tsVal.getYear(), this._tsVal.getMonth(), this._tsVal.getDate());
    }

    public Time getTime() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new Time(this._tsVal.getHours(), this._tsVal.getMinutes(), this._tsVal.getSeconds());
    }

    public Timestamp getTimestamp() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this._tsVal;
    }

    public int getSQLType() {
        return 93;
    }

    public Object getObject() throws SQLException {
        return new Timestamp(this._tsVal.getYear(), this._tsVal.getMonth(), this._tsVal.getDate(), this._tsVal.getHours(), this._tsVal.getMinutes(), this._tsVal.getSeconds(), this._tsVal.getNanos());
    }

    public void setObject(Object object) throws SQLException {
        this.setTimestamp((Timestamp)object);
    }

    public void setString(String string) throws SQLException {
        this._tsVal = Timestamp.valueOf(string);
        this._null = false;
    }

    public void setTimestamp(Timestamp timestamp) throws SQLException {
        this._tsVal = timestamp;
        this._null = false;
    }
}

