/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import symantec.itools.db.net.ErrorException;
import symantec.itools.db.net.Field;
import symantec.itools.db.net.NetClass;
import symantec.itools.db.net.NetString;
import symantec.itools.db.net.ServerObject;

public class TextParam
extends Field {
    NetString _s;

    public TextParam(int n, String string) {
        this._id = n;
        this._type = 102;
        if (string != null) {
            this._s = new NetString(string);
            return;
        }
        this._s = new NetString("");
    }

    public TextParam() {
        this._id = 0;
        this._type = 102;
        this._s = new NetString("");
    }

    int getType() {
        return 58;
    }

    void read(DataInputStream dataInputStream) throws SQLException, IOException, ErrorException {
        dataInputStream.readShort();
        this._id = dataInputStream.read();
        this._type = 102;
        ServerObject serverObject = (ServerObject)NetClass.getNextObject(dataInputStream);
        if (serverObject.getType() == 52) {
            this._s = (NetString)serverObject;
            return;
        }
        this.onObjectError(serverObject);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.getType());
        dataOutputStream.writeShort(1);
        dataOutputStream.writeByte(this._id);
        this._s.write(dataOutputStream);
    }

    public String getChar() throws SQLException {
        return new String(this._s.getString());
    }

    public String getVarChar() throws SQLException {
        return new String(this._s.getString());
    }

    public String getLongVarChar() throws SQLException {
        return new String(this._s.getString());
    }

    public boolean getBit() throws SQLException {
        byte by = (byte)this._s.getString().charAt(0);
        return by != 0;
    }

    public byte getTinyInt() throws SQLException {
        try {
            Double d = new Double(this._s.getString());
            return (byte)d.intValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public short getSmallInt() throws SQLException {
        try {
            Double d = new Double(this._s.getString());
            return (short)d.intValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public int getInteger() throws SQLException {
        try {
            Double d = new Double(this._s.getString());
            return d.intValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public long getBigInt() throws SQLException {
        try {
            Double d = new Double(this._s.getString());
            return d.longValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public float getReal() throws SQLException {
        return this.getFloat();
    }

    public float getFloat() throws SQLException {
        try {
            Double d = new Double(this._s.getString());
            return d.floatValue();
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public double getDouble() throws SQLException {
        try {
            Double d = new Double(this._s.getString());
            return d;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = new BigDecimal(this._s.getString());
        return bigDecimal.setScale(n);
    }

    public BigDecimal getDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = new BigDecimal(this._s.getString());
        return bigDecimal.setScale(n);
    }

    public byte[] getBinary() throws SQLException {
        try {
            String string = this._s.getString();
            byte[] byArray = new byte[string.length()];
            string.getBytes(0, string.length() - 1, byArray, 0);
            return byArray;
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public byte[] getVarBinary() throws SQLException {
        return this.getBinary();
    }

    public byte[] getLongVarBinary() throws SQLException {
        return this.getBinary();
    }

    public Date getDate() throws SQLException {
        return Date.valueOf(this._s.getString());
    }

    public Time getTime() throws SQLException {
        return Time.valueOf(this._s.getString());
    }

    public Timestamp getTimestamp() throws SQLException {
        return Timestamp.valueOf(this._s.getString());
    }
}

