/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.pro;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import symantec.itools.db.net.NetRecord;
import symantec.itools.db.pro.RecordSet;
import symantec.itools.db.pro.RelViewPos;

class RecordTree {
    NetRecord _rec;
    Hashtable _detBlocks;

    RecordTree() {
        this._rec = null;
        this._detBlocks = null;
    }

    RecordTree(NetRecord netRecord) {
        this._rec = netRecord;
        this._detBlocks = null;
    }

    NetRecord getRecord() {
        return this._rec;
    }

    boolean isValidRec() {
        return this._rec != null && this._rec.getState() != 105;
    }

    synchronized void freeRecordBlocks() {
        if (this.isValidRec()) {
            this._rec.setState((byte)105);
        }
        this._rec = null;
        if (this._detBlocks == null) {
            return;
        }
        Enumeration enumeration = this._detBlocks.elements();
        while (enumeration.hasMoreElements()) {
            RecordSet recordSet = (RecordSet)enumeration.nextElement();
            if (recordSet == null) continue;
            recordSet.freeRecordTrees();
        }
        this._detBlocks.clear();
        this._detBlocks = null;
    }

    synchronized RecordSet getRecordSet(RelViewPos relViewPos) throws SQLException {
        RecordSet recordSet = this.getDetailRecordSet(relViewPos);
        if (relViewPos.over()) {
            return recordSet;
        }
        RecordTree recordTree = recordSet.getRecordTree(relViewPos);
        if (!recordTree.isValidRec()) {
            return recordSet;
        }
        return recordTree.getRecordSet(relViewPos.next());
    }

    private RecordSet getDetailRecordSet(RelViewPos relViewPos) {
        Integer n;
        RecordSet recordSet;
        if (this._detBlocks == null) {
            this._detBlocks = new Hashtable();
        }
        if ((recordSet = (RecordSet)this._detBlocks.get(n = new Integer(relViewPos.getID()))) == null) {
            recordSet = new RecordSet(relViewPos.cloneAtCurrentPos());
            this._detBlocks.put(n, recordSet);
        }
        return recordSet;
    }
}

