/*
 * Decompiled with CFR 0.152.
 */
package symantec.itools.db.pro;

import java.io.EOFException;
import java.sql.SQLException;
import java.util.Vector;
import symantec.itools.db.net.BinaryInputStream;
import symantec.itools.db.net.BinaryOutputStream;
import symantec.itools.db.net.NetData;
import symantec.itools.db.net.NetRecord;
import symantec.itools.db.net.Param;
import symantec.itools.db.net.RemoteObject;
import symantec.itools.db.pro.MultiView;
import symantec.itools.db.pro.RelViewInfo;

class RelViewPos {
    Vector _relInfo;
    RelViewInfo _curInfo;
    int _offset;
    MultiView _mv;
    RemoteObject _mvRemObj;

    RelViewPos(MultiView multiView) {
        this._mv = multiView;
        this._relInfo = new Vector();
        this._curInfo = null;
        this._offset = 0;
    }

    MultiView getMultiView() {
        return this._mv;
    }

    RemoteObject getMVRemObj() {
        return this._mvRemObj;
    }

    RelViewPos cloneAtCurrentPos() {
        RelViewPos relViewPos = new RelViewPos(this.getMultiView());
        int n = this._offset;
        while (n > 0) {
            relViewPos.addParentInfo((RelViewInfo)this._relInfo.elementAt(n - 1));
            --n;
        }
        relViewPos.setMVRemObj(this._mvRemObj);
        return relViewPos;
    }

    RelViewPos next() {
        this._curInfo = !this.over() ? (RelViewInfo)this._relInfo.elementAt(this._offset++) : null;
        return this;
    }

    RelViewPos reset() {
        this._offset = 0;
        this._curInfo = null;
        if (this._relInfo.size() > 0) {
            this._curInfo = (RelViewInfo)this._relInfo.elementAt(this._offset++);
        }
        return this;
    }

    boolean over() {
        if (this._curInfo == null) {
            return true;
        }
        return this._curInfo.getRecNum() == 0;
    }

    int getRowsToRequest() {
        if (this._relInfo.size() > 0) {
            RelViewInfo relViewInfo = (RelViewInfo)this._relInfo.elementAt(this._relInfo.size() - 1);
            return relViewInfo.getNumRowsToRequest();
        }
        return 1;
    }

    int getID() {
        return this._curInfo.getID();
    }

    int getRecNum() {
        return this._curInfo.getRecNum();
    }

    int getProxyID() {
        return this._curInfo.getProxyID();
    }

    void addParentInfo(RelViewInfo relViewInfo) {
        this._relInfo.insertElementAt(relViewInfo, 0);
    }

    void setMVRemObj(RemoteObject remoteObject) {
        this._mvRemObj = remoteObject;
    }

    private void addPosInfoToParams(Vector vector) {
        vector.addElement(new Param(0, this._relInfo.size()));
        int n = 0;
        while (n < this._relInfo.size()) {
            RelViewInfo relViewInfo = (RelViewInfo)this._relInfo.elementAt(n);
            vector.addElement(new Param(0, relViewInfo.getProxyID(), true));
            vector.addElement(new Param(0, relViewInfo.getRecNum()));
            ++n;
        }
    }

    int getRemoteStreamID(int n, int n2, boolean bl) throws SQLException {
        Vector<Param> vector = new Vector<Param>();
        vector.addElement(new Param(0, n));
        vector.addElement(new Param(0, n2));
        vector.addElement(new Param(0, bl));
        this.addPosInfoToParams(vector);
        Vector vector2 = this._mvRemObj.invokeMethod(9, vector);
        NetData netData = (NetData)vector2.elementAt(0);
        try {
            return netData.getInt();
        }
        catch (EOFException eOFException) {
            throw new SQLException(eOFException.getMessage());
        }
    }

    BinaryInputStream getRemoteInputStream(int n, int n2) throws SQLException {
        int n3 = this.getRemoteStreamID(n, n2, false);
        return new BinaryInputStream(n3, this._mvRemObj.getSession());
    }

    BinaryOutputStream getRemoteOutputStream(int n, int n2) throws SQLException {
        int n3 = this.getRemoteStreamID(n, n2, true);
        return new BinaryOutputStream(n3, this._mvRemObj.getSession());
    }

    NetRecord getNewServerRecord() throws SQLException {
        if (!this.getMultiView().getSession().isDesignTime()) {
            Vector vector = new Vector();
            this.addPosInfoToParams(vector);
            Vector vector2 = this._mvRemObj.invokeMethod(7, vector);
            return (NetRecord)vector2.elementAt(0);
        }
        return new NetRecord();
    }

    void deleteServerRecord(NetRecord netRecord, int n) throws SQLException {
        if (!this.getMultiView().getSession().isDesignTime()) {
            Vector<Param> vector = new Vector<Param>();
            vector.addElement(new Param(0, n));
            this.addPosInfoToParams(vector);
            this._mvRemObj.invokeMethod(6, vector);
        }
        netRecord.setState((byte)103);
    }

    void undoServerRecord(NetRecord netRecord, int n) throws SQLException {
        if (!this.getMultiView().getSession().isDesignTime()) {
            Vector<Param> vector = new Vector<Param>();
            vector.addElement(new Param(0, n));
            this.addPosInfoToParams(vector);
            Vector vector2 = this._mvRemObj.invokeMethod(5, vector);
            NetRecord netRecord2 = (NetRecord)vector2.elementAt(0);
            netRecord.copy(netRecord2);
        }
    }

    void notifyServerOfDataChange(NetRecord netRecord) throws SQLException {
        if (!this.getMultiView().getSession().isDesignTime()) {
            Vector<NetRecord> vector = new Vector<NetRecord>();
            vector.addElement(netRecord);
            this.addPosInfoToParams(vector);
            this._mvRemObj.invokeMethod(1, vector);
        }
    }

    Vector fetchRecords(int n, int n2) throws SQLException {
        if (!this.getMultiView().getSession().isDesignTime()) {
            Vector<Param> vector = new Vector<Param>();
            vector.addElement(new Param(0, n));
            vector.addElement(new Param(0, n2));
            this.addPosInfoToParams(vector);
            return this._mvRemObj.invokeMethod(0, vector);
        }
        Vector<NetRecord> vector = new Vector<NetRecord>();
        vector.addElement(new NetRecord());
        return vector;
    }
}

