% growthtriangle.m  6/10/2009
%
%  The famous picture of growth rates vs. initial income.




if exist('growthtriangle.log'); delete('growthtriangle.log'); end;
diary growthtriangle.log;
fprintf(['growthtriangle                 ' date]);
disp ' ';
disp ' ';
help growthtriangle

clear;
load pwt61;

yr0=1960-1949;
yr1=2000-1949;

y=rgdpch;
gy=1/(yr1-yr0)*log(y(yr1,:)./y(yr0,:));
gy=gy';

y1960=y(yr0,:)'/y(yr0,USA);

txtclr=[0 0 0.8];  %[0 .25 .25]

figure(1); figsetup;
plotname(y1960,gy,code,10,txtclr);
chadfig('Per capita GDP, 1960 (US=1)','Growth rate, 1960-2000',1,0);
lab='1/32 1/4 1/2 3/4 1';
labs='1/32#1/4#1/2#3/4# 1 ';
set(gca,'XTick',str2num(lab));
set(gca,'XTickLabel',strmat(labs,'#'));
makefigwide;
%wait;
print growthtriangle.eps

diary off;


