% tfpplot.m   12/3/2008  (copied from PF/modelfit.m)
%
% Basic TFPPLOT calculations using PWT61 and BarroLee2000 human capital.


if exist('tfpplot.log'); delete('tfpplot.log'); end;
diary tfpplot.log;
fprintf(['tfpplot                 ' date]);
disp ' ';
disp ' ';
help tfpplot

clear;
load /home/chad/Work/Data/PWT61/pwt61;

d=.05
gK=.05
stopit=1   % Set to 1 to pause to move labels around

yr0=1960-1949;
yr1=2000-1949;

y=rgdpch;
y2000=y(yr1,:)';
K=zeros(yr1-yr0,size(y,2));
invest=ki/100.*rgdpl.*pop;  % Quantity of investment
invest=invest(yr0:yr1,:);

% For capital:  Assume 1960=SS and use perpetual inventory method.
K0=(invest(yr0,:).*invest(yr0+1,:)).^(1/2) / (gK+d);
K(1,:)=K0;
for t=1:(yr1-yr0);
  K(t+1,:)=(1-d)*K(t,:)+invest(t,:);
end;
k=K./pop(yr0:yr1,:);

k2000=k(size(k,1),:)';
sK=mean(ki(yr0:yr1,:))';  % Average investment rate
ky=k2000./y2000;   % Capital output ratio in 2000.

% Now plot:  these two should be highly correlated:
figure(1); clf;
plotname(sK,ky,code);
chadfig('sK','K/Y',1,0);

kk=k2000/k2000(USA); % Normalize so US=1
yy=y2000/y2000(USA);

%%%%%%%%%%%%%%%%%%%5
%  Now, let's compute the productivity differences
% First, we load the BarroLee data on human capital
load /home/chad/Work/Data/BarroLee2000/BarroLee200061;

%                       School       phi
%                       0 - 4       13.4
%                       4 - 8       10.1
%                       8 - x        6.8
%  (from Psacharopoulos -- rough numbers).
rorE=[.134 .101 .068]'


h15=hnew15(:,9);  % 2000 estimate
h25=hnew25(:,9);
S=max([h15 h25]')';  % Take the larger of the two values for each country

% First, break S into the three categories
S1=S-4; S1=replace(S1,S1>0,4); S1=replace(S1,S1<=0,S1+4);
S2=S-4; S2=replace(S2,S2<0,0); S2=replace(S2,S2>4,4);
S3=S-8; S3=replace(S3,S3<0,0);

SS=[S1 S2 S3];
logHL = SS*rorE;
h=exp(logHL);
hh=h/h(USA);

ky=ky/ky(USA);


%  Y=A*k^a h^(1-a)
%   y=A*(k/y)^a/1-a*h

a=1/3;
A=yy./hh./ky.^(a/(1-a));

disp ' '; disp ' '; disp 'Data for Table';
data=[yy ky.^(a/(1-a)) hh A];
cshow(names,data,'%10.3f','y ky^1/2 h A');




figure(2); clf;
plotname(log(yy),log(A),code,12,'b');
axlabel='1/64 1/32 1/16 1/8 1/4 1/2 1';
labs=strmat(axlabel);
logval=log(str2num(axlabel));
set(gca,'XTick',logval);
set(gca,'XTickLabel',labs);
axlabel='1/32 1/16 1/8 1/4 1/2 1';
labs=strmat(axlabel);
logval=log(str2num(axlabel));
set(gca,'YTick',logval);
set(gca,'YTickLabel',labs);
chadfig('Per Capita GDP, 2000','Total Factor Productivity, 2000',1,1);
ax=axis; ax(2)=log(1.3); ax(4)=log(1.3); axis(ax);
wait;
print tfpplot.eps 



diary off;


