% trade.m   1/1/2009
%
% Basic TRADE share over time for world


if exist('trade.log'); delete('trade.log'); end;
diary trade.log;
fprintf(['trade                 ' date]);
disp ' ';
disp ' ';
help trade

clear;
%load /home/chad/Work/Data/PWT61/pwt61;
load pwt61;


%yrs=(1950:2000)';  % 50
%yrs=(1950:1998)';  % 51
yrs=(1960:1999)';  % 107

ctys=sum(openc(yrs-1949,:))';
ctys=~isnan(ctys);   % Must have openc in every year
fprintf('Number of countries: %4.0f\n',sum(ctys));
say(code(ctys,:));
disp ' '; disp ' ';


ts=mean(openc(yrs-1949,ctys)')';
figure(1); clf;
plot(yrs,ts,'b-');
chadfig('Year','Exports + Imports / GDP',1,0);

makefigwide;
%wait;
print trade.eps


% Alternatively, let's compute total Exports+Imports / World GDP
% CGDP is per capita 

gdp=cgdp.*pop;
xm=openc.*gdp;

gdpW=sum(gdp(yrs-1949,ctys)')';
xmW=sum(xm(yrs-1949,ctys)')';
tsW=xmW./gdpW;

figure(2); clf;
plot(yrs,tsW,'b-');
chadfig('Year','World Exports + Imports / World GDP',1,0);

makefigwide;
%wait;
print tradeW.eps

cshow(' ',[yrs ts tsW],'%6.0f %8.2f','Year ts tsW');


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FDI

% World Bank: World Development Indicators
%   See WorldBankFDI.xls
% Data are for "World" aggregate.
%Foreign direct investment, net inflows (BoP, current US$)
%GDP (current US$)
%
%  Share = FDI/GDP * 100

data=[
1965	0.0927
1966	0.0896
1967	0.1032
1968	0.1035
1969	0.1103
1970	0.3446
1971	0.3731
1972	0.3241
1973	0.3848
1974	0.3613
1975	0.4433
1976	0.3157
1977	0.3822
1978	0.4071
1979	0.4339
1980	0.4983
1981	0.6150
1982	0.4987
1983	0.4323
1984	0.4851
1985	0.4570
1986	0.5856
1987	0.7787
1988	0.8498
1989	0.9965
1990	0.9371
1991	0.6846
1992	0.6840
1993	0.8840
1994	0.9295
1995	1.1068
1996	1.2343
1997	1.5505
1998	2.3261
1999	3.5288
2000	4.7526
2001	2.5138
2002	2.2362
2003	1.7468
2004	1.8560
2005	2.3294
2006	2.7813
];

fyrs=data(:,1);
fdishare=data(:,2);



yy=(1966:10:2006)'-1964;
figure(3); figsetup;
%[ax,h1,h2]=plotyy(yrs,tsW,fyrs(yy),fdishare(yy),'plot','plotfdi');
[ax,h1,h2]=plotyy(yrs,tsW,fyrs(yy),fdishare(yy));
makefigwide;
set(h2,'Marker','o');

text(1970,40,mlstring('World Trade / World GDP\\    (percent)'),'Color','b');
text(1991,26,mlstring('World FDI / World GDP\\    (percent)'),'Color',get(h2,'Color'));
set(gca,'Box','off');
print trade.eps






diary off;