% verylongrun.m  -- 3/29/05
%
%  Figure of very long run per capita gdp, from maddison2005.xls
%  (downloaded from his web page today)
%
%    http://www.eco.rug.nl/~Maddison/

if exist('verylongrun.log'); delete('verylongrun.log'); end;
diary verylongrun.log;
fprintf(['verylongrun                 ' date]);
disp ' ';
disp ' ';
help verylongrun


% Western Europe (12 countries) data -- Maddison 2008 spreadsheet from Oct 2008
%  See maddison2008.xls
%  http://www.ggdc.net/maddison/

%	GDP per person		Population
%			
%	12 W. Europe		12 W. Europe
data=[
1	599		18600
1000	425		19700
1500	798		48192
1600	907		62580
1700	1032		68796
1820	1243		114571
1850	1658		143615
1870	2087		162386
%1890	2643		187219
1900	3076		203501
%1910	3380		223009
1920	3304		223731
%1930	4288		235975
1940	4984		248417
%1950	5018		256376
1960	7607		273807
%1970	10959		295723
1980	14056		305157
%1990	16870		312802
2000	20102		324285
2006	21784		328938
];


%  The West (Western Europe + US)
%   Year Pop GDP GDPPC
data=[
%1	19280	11418	592
1	19280	11418	423    % Assume zero growth before 1000 instead!
1000	21000	8886	423
1500	50192	39250	782
1600	64080	57384	896
1700	69796	71515	1025
1820	124552	154947	1244
1850	167195	280735	1679
1870	202627	437352	2158
1890	250521	709474	2832
1900	279892	938521	3353
1910	315776	1214164	3845
1920	330612	1332739	4031
1930	359643	1780115	4950
1940	381054	2167753	5689
1950	408647	2742350	6711
1960	454478	4129622	9087
1970	500775	6322646	12626
1980	532883	8519788	15988
1990	562934	11080055	19683
2000	606624	14550849	23987
2006	627382	16432006	26191
];

% Western europe
%yrs=data(:,1);
%gdppc=data(:,2)/1000;
%pop=data(:,3);

% The "West"
yrs=data(:,1);
gdppc=data(:,4)/1000;
pop=data(:,2);

gdppc=gdppc/gdppc(1)*1; % Normalize to 1 in year 1
pop=pop/pop(1)*1; % Normalize to 1 in year 1.
disp 'population normalized to 1 in year 1';

mygreen=[0 .6 .4];

% figure(1); clf;
% plot(yrs,log(pop),'-','Color',mygreen);
% hold on;
% plotlog(yrs,gdppc,'-','0.5 1 2 4 8 16 32 64')
% chadfig('Year','Log Scale, Initialized to 1.0',1,1)
% ax=axis; ax(2)=2010; ax(4)=log(70); axis(ax);
% text(1000,log(3),'Population','Color',mygreen);
% text(1600,log(1.2),'Per capita GDP','Color','b');
% set(gca,'YGrid','on')
% makefigwide;
% wait;
% print verylongrun.eps


figure(1); figsetup;
plot(yrs,log(pop),'--','Color',mygreen,'LineWidth',2);
hold on;
axlabel='0.5 1 2 4 8 16 32 64';
plot(yrs,log(gdppc),'-','LineWidth',4');
chadfig('Year','Log Scale, Initialized to 1.0',1,1)
   logval=log(str2num(axlabel));
   set(gca,'YTick',logval);
   set(gca,'YTickLabel',strmat(axlabel));
ax=axis; ax(2)=2010; ax(3)=log(.8); ax(4)=log(70); axis(ax);
text(1000,log(3),'Population','Color',mygreen,'FontWeight','bold');
text(1600,log(1.3),'Per capita GDP','Color','b','FontWeight','bold');
set(gca,'YGrid','on')
makefigwide;
wait;
print verylongrun.eps

cshow(' ',[yrs gdppc pop],'%7.0f %8.2f','Year GDPPC Pop');



diary off;
