% BasicMechanism.m   10/10/14
%
%  Make the basic mechanism graph in matlab. Random walk with drift plus death.

definecolors;

%sigma=0.02
sigma=0

%rng(25)
rng(30)
T=30;
T2=8;
x0=1;
g=.05+sigma*randn(T,1);
g=[0; g];
g2=.05+sigma*randn(T2,1);
g2=[0; g2];

t=(1:T)';
t2=(T:(T+T2))';
x= x0*exp(cumsum(g)); 
x2=x0*exp(cumsum(g2));

LW=4;

t=(1:length(x))';
figure(1); figsetup;
plot([0 T+T2],[x0 x0],'--','Color',mygreen,'LineWidth',1.5); hold on;
plot([T+1 T+1],[x0 x(T+1)],'--','Color',myred,'LineWidth',1.5);
plot(t,x,'-','Color',myblue,'LineWidth',LW);
plot(t2+1,x2,'-','Color',myblue,'LineWidth',LW);
ax=axis; ax(3)=0.5; axis(ax);
chadgraph2('Time','Income',1,0);
makefigwide
set(gca,'YTick',x0,'YTickLabel','Initial');
text(T+1.8,2.9,mlstring('Creative\\   destruction'),'Color',myred);
text(T/2-4,2.7,mlstring('Exponential\\   growth'),'Color',myblue);
print BasicMechanismMatlab.eps