% FractalInequality    8/15/12
%
%   Fractal inequality graph for US, from World Top Inequality Database


if exist('FractalInequality.log'); delete('FractalInequality.log'); end;
diary FractalInequality.log;
fprintf(['FractalInequality                 ' date]);
disp ' ';
disp ' ';
help FractalInequality

clear;
load WorldTopInequalityDatabase2016;

% s1=10/100
% s2=1/10
% s3=.1/1
% s4=.01/.1    ==> b/a=10 for all groups!

s1=is10(:,USA)/100;
s2=is01(:,USA)./is10(:,USA);
s3=is001(:,USA)./is01(:,USA);
s4=is0001(:,USA)./is001(:,USA);

T=2015;
yrs=(1950:T)';
yy=yrs-yr0;

definecolors;

figure(1); figsetup;
%plot(yrs,100*s1(yy),'-','Color','b'); hold on;
plot(yrs,100*s2(yy),'-','Color',mygreen,'LineWidth',LW); hold on;
plot(yrs,100*s3(yy),'-','Color',mypurp,'LineWidth',LW);
plot(yrs,100*s4(yy),'-','Color',myblue,'LineWidth',LW);
ax=axis; ax(2)=T+1; axis(ax);
chadfig2('Year','Fractal shares (percent)',1,0);
makefigwide;
%text(1960,34,'S(10)','Color','b');
text(1985,25,'S(1)','Color',mygreen);
text(1963,22,'S(.1)','Color',mypurp);
text(1968,29,'S(.01)','Color',myblue);
print FractalInequalityS.eps

figure(2); figsetup;
%plot(yrs,1+log10(s1(yy)),'-','Color','b'); hold on;
plot(yrs,1+log10(s2(yy)),'-','Color',mygreen,'LineWidth',LW); hold on;
plot(yrs,1+log10(s3(yy)),'-','Color',mypurp,'LineWidth',LW);
plot(yrs,1+log10(s4(yy)),'-','Color',myblue,'LineWidth',LW);
ax=axis; ax(2)=T+1; axis(ax);
chadfig2('Year','1 + log_{10}(top share)',1,0);
makefigwide;
%text(1960,.53,'\eta(10)','Color','b');
text(1985,.40,'\eta(1)','Color',mygreen);
text(1963,.37,'\eta(.1)','Color',mypurp);
text(1968,.46,'\eta(.01)','Color',myblue);
print FractalInequalityEta.eps

eta=1+log10(s3(yy));
cshow(' ',[yrs eta],'%6.0f %8.4f','Year eta.1');


diary off;
