% GuvenenGrowthRateFigure
%
% Create my own version of Fatih's "double Pareto" graph of the distribution of growth rates.
% In particular, do this for the 90th percentile of the earnings distribution (I think he uses
% the entire distribution)

diarychad('GuvenenGrowthRateFigure')
clear all;
definecolors;

data=[
%P90	
%Log earnings change 1995--1996	Density
-4.9798	0.00303
-4.9634	0.00376
-4.9469	0.00230
-4.9305	0.00000
-4.9141	0.00000
-4.8976	0.00000
-4.8812	0.00000
-4.8648	0.00000
-4.8483	0.00000
-4.8319	0.00000
-4.8155	0.00000
-4.7990	0.00000
-4.7826	0.00000
-4.7662	0.00000
-4.7497	0.00000
-4.7333	0.00000
-4.7169	0.00000
-4.7004	0.00000
-4.6840	0.00000
-4.6676	0.00000
-4.6511	0.00000
-4.6347	0.00000
-4.6183	0.00000
-4.6018	0.00000
-4.5854	0.00000
-4.5690	0.00000
-4.5525	0.00000
-4.5361	0.00000
-4.5197	0.00000
-4.5032	0.00000
-4.4868	0.00000
-4.4704	0.00000
-4.4539	0.00000
-4.4375	0.00000
-4.4211	0.00000
-4.4046	0.00000
-4.3882	0.00000
-4.3718	0.00000
-4.3553	0.00000
-4.3389	0.00000
-4.3225	0.00000
-4.3060	0.00000
-4.2896	0.00000
-4.2732	0.00000
-4.2567	0.00000
-4.2403	0.00000
-4.2239	0.00000
-4.2074	0.00000
-4.1910	0.00000
-4.1746	0.00000
-4.1581	0.00000
-4.1417	0.00000
-4.1253	0.00133
-4.1088	0.00351
-4.0924	0.00352
-4.0760	0.00134
-4.0595	0.00000
-4.0431	0.00000
-4.0267	0.00000
-4.0102	0.00000
-3.9938	0.00000
-3.9774	0.00274
-3.9609	0.00379
-3.9445	0.00384
-3.9281	0.00346
-3.9116	0.00640
-3.8952	0.00652
-3.8788	0.00604
-3.8623	0.00354
-3.8459	0.00141
-3.8295	0.00000
-3.8130	0.00000
-3.7966	0.00000
-3.7802	0.00516
-3.7637	0.00754
-3.7473	0.00556
-3.7309	0.00010
-3.7144	0.00000
-3.6980	0.00000
-3.6816	0.00000
-3.6651	0.00000
-3.6487	0.00000
-3.6323	0.00000
-3.6158	0.00000
-3.5994	0.00000
-3.5830	0.00000
-3.5665	0.00000
-3.5501	0.00000
-3.5336	0.00000
-3.5172	0.00000
-3.5008	0.00031
-3.4843	0.00312
-3.4679	0.00374
-3.4515	0.00218
-3.4350	0.00000
-3.4186	0.00000
-3.4022	0.00000
-3.3857	0.00000
-3.3693	0.00000
-3.3529	0.00134
-3.3364	0.00654
-3.3200	0.00737
-3.3036	0.00383
-3.2871	0.00000
-3.2707	0.00000
-3.2543	0.00000
-3.2378	0.00000
-3.2214	0.00000
-3.2050	0.00000
-3.1885	0.00000
-3.1721	0.00255
-3.1557	0.00378
-3.1392	0.00284
-3.1228	0.00000
-3.1064	0.00000
-3.0899	0.00000
-3.0735	0.00271
-3.0571	0.00379
-3.0406	0.00269
-3.0242	0.00000
-3.0078	0.00000
-2.9913	0.00000
-2.9749	0.00000
-2.9585	0.00000
-2.9420	0.00000
-2.9256	0.00000
-2.9092	0.00222
-2.8927	0.00375
-2.8763	0.00309
-2.8599	0.00025
-2.8434	0.00158
-2.8270	0.00359
-2.8106	0.00343
-2.7941	0.00107
-2.7777	0.00055
-2.7613	0.00569
-2.7448	0.00748
-2.7284	0.00491
-2.7120	0.00000
-2.6955	0.00000
-2.6791	0.00242
-2.6627	0.00377
-2.6462	0.00295
-2.6298	0.00000
-2.6134	0.00000
-2.5969	0.00000
-2.5805	0.00243
-2.5641	0.00377
-2.5476	0.00293
-2.5312	0.00000
-2.5148	0.00000
-2.4983	0.00283
-2.4819	0.00477
-2.4655	0.00595
-2.4490	0.00536
-2.4326	0.00530
-2.4162	0.00602
-2.3997	0.00643
-2.3833	0.00637
-2.3669	0.00335
-2.3504	0.00088
-2.3340	0.00000
-2.3176	0.00000
-2.3011	0.00000
-2.2847	0.00000
-2.2683	0.00000
-2.2518	0.00000
-2.2354	0.00485
-2.2190	0.00991
-2.2025	0.00946
-2.1861	0.00870
-2.1697	0.01030
-2.1532	0.00946
-2.1368	0.00266
-2.1204	0.00000
-2.1039	0.00106
-2.0875	0.00521
-2.0711	0.00725
-2.0546	0.00493
-2.0382	0.00240
-2.0218	0.00359
-2.0053	0.00343
-1.9889	0.00109
-1.9725	0.00000
-1.9560	0.00000
-1.9396	0.00254
-1.9232	0.00564
-1.9067	0.00651
-1.8903	0.00330
-1.8739	0.00368
-1.8574	0.00586
-1.8410	0.00617
-1.8245	0.00317
-1.8081	0.00192
-1.7917	0.00649
-1.7752	0.01028
-1.7588	0.01337
-1.7424	0.01068
-1.7259	0.00507
-1.7095	0.00148
-1.6931	0.00928
-1.6766	0.02110
-1.6602	0.02208
-1.6438	0.01121
-1.6273	0.00457
-1.6109	0.00598
-1.5945	0.00898
-1.5780	0.00938
-1.5616	0.00958
-1.5452	0.00697
-1.5287	0.00265
-1.5123	0.00501
-1.4959	0.01889
-1.4794	0.02950
-1.4630	0.03029
-1.4466	0.01941
-1.4301	0.01429
-1.4137	0.00961
-1.3973	0.01955
-1.3808	0.02401
-1.3644	0.02159
-1.3480	0.01737
-1.3315	0.02185
-1.3151	0.02060
-1.2987	0.01207
-1.2822	0.01030
-1.2658	0.01570
-1.2494	0.02526
-1.2329	0.02912
-1.2165	0.02358
-1.2001	0.02698
-1.1836	0.02979
-1.1672	0.02469
-1.1508	0.01845
-1.1343	0.03253
-1.1179	0.05258
-1.1015	0.06693
-1.0850	0.07234
-1.0686	0.07924
-1.0522	0.08704
-1.0357	0.08493
-1.0193	0.06105
-1.0029	0.04693
-0.9864	0.04724
-0.9700	0.04615
-0.9536	0.03824
-0.9371	0.03940
-0.9207	0.04459
-0.9043	0.04231
-0.8878	0.03621
-0.8714	0.03818
-0.8550	0.04258
-0.8385	0.04491
-0.8221	0.03673
-0.8057	0.02724
-0.7892	0.02927
-0.7728	0.04221
-0.7564	0.06214
-0.7399	0.06936
-0.7235	0.06542
-0.7071	0.07221
-0.6906	0.08937
-0.6742	0.08908
-0.6578	0.08213
-0.6413	0.07651
-0.6249	0.06882
-0.6085	0.06180
-0.5920	0.07362
-0.5756	0.08651
-0.5592	0.08771
-0.5427	0.08316
-0.5263	0.08006
-0.5099	0.07729
-0.4934	0.07779
-0.4770	0.08676
-0.4606	0.08707
-0.4441	0.09674
-0.4277	0.09845
-0.4113	0.10095
-0.3948	0.11351
-0.3784	0.14845
-0.3620	0.13098
-0.3455	0.10909
-0.3291	0.10245
-0.3127	0.14505
-0.2962	0.18620
-0.2798	0.21196
-0.2634	0.22163
-0.2469	0.24800
-0.2305	0.26494
-0.2141	0.28887
-0.1976	0.34669
-0.1812	0.41229
-0.1648	0.45521
-0.1483	0.53095
-0.1319	0.63562
-0.1154	0.78154
-0.0990	0.88324
-0.0826	1.05051
-0.0661	1.31705
-0.0497	1.69710
-0.0333	2.23145
-0.0168	3.10515
-0.0004	4.38896
0.0160	5.50036
0.0325	5.58893
0.0489	4.66497
0.0653	3.53257
0.0818	2.75109
0.0982	2.09811
0.1146	1.62058
0.1311	1.25780
0.1475	1.01148
0.1639	0.84115
0.1804	0.71695
0.1968	0.58589
0.2132	0.50090
0.2297	0.47536
0.2461	0.41828
0.2625	0.35989
0.2790	0.30605
0.2954	0.26332
0.3118	0.20962
0.3283	0.19737
0.3447	0.18772
0.3611	0.19143
0.3776	0.18157
0.3940	0.17075
0.4104	0.13588
0.4269	0.13029
0.4433	0.12901
0.4597	0.12142
0.4762	0.09952
0.4926	0.09819
0.5090	0.10501
0.5255	0.09801
0.5419	0.07729
0.5583	0.07757
0.5748	0.09051
0.5912	0.08373
0.6076	0.07331
0.6241	0.06221
0.6405	0.06147
0.6569	0.06610
0.6734	0.07641
0.6898	0.07648
0.7062	0.07215
0.7227	0.07150
0.7391	0.07184
0.7555	0.07155
0.7720	0.05923
0.7884	0.04796
0.8048	0.04360
0.8213	0.04509
0.8377	0.04718
0.8541	0.03996
0.8706	0.03090
0.8870	0.01805
0.9034	0.01510
0.9199	0.01312
0.9363	0.02060
0.9527	0.03842
0.9692	0.04884
0.9856	0.04457
1.0020	0.03873
1.0185	0.04128
1.0349	0.03929
1.0513	0.03447
1.0678	0.02828
1.0842	0.03254
1.1006	0.04502
1.1171	0.05651
1.1335	0.05403
1.1499	0.04683
1.1664	0.03909
1.1828	0.02749
1.1992	0.01922
1.2157	0.01422
1.2321	0.01053
1.2485	0.01071
1.2650	0.00868
1.2814	0.00965
1.2978	0.01202
1.3143	0.01521
1.3307	0.01655
1.3471	0.01707
1.3636	0.01469
1.3800	0.00821
1.3964	0.00356
1.4129	0.00558
1.4293	0.01042
1.4457	0.01082
1.4622	0.00634
1.4786	0.00327
1.4950	0.00070
1.5115	0.00299
1.5279	0.00377
1.5443	0.00236
1.5608	0.00266
1.5772	0.00393
1.5937	0.00729
1.6101	0.01087
1.6265	0.01304
1.6430	0.00783
1.6594	0.00170
1.6758	0.00000
1.6923	0.00000
1.7087	0.00000
1.7251	0.00278
1.7416	0.01231
1.7580	0.01457
1.7744	0.00934
1.7909	0.00372
1.8073	0.00355
1.8237	0.00143
1.8402	0.00000
1.8566	0.00000
1.8730	0.00000
1.8895	0.00385
1.9059	0.00854
1.9223	0.00998
1.9388	0.00487
1.9552	0.00149
1.9716	0.00000
1.9881	0.00000
2.0045	0.00058
2.0209	0.00323
2.0374	0.00370
2.0538	0.00199
2.0702	0.00000
2.0867	0.00000
2.1031	0.00000
2.1195	0.00000
2.1360	0.00000
2.1524	0.00000
2.1688	0.00100
2.1853	0.00340
2.2017	0.00361
2.2181	0.00165
2.2346	0.00000
2.2510	0.00000
2.2674	0.00000
2.2839	0.00000
2.3003	0.00000
2.3167	0.00000
2.3332	0.00000
2.3496	0.00000
2.3660	0.00000
2.3825	0.00000
2.3989	0.00000
2.4153	0.00000
2.4318	0.00000
2.4482	0.00283
2.4646	0.00379
2.4811	0.00256
2.4975	0.00000
2.5139	0.00000
2.5304	0.00000
2.5468	0.00000
2.5632	0.00000
2.5797	0.00000
2.5961	0.00000
2.6125	0.00000
2.6290	0.00000
2.6454	0.00000
2.6618	0.00000
2.6783	0.00000
2.6947	0.00000
2.7111	0.00000
2.7276	0.00000
2.7440	0.00000
2.7604	0.00000
2.7769	0.00000
2.7933	0.00000
2.8097	0.00000
2.8262	0.00000
2.8426	0.00041
2.8590	0.00316
2.8755	0.00373
2.8919	0.00211
2.9083	0.00000
2.9248	0.00000
2.9412	0.00000
2.9576	0.00000
2.9741	0.00000
2.9905	0.00000
3.0069	0.00000
3.0234	0.00000
3.0398	0.00000
3.0562	0.00000
3.0727	0.00000
3.0891	0.00000
3.1055	0.00000
3.1220	0.00000
3.1384	0.00000
3.1548	0.00000
3.1713	0.00000
3.1877	0.00230
3.2041	0.00376
3.2206	0.00303
];

g=data(:,1);
pdf=data(:,2);
logpdf=log(pdf);
cdf=cumsum(pdf)/sum(pdf);

LW=4;

figure(2); figsetup;
i=(pdf~=0);
plot(g(i),logpdf(i),'-','Color',myblue,'LineWidth',LW);
chadfig2('Annual log change, 1995-96','Log Density',1,0);
makefigwide;
print GuvenenGrowthRateFigureB.eps

figure(3); figsetup;
i=(pdf~=0);
plot(g(i),smooth(logpdf(i),10),'-','Color',myblue,'LineWidth',LW);
chadfig2('Annual log change, 1995-96','Log Density',1,0);
makefigwide;
print GuvenenGrowthRateFigureC.eps

figure1 = figure(1); figsetup;
plot(g,pdf,'-','Color',myblue,'LineWidth',LW);
chadfig2('Annual log change, 1995-96','Density',1,0);
makefigwide;
mycolor=0.8*mygreen;
yi=.2; rot=80; 
axes1=get(gca);

i99=find(cdf>.99); i99=i99(1);
plot(g(i99),pdf(i99),'o','Color',mycolor,'LineWidth',LW);
txt=sprintf('1 in 100: rise by a factor of %3.1f',exp(g(i99)));
text(g(i99),yi,txt,'Color',mycolor,'Rotation',rot);

i999=find(cdf>.999); i999=i999(1);
plot(g(i999),pdf(i999),'o','Color',mycolor,'LineWidth',LW);
txt=sprintf('1 in 1,000: rise by a factor of %3.1f',exp(g(i999)));
text(g(i999),yi,txt,'Color',mycolor,'Rotation',rot);

i9999=find(cdf>.9999); i9999=i9999(1);
plot(g(i9999),pdf(i9999),'o','Color',mycolor,'LineWidth',LW);
txt=sprintf('1 in 10,000: rise by a factor of %3.1f',exp(g(i9999)));
text(g(i9999),yi,txt,'Color',mycolor,'Rotation',rot);


% Latex stuff, via Jihee
% Create textbox
myp=[0.498 0 0.498];
annotation(figure1,'textbox',...
    [0.64 0.70 0.238 0.1162],...
    'Interpreter','latex',...
    'String',{'$\overbrace{\hspace{1.1in}}_{ }$'},...
    'FontSize',20,...
    'FitBoxToText','off',...
    'LineStyle','none',...
    'Color',myp);

% Create textbox
annotation(figure1,'textbox',...
    [0.72 0.82 0.288 0.057],...
    'Interpreter','latex',...
    'String',{'\textbf{$\Rightarrow$ $\tilde{\mu}_{\scriptscriptstyle{H}}$}'},...
    'FontWeight','bold',...
    'FontSize',18,...
    'LineStyle','none',...
    'Color',myp);

% Create textbox
annotation(figure1,'textbox',...
    [0.288 0.221 0.128 0.068],...
    'Interpreter','latex',...
    'String',{'  $\Rightarrow$ $\bar\delta+\delta$'},...
    'FontWeight','bold',...
    'FontSize',18,...
    'LineStyle','none',...
    'Color',myp);

% Create textbox
annotation(figure1,'textbox',...
    [0.210 0.073 0.398 0.159],...
    'Interpreter','latex',...
    'String',{'$\overbrace{\hspace{1.2in}}{ }$'},...
    'FontSize',20,...
    'FitBoxToText','off',...
    'LineStyle','none',...
    'Color',myp);




%print GuvenenGrowthRateFigureA.eps
print GuvenenGrowthRateFigure.eps
