% LorenzGraphs.m  
%
%  Loads the x1980Results and x2005Results files produced on NBER
%  (in LorenzData.m)
%  and creates nice plots of the zmean/z in the Saez (2001) style.


if exist('LorenzGraphs.log'); delete('LorenzGraphs.log'); end;
diary LorenzGraphs.log;
fprintf(['LorenzGraphs                 ' date]);
disp ' ';
disp ' ';
help LorenzGraphs

clear;
load x1980Lorenz.asc;
Lorenz1980=x1980Lorenz;
load x2005Lorenz.asc;
Lorenz2005=x2005Lorenz;

tle='Prctile Income zmean/z Obs TotWeight';
fmt='%9.2f %15.0f %10.6f %8.0f %12.0f';
disp '1980 Results';
cshow(' ',Lorenz1980,fmt,tle);
disp ' '; disp ' ';
disp '2005 Results';
cshow(' ',Lorenz2005,fmt,tle);


%xlab='Wage income cutoff, z'
xlab='Wage + entrepreneurial income cutoff, z'

% Linear axis, up to 1m
vals=(0:500:3000)*1000;
labs={'$0' '$500k' '$1.0m' '$1.5m' '$2.0m' '$2.5m' '$3.0m'};
TopEnd=3.26*10^6
smpl1980=Lorenz1980(:,2)<=TopEnd;
smpl2005=Lorenz2005(:,2)<=TopEnd;
figure(1); figsetup;
plot(Lorenz2005(smpl2005,2),Lorenz2005(smpl2005,3),'b-');
hold on;
plot(Lorenz1980(smpl1980,2),Lorenz1980(smpl1980,3),'-','Color',[0 .6 .4]);
relabelaxis(vals,labs,'x');
ax=axis; ax(2)=TopEnd; axis(ax);
chadfig2(xlab,'Income ratio: Mean( y | y>z ) / z',1,0);
text((1.2*10^6),3.0,'2005','Color','b');
text((1.65*10^6),1.4,'1980','Color',[0 .6 .4]);
makefigwide
wait
print LorenzGraphs1.eps


% Full plot, log10 axis
vals=log10([10 100 1000 10^4 10^5]*1000);
labs={'$10k' '$100k' '$1m' '$10m' '$100m'};
figure(2); figsetup;
plot(log10(Lorenz2005(:,2)),Lorenz2005(:,3),'b-');
hold on;
plot(log10(Lorenz1980(:,2)),Lorenz1980(:,3),'-','Color',[0 .6 .4]);
relabelaxis(vals,labs,'x')
chadfig2(xlab,'Income ratio: Mean( y | y>z ) / z',1,0);
text(log10(10^6),3.0,'2005','Color','b');
text(log10(3*10^6),1.3,'1980','Color',[0 .6 .4]);
makefigwide
print LorenzGraphs2.eps


% Now do the same, but only show values based on at least 100 observations

smpl1980=Lorenz1980(:,4)>=100;
smpl2005=Lorenz2005(:,4)>=100;
vals=log10([10 100 1000 10^4 10^5]*1000);
labs={'$10k' '$100k' '$1m' '$10m' '$100m'};
figure(2); figsetup;
plot(log10(Lorenz2005(smpl2005,2)),Lorenz2005(smpl2005,3),'b-');
hold on;
plot(log10(Lorenz1980(smpl1980,2)),Lorenz1980(smpl1980,3),'-','Color',[0 .6 .4]);
relabelaxis(vals,labs,'x')
ax=axis; ax(2)=log10(16*10^6); axis(ax);
chadfig2(xlab,'Income ratio: Mean( y | y>z ) / z',1,0);
text(log10(10^6),3.1,'2005','Color','b');
text(log10(3*10^6),1.5,'1980','Color',[0 .6 .4]);
makefigwide
wait
print LorenzGraphs3.eps



diary off;

