% SSInequalitySolving.m   
%
%  Summarizes the results from PanelMuH.m into a "1980" and "1990" data point
%  for easy reference. Also creates graphs with HP filter.
%
%  The "Solving" version re-solves for eta so that we can change pbar as desired.

diarychad('SSInequalitySolving');


clear
load PanelMuHResults;  % From PanelMuH.m

% MainParameters=[
%  IncPctile DeltaDrop IncomeType
%     95         40       1
%     95         40       0
%     95         40       2
%     90         40       1
%     97         40       1
%     95         50       1
%     ];

deltaCD=.02      % Endogenous creative destruction (constant over time)
pbar = .8


IncomeTypeStr={'Wages and Salaries           ',
               'Wages/Salaries + Entr. Income',
               'Entrepreneurial Income only  '};
Years=Years+1;
NumToAverage=2;
eta=zeros(T,NumberAlternatives)*NaN;

%    Params(t,:)=[mutildeH sigmaH delta eta]; Nobs(t)=n;
%    Results(:,:,i)=[Years+1 Params etaAlt Nobs];

disp 'IRS Data -- Estimates of Eta';
fprintf('  (Averages over %1.0f years)\n',NumToAverage);
disp '                                                   ---- Eta ----'
disp '                                                   1980     1990';
disp '----------------------------------------------------------------';
%fmt='%9.0f %9.0f %9.4f %9.4f %9.4f %9.4f';
fmt='%9.0f %9.0f %9.2f %9.2f';
for i=1:NumberAlternatives;
    IncPctileCutoff=MainParameters(i,1);
    DeltaDrop=MainParameters(i,2);
    IncomeType=MainParameters(i,3);
    
    mutildeH=Results(:,2,i); 
    sigmaH=Results(:,3,i);
    deltaBoth=Results(:,4,i);
    deltabar=deltaBoth-deltaCD;
    if deltabar<0.01; 
        disp 'PROBLEM: deltabar<0.01 in panelmuH.m. Setting deltabar=.01...';
        deltabar=.01
    end;
    mm=mutildeH./sigmaH.^2;
    squig=-mm+sqrt(mm.^2+2*(deltabar+pbar)./sigmaH.^2);
    eta(:,i)=1./squig;
    
    eta1980=mean(eta(1:NumToAverage,i));  
    eta1990=mean(eta((end-NumToAverage+1):end,i));  
    cshow(IncomeTypeStr{IncomeType+1},[IncPctileCutoff DeltaDrop eta1980 eta1990],fmt,[],[],1);
    
    % cshow(' ',[Years Results(:,5,i) eta(:,i)],'%6.0f %8.4f','Year etaPanelMu etaSS');
    % disp 'These should be the same if pbar=1...';
    % disp ' ';
end;
disp ' ';
disp '(Note: 1st number like 95 is the Income Percentile cutoff';
disp '       2nd number life 40 is the DeltaDrop cutoff.)';
disp ' '; disp ' ';


definecolors;
figure(1); figsetup; makefigwide;
plot(Years,eta(:,1),'-','Color',myblue,'LineWidth',LW);
plot(Years,eta(:,2),'-','Color',mygreen,'LineWidth',LW);
plot(Years,eta(:,3),'-','Color',mypurp,'LineWidth',LW);
chadfig2('Year','Pareto Inequality,\eta',1,0);
print('-depsc','SSInequalitySolvingIRS');


HPsmoother=1

figure(2); figsetup; makefigwide;
plot(Years,hpfilter(eta(:,1),HPsmoother),'-','Color',myblue,'LineWidth',LW);
plot(Years,hpfilter(eta(:,2),HPsmoother),'-','Color',mygreen,'LineWidth',LW);
plot(Years,hpfilter(eta(:,3),HPsmoother),'-','Color',mypurp,'LineWidth',LW);
chadfig2('Year','Pareto Inequality,\eta',1,0);
text(1987.35,.48,'Wages and salaries');
text(1988,.61,'Both');
text(1984,.67,'Entrepreneurial income');
print('-depsc','SSInequalitySolvingIRS');

diary off;