% SaezCompositionFigure
%
% This is the updated Figure 3 from Atkinsonk, Piketty, Saez 2010 JEL
% originally from Piketty-Saez (2003).
%
% These data come from the Saez spreadsheet for the Piketty-Saez 2003 QJE
% paper from Emmanuel's web page:
%
%   http://eml.berkeley.edu/~saez/TabFig2015prel.xls
%   See SaezInequalitySpreadsheet-Oct2016.xls "data-Fig4B" tab.


if exist('SaezCompositionFigure.log'); delete('SaezCompositionFigure.log'); end;
diary SaezCompositionFigure.log;
fprintf(['SaezCompositionFigure                 ' date]);
disp ' ';
disp ' ';
help SaezCompositionFigure

%	Figure 4											
%	Top 0.1% share	Capital Gains	Capital Income	Business Income	Salaries							
data=[% Total   KG      KI      Bus     Salary
% 1916	0.1051	0.0114	0.0576	0.0265	0.0096	
% 1917	0.0840	0.0025	0.0559	0.0130	0.0126	
% 1918	0.0672	0.0012	0.0384	0.0148	0.0126	
% 1919	0.0663	0.0045	0.0311	0.0190	0.0117	
% 1920	0.0536	0.0018	0.0276	0.0132	0.0109	
% 1921	0.0560	0.0014	0.0302	0.0118	0.0126	
% 1922	0.0664	0.0082	0.0349	0.0116	0.0117	
% 1923	0.0591	0.0073	0.0322	0.0092	0.0105	
% 1924	0.0679	0.0107	0.0358	0.0099	0.0115	
% 1925	0.0852	0.0255	0.0365	0.0120	0.0111	
% 1926	0.0846	0.0211	0.0416	0.0104	0.0115	
% 1927	0.0925	0.0263	0.0434	0.0112	0.0116	
% 1928	0.1154	0.0461	0.0437	0.0141	0.0115	
% 1929	0.1091	0.0442	0.0429	0.0117	0.0103	
% 1930	0.0707	0.0113	0.0417	0.0064	0.0114	
% 1931	0.0589	0.0045	0.0369	0.0056	0.0119	
% 1932	0.0597	0.0021	0.0368	0.0060	0.0148	
% 1933	0.0661	0.0089	0.0322	0.0095	0.0155	
% 1934	0.0613	0.0029	0.0353	0.0079	0.0152	
% 1935	0.0639	0.0064	0.0344	0.0085	0.0146	
% 1936	0.0757	0.0105	0.0419	0.0095	0.0137	
% 1937	0.0649	0.0033	0.0400	0.0077	0.0139	
% 1938	0.0588	0.0075	0.0283	0.0080	0.0151	
% 1939	0.0587	0.0042	0.0317	0.0083	0.0145	
% 1940	0.0601	0.0042	0.0314	0.0092	0.0152	
% 1941	0.0581	0.0051	0.0248	0.0133	0.0148	
% 1942	0.0481	0.0030	0.0159	0.0177	0.0114	
% 1943	0.0426	0.0050	0.0121	0.0176	0.0080	
% 1944	0.0376	0.0044	0.0107	0.0152	0.0073	
% 1945	0.0416	0.0097	0.0104	0.0145	0.0070	
% 1946	0.0439	0.0115	0.0121	0.0125	0.0077	
% 1947	0.0392	0.0077	0.0137	0.0097	0.0081	
% 1948	0.0406	0.0069	0.0151	0.0098	0.0088	
% 1949	0.0383	0.0052	0.0156	0.0082	0.0092	
1950	0.0439	0.0099	0.0164	0.0091	0.0085	
1951	0.0389	0.0087	0.0138	0.0081	0.0083	
1952	0.0343	0.0074	0.0127	0.0066	0.0076	
1953	0.0306	0.0059	0.0112	0.0060	0.0075	
1954	0.0349	0.0106	0.0116	0.0055	0.0072	
1955	0.0371	0.0146	0.0115	0.0045	0.0065	
1956	0.0349	0.0130	0.0115	0.0039	0.0065	
1957	0.0318	0.0093	0.0116	0.0044	0.0065	
1958	0.0322	0.0107	0.0110	0.0041	0.0064	
1959	0.0345	0.0153	0.0098	0.0039	0.0056	
1960	0.0325	0.0137	0.0098	0.0032	0.0058	
1961	0.0365	0.0199	0.0085	0.0031	0.0050	
1962	0.0319	0.0145	0.0092	0.0031	0.0052	
1963	0.0315	0.0142	0.0092	0.0030	0.0050	
1964	0.0337	0.0172	0.0087	0.0030	0.0048	
1965	0.0366	0.0202	0.0084	0.0031	0.0048	
1966	0.0339	0.0165	0.0082	0.0041	0.0052	
1967	0.0368	0.0196	0.0077	0.0042	0.0052	
1968	0.0402	0.0241	0.0079	0.0035	0.0047	
1969	0.0369	0.0216	0.0071	0.0033	0.0049	
1970	0.0278	0.0116	0.0072	0.0037	0.0052	
1971	0.0299	0.0146	0.0066	0.0035	0.0052	
1972	0.0313	0.0167	0.0060	0.0032	0.0055	
1973	0.0276	0.0128	0.0061	0.0033	0.0055	
1974	0.0273	0.0096	0.0073	0.0040	0.0064	
1975	0.0256	0.0081	0.0068	0.0036	0.0071	
1976	0.0259	0.0088	0.0065	0.0032	0.0074	
1977	0.0271	0.0101	0.0063	0.0030	0.0077	
1978	0.0265	0.0091	0.0065	0.0029	0.0080	
1979	0.0344	0.0174	0.0066	0.0024	0.0080	
1980	0.0341	0.0166	0.0071	0.0018	0.0086	
1981	0.0357	0.0185	0.0077	0.0008	0.0087	
1982	0.0418	0.0223	0.0086	0.0015	0.0092	
1983	0.0462	0.0262	0.0075	0.0024	0.0100	
1984	0.0498	0.0277	0.0075	0.0027	0.0119	
1985	0.0532	0.0312	0.0085	0.0034	0.0101	
1986	0.0740	0.0561	0.0065	0.0026	0.0088	
1987	0.0490	0.0173	0.0081	0.0070	0.0166	
1988	0.0680	0.0225	0.0113	0.0122	0.0220	
1989	0.0600	0.0181	0.0117	0.0120	0.0182	
1990	0.0582	0.0136	0.0120	0.0122	0.0204	
1991	0.0512	0.0110	0.0111	0.0118	0.0174	
1992	0.0603	0.0122	0.0093	0.0133	0.0256	
1993	0.0573	0.0145	0.0082	0.0128	0.0219	
1994	0.0570	0.0145	0.0084	0.0153	0.0189	
1995	0.0621	0.0167	0.0083	0.0159	0.0211	
1996	0.0724	0.0254	0.0082	0.0162	0.0226	
1997	0.0819	0.0318	0.0082	0.0167	0.0252	
1998	0.0900	0.0382	0.0078	0.0164	0.0275	
1999	0.0962	0.0413	0.0075	0.0165	0.0309	
2000	0.1088	0.0496	0.0083	0.0161	0.0348	
2001	0.0837	0.0281	0.0082	0.0175	0.0298	
2002	0.0734	0.0204	0.0084	0.0183	0.0262	
2003	0.0787	0.0247	0.0093	0.0189	0.0257	
2004	0.0947	0.0359	0.0111	0.0202	0.0275	
2005	0.1098	0.0456	0.0129	0.0238	0.0275	
2006	0.1159	0.0506	0.0150	0.0232	0.0271	
2007	0.1228	0.0566	0.0167	0.0204	0.0290	
2008	0.1040	0.0354	0.0154	0.0237	0.0295	
2009	0.0830	0.0185	0.0123	0.0256	0.0265	
2010	0.0966	0.0296	0.0139	0.0245	0.0286	
2011	0.0927	0.0283	0.0121	0.0237	0.0286	
2012	0.1171	0.0443	0.0168	0.0258	0.0303	
2013	0.0943	0.0285	0.0126	0.0254	0.0278	
2014	0.1047	0.0394	0.0134	0.0248	0.0271	
2015	0.1090	0.0438	0.0144	0.0251	0.0258	
%2016	0.0000	0.0000	0.0000	0.0000	0.0000	
];
%        Total   KG      KI      Bus     Salary 

years=data(:,1);
total=data(:,2);
kg=data(:,3);
ki=data(:,4);
bus=data(:,5);
wage=data(:,6);

series=[wage bus ki kg]*100;


figure(1); figsetup; makefigwide;
cmap=colormap(winter);
colormap(2/3+cmap/3);
area(years,series); hold on;
relabelaxis([0 2 4 6 8 10 12 14],strmat('0% 2% 4% 6% 8% 10% 12% 14%'));
chadfig2('Year','Top 0.1 percent income share',1,0);
text(1994,1.1,'Wages and Salaries','BackgroundColor','white','Margin',2);
%text(2003.5,4.2,mlstring('Business\\ income'),'BackgroundColor','white');
text(2002,3.7,'Business income','BackgroundColor','white','Margin',2);
%text(1955,1.7,'Capital income','BackgroundColor','white');
text(1955,4.6,'Capital income');
text(1985.5,9,'Capital gains');
set(gca,'Layer','top');
line([1993 1998],[8.3 7],'Color','k','LineWidth',1)
line([1959 1956],[4.0 1.8],'Color','k','LineWidth',1)
%wait;
print SaezCompositionFigure.eps



diary off;
