% SetParamsIdeaModel   
%
% Baseline parameter values for IdeaModel*.m solutions

% Baseline values
rho=.01
theta=2/3 
piH=0.05 %.025  % Percent of entrepreneurs who are high-growth types in stationary distn
Lbar=30  % 28 23   14
lambda=.020  % .021   .025   .037
alpha=(1-theta)/theta

Gamma=1.4 %exp(1)
Sigma=.15
DltaBar=0.08  
MBar=0.6
ZBar=0.2
Tau=0.2
PBar=1.5   %0.767 was version 2.0
qbar=(PBar+DltaBar)/DltaBar*piH  % Chosen to match piH
Omega=1-Tau




% Choose beta and phi s.t. eH=1/2 and mutilde=1/3 at the start
%  1/2 time endowment working for entrepreneurs = 12*7 = 84 hours per week
%  mutildeH=1/3 needed to get eta=1/3 at start.
% eHTarget=1/2
% mutildeTarget=1  %.4875
% Phi=1/eHTarget*(mutildeTarget+1/2*Sigma^2)
% Beta=(eHTarget-Tau)*Phi/(rho+DltaBar+.02/log(Gamma))

Beta=1
Phi=0.955 % .936




lbar=Lbar;
phi=Phi;
phiH=Phi;
beta=Beta;
gamma=Gamma;
sigma=Sigma;
sigmaH=Sigma;
sigmaL=2/3*Sigma;
PhiL=(Beta.*(rho+.02./log(Gamma)+DltaBar)+.5*sigmaL.^2)./Omega;
phiL=PhiL;
dltaBar=DltaBar;
mBar=MBar;
zBar=ZBar;
tau=Tau;
pBar=PBar;

LW=3; % LineWidth for plots

