% cpiSaez  10/13/14
%
%  Contains the Saez CPI and mean income numbers (excluding cap gains)
%  from the extended spreadsheet for the original Piketty-Saez 2003 paper.
%
% From SaezMeanIncomeandCPI-2014-Oct.xls
% (copied originally from SaezInequalitySpreadsheet-Sep2013.xls)

% Table A0: Reference totals for tax units and income			
% 		Inflation	
% 	(5)	(8)	'=1/(8)*100
% Year	Average income	CPI-U-RS	CPI-U-RS
% 	(latest year $)	index	index

datablah=[        
1913	15571	21.2457	4.7068326241
1914	15213	20.9634	4.7702243093
1915	15360	20.7565	4.8177680732
1916	16710	19.2966	5.1822702629
1917	17018	16.4322	6.0856017766
1918	16107	13.9911	7.1474125033
1919	15775	12.1814	8.2092232299
1920	14068	10.5166	9.508752776
1921	12412	11.7723	8.4944858132
1922	14014	12.5697	7.9556564892
1923	15588	12.3483	8.0982877809
1924	15402	12.3242	8.1141357022
1925	15554	12.0190	8.320158679
1926	15723	11.9056	8.3993982854
1927	15839	12.1346	8.2409190725
1928	16171	12.3001	8.1299836234
1929	16860	12.3001	8.1299836234
1930	15281	12.6200	7.9239606466
1931	13865	13.8377	7.2266521097
1932	11662	15.4278	6.4817998089
1933	11362	16.2628	6.1489934618
1934	12485	15.7356	6.3550164386
1935	13519	15.3527	6.5134956515
1936	14842	15.2048	6.5768873367
1937	15563	14.6744	6.8146061561
1938	14309	14.9525	6.6878227858
1939	15249	15.1682	6.592735258
1940	15972	15.0238	6.6561269432
1941	18668	14.3083	6.9889332903
1942	21697	12.9303	7.7337855911
1943	25078	12.1814	8.2092232299
1944	24780	11.9734	8.3518545216
1945	24255	11.7068	8.5420295771
1946	24411	10.7863	9.2710339566
1947	23574	9.4320	10.6022593452
1948	23996	8.7517	11.4263512524
1949	23697	8.8375	11.3154158034
1950	25583	8.7517	11.4263512524
1951	26357	8.1105	12.3296827662
1952	27199	7.9371	12.5990974281
1953	28410	7.8776	12.6941849559
1954	28066	7.8385	12.7575766411
1955	29994	7.8678	12.7100328772
1956	31553	7.7518	12.9002079327
1957	31697	7.4851	13.3597976502
1958	30726	7.2863	13.72429984
1959	32574	7.2363	13.8192776935
1960	32942	7.1140	14.0567223274
1961	33327	7.0427	14.1991891078
1962	34544	6.9727	14.3416558881
1963	35410	6.8815	14.5316115953
1964	37117	6.7928	14.7215673024
1965	38638	6.6849	14.9590119363
1966	40348	6.4992	15.3864122773
1967	41328	6.3047	15.8613015452
1968	42683	6.0510	16.5261465201
1969	43307	5.7377	17.428436129
1970	43544	5.4272	18.4257035914
1971	43425	5.1994	19.2330153467
1972	45226	5.0377	19.8503713948
1973	46166	4.7427	21.0850834912
1974	44783	4.2713	23.4120409035
1975	42422	3.9140	25.5490426087
1976	43442	3.7008	27.0211993389
1977	43872	3.4748	28.7782896298
1978	44693	3.2297	30.9627802618
1979	44648	2.9474	33.9285638118
1980	43452	2.6529	37.6951089203
1981	43077	2.4223	41.2837070157
1982	42214	2.2844	43.7749651977
1983	41797	2.1909	45.6434088342
1984	43203	2.1047	47.5118524707
1985	43968	2.0349	49.1430334232
1986	44557	1.9987	50.0327684882
1987	45810	1.9334	51.7232651117
1988	48081	1.8649	53.6213665837
1989	47932	1.7878	55.9346777526
1990	47595	1.7029	58.7225142896
1991	46233	1.6440	60.8282206101
1992	46620	1.6033	62.3704280561
1993	45933	1.5646	63.9126355021
1994	46742	1.5319	65.2768959351
1995	48084	1.4959	66.8487612166
1996	49200	1.4571	68.6282313466
1997	51147	1.4263	70.1111231216
1998	53634	1.4067	71.089831693
1999	55743	1.3779	72.572723468
2000	56635	1.3333	75.004665979
2001	55305	1.2968	77.1103722995
2002	53196	1.2762	78.3560013905
2003	52466	1.2483	80.105813685
2004	53888	1.2155	82.2708356765
2005	55064	1.1761	85.029014378
2006	56080	1.1387	87.8168509149
2007	57669	1.1073	90.3081090969
2008	54657	1.0664	93.7755342039
2009	51436	1.0702	93.4419017919
2010	51737	1.0529	94.9746073504
2011	51363	1.0207	97.9725079924
2012	52840	1.0000	100
];

cpiyrs=datablah(:,1);
SaezMeanIncome=datablah(:,2);
cpi=datablah(:,4);  % 2012 = 100


% Note well: column (3) is the original Saez CPI.  I compute
%  1/Saez*100 to make it a "standard" cpi index.