function [eta,speedofconvergence,mutilde,sigma,pbar,delta_e,smootheddata]=guveneneta(probstayhigh,growthtop,stdevtop,delta_e,deltaCD,myyears,yr0,PermTransVar,HPsmoother,xi,YearsToSmooth);

% Pass the unsmoothed versions of these series
%  -- smooth with with HP filter
%  -- use myyears to compute eta
%
%  Speed of convergence: From equation (29) of GLLM, p. 26 of 2016 draft
%     lambda(xi) = xi*muH - xi^2 * sigmaH^2/2 + pbar + deltabar
%     (can pass a vector of xi to return a vector of lambdas)

if exist('YearsToSmooth');
    tt=YearsToSmooth;
else;
    tt=(1:length(growthtop));
end;

growthtop1smooth=hpfilter(growthtop(tt),HPsmoother);
mutilde=growthtop1smooth(myyears-yr0);

% Fraction of variance that is due to the permanent shock
sigmasmooth=sqrt(PermTransVar)*hpfilter(stdevtop(tt),HPsmoother);
sigma=sigmasmooth(myyears-yr0);


delta_esmooth=hpfilter(delta_e(tt),HPsmoother);
delta_e=delta_esmooth(myyears-yr0);
deltabar=delta_e-deltaCD;

% pbar = -log(ProbStayHigh)-delta_e
probstayhighsmooth=hpfilter(packr(probstayhigh(tt)),HPsmoother);
pbar = -log(probstayhighsmooth(myyears-yr0))-delta_e;
% pbarsimple=-log(probstayhighsmooth(myyears-yr0));
% ProbTransit=1-probstayhighsmooth(myyears-yr0);
%pbar=zeros(length(myyears),1);
% for t=1:length(myyears);
%     fpbar=@(p) pbarequation(p,ProbTransit(t),delta_e(t));
%     pbar(t)=fzero(fpbar,pbarsimple(t));
% end;

tt2=myyears-yr0;
smootheddata=[growthtop1smooth(tt2) sigmasmooth(tt2) delta_esmooth(tt2) probstayhighsmooth(tt2)];

muhat=mutilde./sigma.^2;
squig=-muhat+sqrt(muhat.^2+2*(deltabar+pbar)./sigma.^2);
eta=1./squig;

if sigma(1)==0;  % Role of Luck?
    eta=mutilde./(deltabar+pbar);
end;


disp 'Eta';
tle='Year Eta mutilde sigma pbar delta_e';
cshow(' ',[myyears eta mutilde sigma pbar delta_e],'%6.0f %10.4f',tle);
disp ' ';

if exist('xi')~=0; if ~isempty(xi);
    lambda=zeros(length(myyears),length(xi));
    for i=1:length(xi);
        lambda(:,i) = xi(i)*mutilde - xi(i)^2 * sigma.^2/2 + pbar + deltabar;
        fprintf('Convergence speed info:   xi = %4.2f   Avg. lambda = %5.3f  Implied 1/2-life = %5.3f\n',[xi(i) mean(lambda(:,i)) log(2)./(mean(lambda(:,i)))]);
    end;
    speedofconvergence=lambda;
    disp ' ';
    cshow(' ',[myyears lambda log(2)./lambda],'%8.0f %12.3f','Year lambda(-1) lambda(-1.5) 1/2-life 1/2-life');
    disp ' ';
else;
    speedofconvergence=[];
end; end;


% function e=pbarequation(pbar,Prob,delta_e);

% %e=Prob-pbar/(pbar+delta_e)*(1-exp(-(pbar+delta_e)));
% e=Prob-(1-exp(-(pbar+delta_e)));