function []=dynamicarrow(x,y,num,varargin);

%function []=dynamicarrow(x,y,num,varargin)
%
%  Draws "dynamic arrows" (like Solow diagram) along the curve (x,y)
%  num = number of arrows to draw
%
%  Examples:
%    dynamicarrow(x,n,5,'BaseAngle',25,'TipAngle',30,'Length',20);   % length in pixels
%    dynamicarrow(flipud(x),flipud(n),5,'BaseAngle',25,'TipAngle',30); % Reverse Direction
%
%  (Earlier function dynarrow.m only drew along a line. This
%   generalizes to any curve.)

if exist('baseangle')~=1; angle=25; end;  % width of arrow
if exist('tipangle')~=1; angle=25; end;  % width of arrow
    
hold on;
xmin=min(x);
xmax=max(x);
xstep=(xmax-xmin)/(num+1);
direction=(-1)^(xstep<0);
xvals=xmin +(1:num)'*xstep;
yvals=interp1(x,y,xvals);



for i=1:num;
    xx=xvals(i);
    yy=yvals(i);
    [d, indx] = min(abs(x-xx));
    if direction>0; indx=indx+1; end;
    if direction<0; indx=indx-1; end;
    chadarrow( [xx yy],[x(indx) y(indx)], varargin{:} );
end;


% sl=(b(2)-a(2))/(b(1)-a(1));  % slope = rise/run
% %dist=sqrt( (b(1)-a(1))^2 + (b(2)-a(2))^2);  % total distance
% %step=dist/(num+1);
% xstep=(b(1)-a(1))/(num+1);
% ystep=(b(2)-a(2))/(num+1);
% start=[a(1)+.5*xstep a(2)+.5*ystep];


% for i=1:num;
%   next=[start(1)+xstep start(2)+ystep];
%   chadarrow(start,next,angle);
%   start=next;
% end;
