function [xavg,newyrs]=movingaverage(x,num,yrs,usenansum);

% function [xavg,newyrs]=movingaverage(x,num,yrs);
%
%    x = data, TxN
%
%  num = number of years on either side to average, e.g. 1 ==> -1,0,+1
%        (alternatively, if num=[numleft numright] then take 
%         numleft years earlier and numright years later in averaging
%        e.g. numleft=2, numright=1 ==> -2,-1,0,+1
%
%  yrs = original years (length T)
%        ==> newyrs = new dates corresponding to xavg
%        length(xavg)=T-numleft-numright
%
%  usenansum == 1 ==> use nansum instead of sum to average

if size(num)==1;
    numleft=num;
    numright=num;
end;
if exist('usenansum')~=1; usenansum=0; end;

[T,N]=size(x);
Tnew=T-numleft-numright;

for t=(1+numleft):(T-numright);
    if usenansum==0;
        xavg(t-numleft,:)=sum(x(t-numleft:t+numright,:))/(1+numleft+numright);
    else;
        xavg(t-numleft,:)=nansum(x(t-numleft:t+numright,:))/(1+numleft+numright);
    end;
    
end;


if exist('yrs')==1;
    newyrs=trimr(yrs,numleft,numright);
else;
    newyrs=[];
end;