% calibration_RevMax.m
%
%  3/2/17 -- RevMax calibration of simple Saez+Ideas model
%   Revenue-maximizing top tax rate
%  3/25/19 -- include psi (managers)
%
%  11/18/20 -- zeta_u = Behavioral Elasticity

if exist('CaseName');
    diarychad(['calibration_RevMax_' CaseName]);
else;
    diarychad('calibration_RevMax');
end;

ShowParameters
%stuff=(1-drho)/drho

for i=1:length(BehaviorElasticities);

    behavior_elas = BehaviorElasticities(i);
    disp '==================================================================';
    fprintf('Top earner behavioral elasticity = %4.2f\n',behavior_elas);
    disp '==================================================================';
    zeta_u=behavior_elas;   %Vs old setup of behavior_elas/(1+behavior_elas);
    etaY=(gamma+psi)*zeta_u;
    etapsi=psi*zeta_u*ones(size(gamma));
    tau     = (1-tau0*stuff*etaY) ./ (1+pareto*etaY);
    taupsi  = (1-tau0*stuff*etapsi) ./ (1+pareto*etapsi); % gamma=0
    tauzero = 1 ./ (1+pareto*etapsi);   % gamma=0 and tau0=0 = Saez w/ PsiGE effect
    keep=1-tau;
    keep0=1-tauzero;
    keeppsi=1-taupsi;
    cshow(' ',[gamma tauzero taupsi tau keep0 keeppsi keep],'%6.2f %10.2f','gamma tauzero taupsi tau keep0 keeppsi keep'); %,'latex');
    disp ' '; 
    ds=1/(1+pareto*zeta_u);
    fprintf('The simple Diamond-Saez formula gives tau = %10.2f\n',ds);
    disp ' '; disp ' ';
    TauSummary(:,i)=tau;
end;

disp '///////////////////////////////////////////////////////////';
disp 'Summary of Key Results for tau (Revenue-Maximizing Case):';
disp '   for different values of zeta_u';
disp '///////////////////////////////////////////////////////////';
tle=['gamma ' num2str(BehaviorElasticities,'%4.1f')];
cshow(' ',[gamma TauSummary],'%6.2f %10.2f',tle,'latex');
disp ' ';
disp ' ';

diary off
