% calibration_SWF.m
%
%  3/14/17 -- SWF calibration of simple Saez+Ideas model 
%   Local functions in Matlab2017! Be sure to leave off ";" after "end" 
%  8/9/18 -- 
%   CE welfare calculations as well. 
%   CEW_adj = 1-x: What fraction of consumption do
%   you have to take away from people in the optimal allocation in order to
%   make them indifferent to having a 75% top tax rate, e.g.
%  8/22/18 -- Fix the Saez pareto problem.
%  2/22/19 -- fixed another problem: replace "1-alpha(1-zeta)" with "1-alpha"
%  3/25/19 -- managers psi included
%  11/18/20 -- zeta_u = Behavioral Elasticity

if exist('CaseName');
    diarychad(['calibration_SWF_' CaseName]);
else;
    diarychad('calibration_SWF');
end;
ShowParameters

taufixed = 3/4

for i=1:length(Alpha);
    alpha=Alpha(i);
    disp ' '; disp ' ';
    disp '//////////////////////////////////////////////////////////////';
    fprintf('               /// alpha = %3.1f /// \n',alpha);
    disp '//////////////////////////////////////////////////////////////';

    for b=1:length(BehaviorElasticities);
        behavior_elas = BehaviorElasticities(b);
        [tau,tau0]=solve(gamma,Omega,drho,behavior_elas,alpha,s,ell,taufixed,rho,psi);
        TauSummary(:,b) =tau;
        Tau0Summary(:,b)=tau0;
    end;

    disp ' ';
    disp ' ';
    disp '///////////////////////////////////////////////////////////';
    fprintf('Summary of Key Results for tau (SWF Case): alpha = %3.1f\n',alpha);
    disp '   for different values of zeta_u';
    disp '///////////////////////////////////////////////////////////';
    tle=['gamma ' num2str(BehaviorElasticities,'%4.1f')];
    disp ' ';
    disp 'First, the values of the bottom rate tau0:';
    cshow(' ',[gamma Tau0Summary],'%6.2f %10.2f',tle,'latex');
    disp ' ';
    disp 'And the values for the top tax rate tau:';
    cshow(' ',[gamma TauSummary],'%6.2f %10.2f',tle,'latex');
    disp ' ';
    disp ' ';
end; 
   
diary off


function [tau,tau0]=solve(gamma,Omega,drho,behavior_elas,alpha,s,ell,taufixed,rho,psi);
    disp ' '; 
    disp '     ==================================================================';
    fprintf('     Top earner behavioral elasticity = %4.2f\n',behavior_elas);
    disp '     ==================================================================';
    tau=zeros(size(gamma)); tau0=tau;
    x=zeros(length(gamma),2); % [CEwelfare Yloss]
    
    for j=1:length(gamma);
        f=@(kappa) kappafunc(kappa,gamma(j),Omega,drho,behavior_elas,alpha,s,ell,rho,psi);
        kappa=fzerochad(f,[0 1],1.5);
        [e,kappa0]=kappafunc(kappa,gamma(j),Omega,drho,behavior_elas,alpha,s,ell,rho,psi);
    
        tau(j) = 1-kappa;
        tau0(j)= 1-kappa0;
        
        x(j,:)=CEwelfare(tau0(j),tau(j),taufixed,gamma(j),Omega,drho,behavior_elas,alpha,s,ell,psi);
    end;
    keep=1-tau;
    keep0=1-tau0;
    cew_adj=1-x(:,1);
    fmt='%6.2f %10.2f %10.2f %10.1f %10.1f';
    %cshow(' ',[gamma tau keep tau0 keep0 100*cew_adj 100*x(:,2)],'%6.2f %10.2f','gamma tau keep tau0 keep0 cew_adj Yloss','latex');
    cshow(' ',[gamma tau tau0 100*cew_adj 100*x(:,2)],fmt,'gamma tau tau0 cew_adj Yloss','latex');
end


function [e,kappa0]=kappafunc(kappa,gamma,Omega,drho,behavior_elas,alpha,s,ell,rho,psi);
    kappa0=(1-Omega - kappa*drho)/(1-drho);
    zeta_u=behavior_elas; % OLD: behavior_elas/(1+behavior_elas);
    etaY=(gamma+psi)*zeta_u;
    rhobar=rho-drho;
    % See Proposition 2 for the key equation:
    LHS=s*zeta_u*kappa^alpha + kappa/kappa0*ell/(1-drho)*(drho+etaY*rhobar);
    RHS=s*(1-alpha)+etaY*(1+ell*rhobar/(1-drho));
    e=LHS-RHS;    
end


function x=CEwelfare(tau0opt,tauopt,taufixed,gamma,Omega,drho,behavior_elas,alpha,s,ell,psi);
    zeta_u=behavior_elas; % OLD /(1+behavior_elas);
    %etaY=gamma*zeta_u;   % OLD error in Version 2 omitted psi from this calculation!
    etaY=(gamma+psi)*zeta_u;
    % Compute tau0fixed to satisfy the GovtBC given taufixed
    tau0fixed=(Omega-taufixed*drho)/(1-drho);
    
    Yopt=(1-tauopt)^etaY; % Ignoring multiplicative constant
    SWFopt=log(Yopt)+ell*log(1-tau0opt)+s*( (1-alpha)*log(1-tauopt)-zeta_u/alpha*(1-tauopt)^alpha);
    Yfixed=(1-taufixed)^etaY; % Ignoring multiplicative constant
    SWFfixed=log(Yfixed)+ell*log(1-tau0fixed)+s*( (1-alpha)*log(1-taufixed)-zeta_u/alpha*(1-taufixed)^alpha);
    
    % CE welfare
    logx1 = SWFfixed-SWFopt;
    x1=exp(logx1); 
    
    % Output loss
    x2=1-Yfixed/Yopt;
    
    x=[x1 x2];
end
