'''
Created on Jun 27, 2013

@author: Chris
'''

from Puzzle import Puzzle
from Path import Path
from sets import Set
import Queue

class BfsSolver(object):
    
    # Function: Constructor
    # ---------------------
    # Set the counter of nodes expanded
    # to be zero.
    def __init__(self):
        self.nodesExpanded = 0
    
    # Function: Run
    # ---------------------
    # Create an instance of a N-Puzzle problem,
    # call the solver, and report the solution
    def run(self):
        '''pieces = [
            [1, ' ', 3],
            [8, 4, 5],
            [7, 2, 6]
        ]'''
        puzzle = Puzzle()
        puzzle.printPuzzle()
        print 'Find solution...'
        path = self.getPath(puzzle)
        print ''
        print 'Solution found!'
        print 'Solution length: ' + str(len(path.actions))
        print 'Nodes expanded: ' + str(self.nodesExpanded)
        print 'Solution:'
        for action in path.actions:
            print action
        
    # Function: Report Nodes Expanded
    # ---------------------
    # Prints to the console if the number of
    # nodes expanded so far is a multiple of 1000
    def reportNodesExpanded(self):
        if self.nodesExpanded % 1000 == 0:
            print str(self.nodesExpanded)
        
    # Function: Get Path
    # ---------------------
    # Finds the shortest path from the start state
    # to the solution 
    def getPath(self, startState):
        fringe = Queue.Queue()
        startPath = Path()
        startPath.setStartState(startState)
        fringe.put(startPath)
        visited = Set([])
        while not fringe.empty(): 
            currPath = fringe.get()
            currState = currPath.getLastState()
            if currState.isSolution(): return currPath
            if currState in visited: continue
            visited.add(currState)
            for action in currState.getLegalActions():
                successor = currState.getSuccessorState(action)
                newPath = Path(currPath)
                newPath.addAction(action, successor)
                fringe.put(newPath)
            self.nodesExpanded += 1
            self.reportNodesExpanded()
            
        return None



if __name__ == "__main__":
    BfsSolver().run()